/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.car.blocks.tileentity.TileEntityEnergyFluidProducer;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerEnergyFluidProducer;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public abstract class GuiEnergyFluidProducer<T extends ContainerEnergyFluidProducer>
extends ScreenBase<T> {
    private Inventory playerInv;
    private TileEntityEnergyFluidProducer tile;

    public GuiEnergyFluidProducer(ResourceLocation texture, T container, Inventory playerInventory, Component title) {
        super(texture, container, playerInventory, title);
        this.playerInv = playerInventory;
        this.tile = ((ContainerEnergyFluidProducer)((Object)container)).getTile();
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    public String getUnlocalizedTooltipEnergy() {
        return "tooltip.energy";
    }

    public String getUnlocalizedTooltipProgress() {
        return "tooltip.progress";
    }

    public abstract String getUnlocalizedTooltipLiquid();

    @Override
    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        super.m_7027_(matrixStack, mouseX, mouseY);
        this.f_96547_.m_92877_(matrixStack, this.m_96636_().m_7532_(), 38.0f, 6.0f, 0x404040);
        this.f_96547_.m_92877_(matrixStack, this.playerInv.m_5446_().m_7532_(), 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
        if (mouseX >= this.f_97735_ + 11 && mouseX <= this.f_97735_ + 16 + 11 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(Component.m_237110_((String)this.getUnlocalizedTooltipEnergy(), (Object[])new Object[]{this.tile.getStoredEnergy()}).m_7532_());
            this.m_96617_(matrixStack, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 148 && mouseX <= this.f_97735_ + 16 + 148 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)this.getUnlocalizedTooltipLiquid(), (Object[])new Object[]{this.tile.getCurrentMillibuckets()}).m_7532_());
            this.m_96617_(matrixStack, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 79 && mouseX <= this.f_97735_ + 24 + 79 && mouseY >= this.f_97736_ + 34 && mouseY <= this.f_97736_ + 17 + 34) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)this.getUnlocalizedTooltipProgress(), (Object[])new Object[]{(int)(this.getProgress() * 100.0f)}).m_7532_());
            this.m_96617_(matrixStack, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    public void drawEnergy(PoseStack matrixStack) {
        float perc = this.getEnergy();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 11;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawFluid(PoseStack matrixStack) {
        float perc = this.getFluid();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 148;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawProgress(PoseStack matrixStack) {
        float perc = this.getProgress();
        int texX = 176;
        int texY = 0;
        int texW = 24;
        int texH = 17;
        int targetX = 79;
        int targetY = 34;
        int scWidth = (int)((float)texW * perc);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + targetX, j + targetY, texX, texY, scWidth, texH);
    }

    public float getEnergy() {
        return (float)this.tile.getStoredEnergy() / (float)this.tile.getMaxEnergy();
    }

    public float getFluid() {
        return (float)this.tile.getCurrentMillibuckets() / (float)this.tile.getFluidAmount();
    }

    public float getProgress() {
        if (this.tile.getTimeToGenerate() == 0) {
            return 0.0f;
        }
        return (float)this.tile.getGeneratingTime() / (float)this.tile.getTimeToGenerate();
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.drawEnergy(matrixStack);
        this.drawFluid(matrixStack);
        this.drawProgress(matrixStack);
    }

    public boolean m_7043_() {
        return false;
    }
}

