/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.ftbquests.recipemod_common;

import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class WrappedLootCrate {
    public static final int ITEMSX = 8;
    public static final int ITEMSY = 6;
    public static final int ITEMS = 48;
    public final LootCrate crate;
    public final ItemStack crateStack;
    public final List<WeightedReward> sortedRewards;
    public final List<ItemStack> outputs;
    private final List<List<ItemStack>> cycledOutputs;

    public WrappedLootCrate(LootCrate c) {
        this.crate = c;
        this.crateStack = this.crate.createStack();
        this.outputs = new ArrayList<ItemStack>(c.table.rewards.size());
        this.sortedRewards = c.table.rewards.stream().sorted(WeightedReward::compareTo).toList();
        for (WeightedReward reward : this.sortedRewards) {
            ItemStack stack;
            Object object = reward.reward.getIngredient();
            ItemStack itemStack = stack = object instanceof ItemStack ? (ItemStack)object : ItemStack.f_41583_;
            if (!stack.m_41619_()) {
                this.outputs.add(stack.m_41777_());
                continue;
            }
            if (reward.reward.getIcon() instanceof ItemIcon) {
                stack = ((ItemIcon)reward.reward.getIcon()).getStack().m_41777_();
                stack.m_41714_(reward.reward.getTitle());
                this.outputs.add(stack);
                continue;
            }
            stack = new ItemStack((ItemLike)Items.f_42487_);
            stack.m_41714_(reward.reward.getTitle());
            stack.m_41700_("icon", (Tag)StringTag.m_129297_((String)reward.reward.getIcon().toString()));
            this.outputs.add(stack);
        }
        if (this.outputs.size() <= 48) {
            this.cycledOutputs = new ArrayList<List<ItemStack>>(this.outputs.size());
            for (ItemStack stack : this.outputs) {
                this.cycledOutputs.add(Collections.singletonList(stack));
            }
        } else {
            int i;
            this.cycledOutputs = new ArrayList<List<ItemStack>>(48);
            for (i = 0; i < 48; ++i) {
                this.cycledOutputs.add(new ArrayList());
            }
            for (i = 0; i < this.outputs.size(); ++i) {
                this.cycledOutputs.get(i % 48).add(this.outputs.get(i));
            }
        }
    }

    public List<Ingredient> inputIngredients() {
        return List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.crateStack}));
    }

    public List<Ingredient> outputIngredients() {
        return this.cycledOutputs.stream().map(items -> Ingredient.m_43927_((ItemStack[])items.toArray(new ItemStack[0]))).toList();
    }
}

