/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.client.rendering;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.blay09.mods.balm.api.client.rendering.BalmTextures;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ForgeBalmTextures
implements BalmTextures {
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();

    @Override
    public void addSprite(ResourceLocation atlas, ResourceLocation location) {
        this.getActiveRegistrations().textures.add(new TextureRegistration(atlas, location));
    }

    public void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.getActiveRegistrations());
    }

    private Registrations getActiveRegistrations() {
        return this.registrations.computeIfAbsent(ModLoadingContext.get().getActiveNamespace(), it -> new Registrations());
    }

    private static class Registrations {
        private final List<TextureRegistration> textures = new ArrayList<TextureRegistration>();

        private Registrations() {
        }

        @SubscribeEvent
        public void registerIconsPre(TextureStitchEvent.Pre event) {
            for (TextureRegistration texture : this.textures) {
                if (!event.getAtlas().m_118330_().equals((Object)texture.getAtlas())) continue;
                event.addSprite(texture.getLocation());
            }
        }
    }

    private static class TextureRegistration {
        private final ResourceLocation atlas;
        private final ResourceLocation location;

        public TextureRegistration(ResourceLocation atlas, ResourceLocation location) {
            this.atlas = atlas;
            this.location = location;
        }

        public ResourceLocation getAtlas() {
            return this.atlas;
        }

        public ResourceLocation getLocation() {
            return this.location;
        }
    }
}

