/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.EntityBear;
import dev.itsmeow.betteranimalsplus.common.entity.EntityPheasant;
import dev.itsmeow.betteranimalsplus.common.entity.ai.EntityAIEatBerries;
import dev.itsmeow.betteranimalsplus.common.entity.ai.HungerNearestAttackableTargetGoal;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.EntityVariant;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModLootTables;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class EntityBearNeutral
extends EntityBear
implements IVariantTypes<EntityBear> {
    public EntityBearNeutral(EntityType<? extends EntityBearNeutral> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EntityBear.BearMeleeAttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new EntityAIEatBerries((PathfinderMob)this, 1.0, 12, 2));
        this.f_21346_.m_25352_(1, (Goal)new EntityBear.BearHurtByTargetGoal());
        this.f_21346_.m_25352_(2, (Goal)new EntityBear.AttackPlayerGoal());
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(3, new HungerNearestAttackableTargetGoal<Chicken, EntityBearNeutral>(this, Chicken.class, true));
        this.f_21346_.m_25352_(4, new HungerNearestAttackableTargetGoal<Rabbit, EntityBearNeutral>(this, Rabbit.class, true));
        this.f_21346_.m_25352_(5, new HungerNearestAttackableTargetGoal<EntityPheasant, EntityBearNeutral>(this, EntityPheasant.class, 90, true, true, e -> true));
        this.f_21346_.m_25352_(4, new HungerNearestAttackableTargetGoal<Fox, EntityBearNeutral>(this, Fox.class, 90, true, true, e -> true));
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42527_ || stack.m_41720_() == Items.f_42531_ || stack.m_41720_() == Items.f_42784_;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingdata, CompoundTag compound) {
        this.setInitialHunger();
        if (livingdata instanceof IVariantTypes.AgeableTypeData) {
            this.m_146762_(-24000);
            this.setType(((IVariantTypes.AgeableTypeData)livingdata).typeData);
        } else {
            livingdata = this.initAgeableData((LevelAccessor)world, reason, null);
        }
        return livingdata;
    }

    @Override
    public IVariant getRandomType() {
        return this.getContainer().getVariantForName(this.m_217043_().m_188501_() <= 0.125f ? "kermode" : "black").orElse(IVariantTypes.super.getRandomType());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.registerTypeKey();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.writeType(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.readType(compound);
    }

    @Override
    protected ResourceLocation m_7582_() {
        switch (this.getVariantNameOrEmpty()) {
            case "black": {
                return ModLootTables.BEAR_BLACK;
            }
            case "kermode": {
                return ModLootTables.BEAR_KERMODE;
            }
        }
        return ModLootTables.BEAR_BLACK;
    }

    @Override
    public EntityTypeContainer<EntityBearNeutral> getContainer() {
        return ModEntities.BLACK_BEAR;
    }

    @Override
    public EntityBearNeutral getImplementation() {
        return this;
    }

    @Override
    public boolean m_6785_(double range) {
        return this.despawn(range);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        EntityBearNeutral child = (EntityBearNeutral)this.getContainer().getEntityType().m_20615_((Level)world);
        if (ageable instanceof EntityBearNeutral) {
            if ("kermode".equals(((EntityBearNeutral)ageable).getVariantNameOrEmpty()) && "kermode".equals(this.getVariantNameOrEmpty())) {
                child.setType("kermode");
            } else {
                child.setType("black");
            }
        } else {
            child.setType(this.getVariant().orElseGet(this::getRandomType));
        }
        return child;
    }

    public static class BlackBearVariant
    extends EntityVariant {
        private final ResourceLocation babyTexture;

        public BlackBearVariant(String nameTexture) {
            super("betteranimalsplus", nameTexture, "blackbear_" + nameTexture);
            this.babyTexture = new ResourceLocation("betteranimalsplus", "textures/entity/blackbear_" + nameTexture + "_baby.png");
        }

        @Override
        public ResourceLocation getTexture(Entity entity) {
            if (entity instanceof EntityBearNeutral && ((EntityBearNeutral)entity).m_6162_()) {
                return this.babyTexture;
            }
            return super.getTexture(entity);
        }
    }
}

