/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.client.ClientProxy;
import flaxbeard.immersivepetroleum.client.gui.elements.PipeConfig;
import flaxbeard.immersivepetroleum.common.ExternalModContent;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPMenuTypes;
import flaxbeard.immersivepetroleum.common.blocks.interfaces.ICanSkipGUI;
import flaxbeard.immersivepetroleum.common.blocks.stone.WellBlock;
import flaxbeard.immersivepetroleum.common.blocks.stone.WellPipeBlock;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.gui.IPMenuProvider;
import flaxbeard.immersivepetroleum.common.multiblocks.DerrickMultiblock;
import flaxbeard.immersivepetroleum.common.util.AABBUtils;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import flaxbeard.immersivepetroleum.common.util.RegistryUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;

public class DerrickTileEntity
extends PoweredMultiblockBlockEntity<DerrickTileEntity, MultiblockRecipe>
implements IPCommonTickableTile,
ICanSkipGUI,
IPMenuProvider<DerrickTileEntity>,
IEBlockInterfaces.IBlockBounds {
    public static final int REQUIRED_WATER_AMOUNT = 125;
    public static final int REQUIRED_CONCRETE_AMOUNT = 125;
    public static final FluidTank DUMMY_TANK = new FluidTank(0);
    public static final BlockPos Fluid_IN = new BlockPos(2, 0, 4);
    public static final BlockPos Fluid_OUT = new BlockPos(4, 0, 2);
    public static final Set<PoweredMultiblockBlockEntity.MultiblockFace> Energy_IN = ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(2, 1, 0, RelativeBlockFace.UP));
    public static final Set<BlockPos> Redstone_IN = ImmutableSet.of((Object)new BlockPos(0, 1, 1));
    public int timer = 0;
    public int rotation = 0;
    public boolean drilling;
    public boolean spilling;
    public final FluidTank tank = new FluidTank(8000, this::acceptsFluid);
    public final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    @Nullable
    public PipeConfig.Grid gridStorage;
    private Fluid fluidSpilled = Fluids.f_76191_;
    private int clientFlow;
    private static final BlockState[] PARTICLESTATES = new BlockState[]{Blocks.f_50069_.m_49966_(), Blocks.f_50122_.m_49966_(), Blocks.f_49994_.m_49966_(), Blocks.f_152550_.m_49966_(), Blocks.f_50228_.m_49966_(), Blocks.f_49992_.m_49966_(), Blocks.f_50334_.m_49966_()};
    private WellTileEntity wellCache = null;
    private final MultiblockCapability<IFluidHandler> fluidInputHandler = MultiblockCapability.make((Object)this, be -> be.fluidInputHandler, MultiblockPartBlockEntity::master, (ResettableCapability)this.registerFluidInput(new IFluidTank[]{this.tank}));
    private final ResettableCapability<IFluidHandler> dummyTank = this.registerFluidOutput(new IFluidTank[]{DUMMY_TANK});
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(DerrickTileEntity::getShape);

    public DerrickTileEntity(BlockEntityType<? extends DerrickTileEntity> type, BlockPos pos, BlockState state) {
        super((IETemplateMultiblock)DerrickMultiblock.INSTANCE, 16000, true, type, pos, state);
    }

    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.drilling = nbt.m_128471_("drilling");
        this.spilling = nbt.m_128471_("spilling");
        this.clientFlow = nbt.m_128451_("spillflow");
        try {
            this.fluidSpilled = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.m_128461_("spillingfluid")));
        }
        catch (ResourceLocationException rle) {
            this.fluidSpilled = Fluids.f_76191_;
        }
        this.tank.readFromNBT(nbt.m_128469_("tank"));
        if (nbt.m_128425_("grid", 10)) {
            this.gridStorage = PipeConfig.Grid.fromCompound(nbt.m_128469_("grid"));
        }
        if (!descPacket && !this.isDummy()) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
            this.m_6596_();
        }
    }

    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128379_("drilling", this.drilling);
        nbt.m_128379_("spilling", this.spilling);
        nbt.m_128405_("spillflow", this.getReservoirFlow());
        nbt.m_128359_("spillingfluid", RegistryUtils.getRegistryNameOf(this.fluidSpilled).toString());
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        if (this.gridStorage != null) {
            nbt.m_128365_("grid", (Tag)this.gridStorage.toCompound());
        }
        if (!descPacket && !this.isDummy()) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
    }

    private int getReservoirFlow() {
        ReservoirIsland island = ReservoirHandler.getIsland(this.getLevelNonnull(), this.m_58899_());
        if (island == null || this.f_58858_.m_123342_() < this.getLevelNonnull().m_5736_()) {
            return 10;
        }
        return island.getFlowFromPressure(this.getLevelNonnull(), this.m_58899_());
    }

    private boolean acceptsFluid(FluidStack fs) {
        int waterNeeded;
        boolean isWater;
        if (fs.isEmpty()) {
            return false;
        }
        WellTileEntity well = this.createAndGetWell(false);
        if (well == null) {
            return false;
        }
        Fluid inFluid = fs.getFluid();
        boolean isConcrete = inFluid == ExternalModContent.getIEFluid_Concrete();
        boolean bl = isWater = inFluid == Fluids.f_76193_;
        if (!isConcrete && !isWater) {
            return false;
        }
        int realPipeLength = this.m_58899_().m_123342_() - 1 - well.m_58899_().m_123342_();
        int concreteNeeded = 125 * (realPipeLength - well.wellPipeLength);
        if (concreteNeeded > 0 && isConcrete) {
            FluidStack tankFluidStack = this.tank.getFluid();
            if (!tankFluidStack.isEmpty() && inFluid != tankFluidStack.getFluid() || tankFluidStack.getAmount() >= concreteNeeded) {
                return false;
            }
            return concreteNeeded >= fs.getAmount();
        }
        if (concreteNeeded <= 0 && (waterNeeded = 125 * (well.getMaxPipeLength() - well.wellPipeLength)) > 0 && isWater) {
            FluidStack tankFluidStack = this.tank.getFluid();
            if (!tankFluidStack.isEmpty() && inFluid != tankFluidStack.getFluid() || tankFluidStack.getAmount() >= waterNeeded) {
                return false;
            }
            return waterNeeded >= fs.getAmount();
        }
        return false;
    }

    @Override
    public void tickClient() {
        if (this.isDummy()) {
            return;
        }
        if (this.drilling) {
            this.rotation += 10;
            this.rotation %= 2160;
            double x = (double)this.f_58858_.m_123341_() + 0.5;
            double y = (double)this.f_58858_.m_123342_() + 1.0;
            double z = (double)this.f_58858_.m_123343_() + 0.5;
            int r = this.f_58857_.f_46441_.m_188503_(PARTICLESTATES.length);
            for (int i = 0; i < 5; ++i) {
                float xa = (this.f_58857_.f_46441_.m_188501_() - 0.5f) * 10.0f;
                float ya = 5.0f;
                float za = (this.f_58857_.f_46441_.m_188501_() - 0.5f) * 10.0f;
                this.f_58857_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, PARTICLESTATES[r]), x, y, z, (double)xa, (double)ya, (double)za);
            }
        }
        if (this.spilling) {
            ClientProxy.spawnSpillParticles(this.f_58857_, this.f_58858_, this.fluidSpilled, 5, 1.25f, this.clientFlow);
        }
    }

    @Override
    public void tickServer() {
        if (this.isDummy()) {
            return;
        }
        if (!this.f_58857_.isAreaLoaded(this.m_58899_(), 2)) {
            return;
        }
        boolean forceUpdate = false;
        boolean lastDrilling = this.drilling;
        boolean lastSpilling = this.spilling;
        this.spilling = false;
        this.drilling = false;
        if (this.f_58858_.m_123342_() < this.f_58857_.m_5736_()) {
            if (this.fluidSpilled == Fluids.f_76191_) {
                this.fluidSpilled = Fluids.f_76193_;
            }
            this.spilling = true;
        } else {
            WellTileEntity well = this.createAndGetWell(this.getInventory(Inventory.INPUT) != ItemStack.f_41583_);
            if (!this.isRSDisabled() && this.energyStorage.extractEnergy(((Integer)IPServerConfig.EXTRACTION.derrick_consumption.get()).intValue(), true) >= (Integer)IPServerConfig.EXTRACTION.derrick_consumption.get() && well != null && well.wellPipeLength < well.getMaxPipeLength()) {
                ItemStack stack;
                if (well.pipes <= 0 && this.getInventory(Inventory.INPUT) != ItemStack.f_41583_ && (stack = this.getInventory(Inventory.INPUT)).m_41613_() > 0) {
                    stack.m_41774_(1);
                    well.pipes = 6;
                    if (stack.m_41613_() <= 0) {
                        this.setInventory(Inventory.INPUT, ItemStack.f_41583_);
                    }
                    well.m_6596_();
                    forceUpdate = true;
                }
                if (well.pipes > 0) {
                    BlockPos dPos = this.m_58899_();
                    BlockPos wPos = well.m_58899_();
                    int realPipeLength = dPos.m_123342_() - 1 - wPos.m_123342_();
                    if (well.phyiscalPipesList.size() < realPipeLength && well.wellPipeLength < realPipeLength) {
                        if (this.tank.drain(125, IFluidHandler.FluidAction.SIMULATE).getAmount() >= 125) {
                            this.energyStorage.extractEnergy(((Integer)IPServerConfig.EXTRACTION.derrick_consumption.get()).intValue(), false);
                            if (this.advanceTimer()) {
                                BlockPos current;
                                BlockState state;
                                Level world = this.getLevelNonnull();
                                for (int y = dPos.m_123342_() - 1; y > wPos.m_123342_() && (state = world.m_8055_(current = new BlockPos(dPos.m_123341_(), y, dPos.m_123343_()))).m_60734_() != Blocks.f_50752_ && state.m_60734_() != IPContent.Blocks.WELL.get(); --y) {
                                    if (state.m_60734_() == IPContent.Blocks.WELL_PIPE.get() && !((Boolean)state.m_61143_((Property)WellPipeBlock.BROKEN)).booleanValue()) continue;
                                    world.m_46961_(current, false);
                                    world.m_46597_(current, ((WellPipeBlock)((Object)IPContent.Blocks.WELL_PIPE.get())).m_49966_());
                                    well.phyiscalPipesList.add(y);
                                    this.tank.drain(125, IFluidHandler.FluidAction.EXECUTE);
                                    well.usePipe();
                                    break;
                                }
                                if (well.phyiscalPipesList.size() >= realPipeLength && well.wellPipeLength >= realPipeLength) {
                                    well.pastPhysicalPart = true;
                                    well.m_6596_();
                                }
                            }
                            forceUpdate = true;
                            this.drilling = true;
                        }
                    } else {
                        if (!this.tank.getFluid().isEmpty() && this.tank.getFluid().getFluid() == ExternalModContent.getIEFluid_Concrete()) {
                            this.tank.drain(this.tank.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                            forceUpdate = true;
                        }
                        if (this.tank.drain(125, IFluidHandler.FluidAction.SIMULATE).getAmount() >= 125) {
                            this.energyStorage.extractEnergy(((Integer)IPServerConfig.EXTRACTION.derrick_consumption.get()).intValue(), false);
                            if (this.advanceTimer()) {
                                this.restorePhysicalPipeProgress(well, dPos, realPipeLength);
                                this.tank.drain(125, IFluidHandler.FluidAction.EXECUTE);
                                well.usePipe();
                            }
                            forceUpdate = true;
                            this.drilling = true;
                        }
                    }
                }
            }
            if (well != null && well.wellPipeLength == well.getMaxPipeLength()) {
                this.outputReservoirFluid();
            }
        }
        if (this.spilling && this.fluidSpilled == Fluids.f_76191_) {
            this.fluidSpilled = IPContent.Fluids.CRUDEOIL.get();
        }
        if (!this.spilling && this.fluidSpilled != Fluids.f_76191_) {
            this.fluidSpilled = Fluids.f_76191_;
        }
        if (forceUpdate || lastDrilling != this.drilling || lastSpilling != this.spilling) {
            this.updateMasterBlock(null, true);
            this.m_6596_();
        }
    }

    public WellTileEntity createAndGetWell(boolean popList) {
        if (this.wellCache != null && this.wellCache.m_58901_()) {
            this.wellCache = null;
        }
        if (this.wellCache == null) {
            Level world = this.getLevelNonnull();
            WellTileEntity well = null;
            for (int y = this.m_58899_().m_123342_() - 1; y >= world.m_141937_(); --y) {
                BlockPos current = new BlockPos(this.m_58899_().m_123341_(), y, this.m_58899_().m_123343_());
                BlockState state = world.m_8055_(current);
                if (state.m_60734_() == IPContent.Blocks.WELL.get()) {
                    well = (WellTileEntity)world.m_7702_(current);
                    break;
                }
                if (state.m_60734_() != Blocks.f_50752_) continue;
                world.m_46597_(current, ((WellBlock)((Object)IPContent.Blocks.WELL.get())).m_49966_());
                well = (WellTileEntity)world.m_7702_(current);
                break;
            }
            this.wellCache = well;
        }
        if (popList && this.wellCache != null && this.wellCache.tappedIslands.isEmpty()) {
            if (this.gridStorage != null) {
                this.transferGridDataToWell(this.wellCache);
            } else {
                this.wellCache.tappedIslands.add(Utils.toColumnPos(this.f_58858_));
                this.wellCache.m_6596_();
            }
        }
        if (this.wellCache != null) {
            this.wellCache.abortSelfDestructSequence();
        }
        return this.wellCache;
    }

    @Nullable
    public WellTileEntity getWell() {
        if (this.wellCache != null && this.wellCache.m_58901_()) {
            this.wellCache = null;
        }
        if (this.wellCache == null) {
            Level world = this.getLevelNonnull();
            WellTileEntity well = null;
            for (int y = this.m_58899_().m_123342_() - 1; y >= world.m_141937_(); --y) {
                BlockPos current = new BlockPos(this.m_58899_().m_123341_(), y, this.m_58899_().m_123343_());
                BlockState state = world.m_8055_(current);
                if (state.m_60734_() != IPContent.Blocks.WELL.get()) continue;
                well = (WellTileEntity)world.m_7702_(current);
                break;
            }
            this.wellCache = well;
        }
        return this.wellCache;
    }

    public void transferGridDataToWell(@Nullable WellTileEntity well) {
        if (well != null) {
            int additionalPipes = 0;
            ArrayList<ColumnPos> list = new ArrayList<ColumnPos>();
            PipeConfig.Grid grid = this.gridStorage;
            for (int j = 0; j < grid.getHeight(); ++j) {
                for (int i = 0; i < grid.getWidth(); ++i) {
                    int type = grid.get(i, j);
                    if (type <= 0) continue;
                    switch (type) {
                        case 2: 
                        case 3: {
                            int x = i - grid.getWidth() / 2;
                            int z = j - grid.getHeight() / 2;
                            ColumnPos pos = new ColumnPos(this.f_58858_.m_123341_() + x, this.f_58858_.m_123343_() + z);
                            list.add(pos);
                        }
                        case 1: {
                            ++additionalPipes;
                        }
                    }
                }
            }
            well.tappedIslands = list;
            well.additionalPipes = additionalPipes;
            well.m_6596_();
        }
    }

    private boolean advanceTimer() {
        if (this.timer-- <= 0) {
            this.timer = 10;
            return true;
        }
        return false;
    }

    public void restorePhysicalPipeProgress(@Nonnull WellTileEntity well, BlockPos dPos, int realPipeLength) {
        int min = Math.min(well.wellPipeLength, realPipeLength);
        for (int i = 1; i < min; ++i) {
            BlockPos current = new BlockPos(dPos.m_123341_(), dPos.m_123342_() - i, dPos.m_123343_());
            BlockState state = this.getLevelNonnull().m_8055_(current);
            if (state.m_60734_() instanceof WellPipeBlock) continue;
            this.getLevelNonnull().m_46961_(current, false);
            this.getLevelNonnull().m_46597_(current, ((WellPipeBlock)((Object)IPContent.Blocks.WELL_PIPE.get())).m_49966_());
        }
    }

    private void outputReservoirFluid() {
        WellTileEntity well = this.createAndGetWell(true);
        if (well == null) {
            return;
        }
        FluidStack extracted = this.getExtractedFluidStack(well);
        if (!extracted.isEmpty()) {
            Direction facing = this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
            BlockPos outPos = this.getBlockPosForPos(Fluid_OUT).m_5484_(facing, 1);
            IFluidHandler output = (IFluidHandler)FluidUtil.getFluidHandler((Level)this.f_58857_, (BlockPos)outPos, (Direction)facing.m_122424_()).orElse(null);
            if (output != null) {
                FluidStack fluid = FluidHelper.copyFluid(extracted, extracted.getAmount());
                int accepted = output.fill(fluid, IFluidHandler.FluidAction.SIMULATE);
                if (accepted > 0) {
                    boolean iePipe = this.f_58857_.m_7702_(outPos) instanceof IFluidPipe;
                    int drained = output.fill(FluidHelper.copyFluid(fluid, Math.min(fluid.getAmount(), accepted), iePipe), IFluidHandler.FluidAction.EXECUTE);
                    if (fluid.getAmount() - drained > 0) {
                        this.spilling = true;
                    }
                } else {
                    this.spilling = true;
                }
            } else {
                this.spilling = true;
            }
        }
        if (this.spilling && !extracted.isEmpty() && this.fluidSpilled != extracted.getFluid()) {
            this.fluidSpilled = extracted.getFluid();
        }
        if (!this.spilling && this.fluidSpilled != Fluids.f_76191_) {
            this.fluidSpilled = Fluids.f_76191_;
        }
    }

    private FluidStack getExtractedFluidStack(@Nonnull WellTileEntity well) {
        Fluid extractedFluid = Fluids.f_76191_;
        int extractedAmount = 0;
        for (ColumnPos cPos : well.tappedIslands) {
            ReservoirIsland island = ReservoirHandler.getIsland(this.f_58857_, cPos);
            if (island == null) continue;
            if (extractedFluid == Fluids.f_76191_) {
                extractedFluid = island.getFluid();
            } else if (island.getFluid() != extractedFluid) continue;
            extractedAmount += island.extractWithPressure(this.getLevelNonnull(), cPos.f_140723_(), cPos.f_140724_());
        }
        return new FluidStack(extractedFluid, extractedAmount);
    }

    public void disassemble() {
        WellTileEntity well;
        if (this.formed && !this.f_58857_.f_46443_ && this.offsetToMaster.equals((Object)Vec3i.f_123288_) && (well = this.getWell()) != null && !well.drillingCompleted) {
            if (well.wellPipeLength > 0) {
                well.startSelfDestructSequence();
            } else {
                this.f_58857_.m_46597_(well.m_58899_(), Blocks.f_50752_.m_49966_());
            }
        }
        super.disassemble();
    }

    public <C> LazyOptional<C> getCapability(Capability<C> capability, Direction side) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            if (this.posInMultiblock.equals((Object)Fluid_IN) && (side == null || side == this.getFacing().m_122424_())) {
                return this.fluidInputHandler.getAndCast();
            }
            if (this.posInMultiblock.equals((Object)Fluid_OUT) && (side == null || (this.getIsMirrored() ? side == this.getFacing().m_122428_() : side == this.getFacing().m_122427_()))) {
                return this.dummyTank.cast();
            }
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean skipGui(Direction hitFace) {
        Direction facing = this.getFacing();
        if (this.getEnergyPos().stream().anyMatch(t -> t.posInMultiblock().equals((Object)this.posInMultiblock)) && hitFace == Direction.UP) {
            return true;
        }
        if (this.getRedstonePos().contains(this.posInMultiblock) && hitFace == (this.getIsMirrored() ? facing.m_122427_() : facing.m_122428_())) {
            return true;
        }
        if (this.posInMultiblock.equals((Object)Fluid_IN) && hitFace == this.getFacing().m_122424_()) {
            return true;
        }
        return this.posInMultiblock.equals((Object)Fluid_OUT) && hitFace == (this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_());
    }

    public ItemStack getInventory(Inventory inv) {
        return (ItemStack)this.inventory.get(inv.id());
    }

    public ItemStack setInventory(Inventory inv, ItemStack stack) {
        return (ItemStack)this.inventory.set(inv.id(), (Object)stack);
    }

    @Override
    public DerrickTileEntity getGuiMaster() {
        return (DerrickTileEntity)this.master();
    }

    @Override
    public IPMenuProvider.BEContainerIP<? super DerrickTileEntity, ?> getContainerType() {
        return IPMenuTypes.DERRICK;
    }

    @Override
    public boolean canUseGui(Player player) {
        return this.formed;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void doGraphicalUpdates() {
        this.updateMasterBlock(null, true);
    }

    protected MultiblockRecipe getRecipeForId(Level level, ResourceLocation id) {
        return null;
    }

    public Set<BlockPos> getRedstonePos() {
        return Redstone_IN;
    }

    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return Energy_IN;
    }

    public IFluidTank[] getInternalTanks() {
        return new IFluidTank[]{this.tank};
    }

    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    public int[] getOutputSlots() {
        return new int[0];
    }

    public int[] getOutputTanks() {
        return new int[0];
    }

    public boolean additionalCanProcessCheck(MultiblockProcess<MultiblockRecipe> process) {
        return false;
    }

    public void doProcessOutput(ItemStack output) {
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(MultiblockProcess<MultiblockRecipe> process) {
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public float getMinProcessDistance(MultiblockProcess<MultiblockRecipe> process) {
        return 0.0f;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    public boolean isLadder() {
        int x = this.posInMultiblock.m_123341_();
        int y = this.posInMultiblock.m_123342_();
        int z = this.posInMultiblock.m_123343_();
        return y >= 0 && y <= 2 && x == 0 && z == 2;
    }

    public VoxelShape getBlockBounds(CollisionContext ctx) {
        return SHAPES.get((Object)this.posInMultiblock, (Object)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        int x = posInMultiblock.m_123341_();
        int y = posInMultiblock.m_123342_();
        int z = posInMultiblock.m_123343_();
        ArrayList<AABB> main = new ArrayList<AABB>();
        if (y == 0) {
            if (!(x == 2 && z == 4 || x == 4 && z == 2 || x == 2 && z == 0 || x == 2 && z == 2)) {
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
            }
            if (z == 4) {
                if (x == 1) {
                    AABBUtils.box16(main, 8.0, 8.0, 0.0, 16.0, 16.0, 16.0);
                }
                if (x == 3) {
                    AABBUtils.box16(main, 0.0, 8.0, 0.0, 8.0, 16.0, 16.0);
                }
            }
            if (x == 1 && z == 1) {
                AABBUtils.box16(main, 12.0, 8.0, 12.0, 16.0, 16.0, 16.0);
            }
            if (x == 3 && z == 1) {
                AABBUtils.box16(main, 0.0, 8.0, 12.0, 4.0, 16.0, 16.0);
            }
            if (x == 1 && z == 3) {
                AABBUtils.box16(main, 12.0, 8.0, 0.0, 16.0, 16.0, 4.0);
            }
            if (x == 3 && z == 3) {
                AABBUtils.box16(main, 0.0, 8.0, 0.0, 4.0, 16.0, 4.0);
            }
            if (x == 2 && z == 1) {
                AABBUtils.box16(main, 0.0, 8.0, 12.0, 16.0, 16.0, 16.0);
            }
            if (x == 2 && z == 3) {
                AABBUtils.box16(main, 0.0, 8.0, 0.0, 16.0, 16.0, 4.0);
            }
            if (x == 1 && z == 2) {
                AABBUtils.box16(main, 12.0, 8.0, 0.0, 16.0, 16.0, 16.0);
            }
            if (x == 3 && z == 2) {
                AABBUtils.box16(main, 0.0, 8.0, 0.0, 4.0, 16.0, 16.0);
            }
        }
        if ((y == 0 || y == 1) && z == 0) {
            if (x == 1) {
                AABBUtils.box16(main, 4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
            } else if (x == 3) {
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
            }
        }
        if (x == 1 && z == 2) {
            if (y == 0) {
                AABBUtils.box16(main, 0.0, 8.0, 3.0, 12.0, 16.0, 13.0);
            }
            if (y == 1) {
                AABBUtils.box16(main, 0.0, 0.0, 3.0, 12.0, 2.0, 13.0);
            }
        }
        if (x == 1 && z == 1) {
            AABBUtils.box16(main, 0.0, 0.0, 0.0, 4.0, 16.0, 4.0);
        }
        if (x == 3 && z == 1) {
            AABBUtils.box16(main, 12.0, 0.0, 0.0, 16.0, 16.0, 4.0);
        }
        if (x == 1 && z == 3) {
            AABBUtils.box16(main, 0.0, 0.0, 12.0, 4.0, 16.0, 16.0);
        }
        if (x == 3 && z == 3) {
            AABBUtils.box16(main, 12.0, 0.0, 12.0, 16.0, 16.0, 16.0);
        }
        if (y >= 0 && y <= 2 && x == 0 && z == 2) {
            AABBUtils.box16(main, 15.0, 0.0, 2.0, 16.0, 16.0, 14.0);
        }
        if (y == 2 && x >= 1 && x <= 3 && z >= 1 && z <= 3) {
            AABBUtils.box16(main, 0.0, 8.0, 0.0, 16.0, 16.0, 16.0);
        }
        if (y == 3) {
            if (x == 1 && z == 2) {
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 1.0, 16.0, 1.0);
                AABBUtils.box16(main, 0.0, 0.0, 15.0, 1.0, 16.0, 16.0);
            }
            if (x >= 1 && x <= 3) {
                if (z == 1) {
                    AABBUtils.box16(main, 0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
                }
                if (z == 3) {
                    AABBUtils.box16(main, 0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
                }
            }
            if (x == 1 && (z == 1 || z == 3)) {
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
            }
            if (z >= 1 && z <= 3 && x == 3) {
                AABBUtils.box16(main, 15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
            }
        }
        if (y >= 1 && x == 2 && z == 2) {
            if (y == 7) {
                AABBUtils.box16(main, 4.0, 0.0, 4.0, 12.0, 4.0, 12.0);
            } else {
                AABBUtils.box16(main, 4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
            }
        }
        if (x == 0 && z == 1) {
            if (y == 0) {
                AABBUtils.box16(main, 2.0, 0.0, 2.0, 6.0, 16.0, 4.0);
                AABBUtils.box16(main, 2.0, 0.0, 12.0, 6.0, 16.0, 14.0);
            }
            if (y == 1) {
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 8.0, 16.0, 16.0);
            }
        }
        if (main.isEmpty()) {
            main.add(AABBUtils.FULL);
        }
        return main;
    }

    public static enum Inventory {
        INPUT;


        public int id() {
            return this.ordinal();
        }
    }
}

