/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.cfg;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="immersivepetroleum", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IPClientConfig {
    public static final Miscellaneous MISCELLANEOUS;
    public static final GridColors GRID_COLORS;
    public static final ForgeConfigSpec ALL;

    @SubscribeEvent
    public static void onConfigChange(ModConfigEvent ev) {
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        GRID_COLORS = new GridColors(builder);
        MISCELLANEOUS = new Miscellaneous(builder);
        ALL = builder.build();
    }

    public static class GridColors {
        private static final Logger log = LogManager.getLogger((String)"immersivepetroleum/ClientConfig/GridColors");
        public final ForgeConfigSpec.ConfigValue<String> pipe_normal_color;
        public final ForgeConfigSpec.ConfigValue<String> pipe_perforated_color;
        public final ForgeConfigSpec.ConfigValue<String> pipe_perforated_fixed_color;

        GridColors(ForgeConfigSpec.Builder builder) {
            builder.push("GridColors");
            this.pipe_normal_color = builder.comment("Normal pipe color. (Hex RGB)").define("normal_pipe_color", (Object)"A5A5A5", o -> this.hexValidator(o, "normal_pipe_color"));
            this.pipe_perforated_color = builder.comment("Perforated pipe color. (Hex RGB)").define("perforated_pipe_color", (Object)"54FF54", o -> this.hexValidator(o, "perforated_pipe_color"));
            this.pipe_perforated_fixed_color = builder.comment("Perforated pipe color. (Hex RGB)").define("fixed_perforated_pipe_color", (Object)"FF515A", o -> this.hexValidator(o, "fixed_perforated_pipe_color"));
            builder.pop();
        }

        private boolean hexValidator(Object obj, String cfgPath) {
            if (obj instanceof String) {
                String str = (String)obj;
                if (str.length() > 6) {
                    String strNew = str.substring(str.length() - 6);
                    log.warn("{}: \"{}\" was cut down to \"{}\".", (Object)cfgPath, (Object)str, (Object)strNew);
                    str = strNew;
                }
                if (str.length() == 6) {
                    try {
                        Integer.valueOf(str, 16);
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                log.error("{}: \"{}\" is not a valid RGB Hex color.", (Object)cfgPath, (Object)str);
            }
            return false;
        }
    }

    public static class Miscellaneous {
        Miscellaneous(ForgeConfigSpec.Builder builder) {
            builder.push("Miscellaneous");
            builder.pop();
        }
    }
}

