/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.lubehandlers;

import blusunrize.immersiveengineering.common.blocks.metal.BucketWheelBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ExcavatorBlockEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.client.model.IPModel;
import flaxbeard.immersivepetroleum.client.model.IPModels;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ExcavatorLubricationHandler
implements LubricatedHandler.ILubricationHandler<ExcavatorBlockEntity> {
    private static final Vec3i size = new Vec3i(3, 6, 3);
    private static final ResourceLocation TEXTURE = ResourceUtils.ip("textures/models/lube_pipe.png");
    private static Supplier<IPModel> pipes_normal;
    private static Supplier<IPModel> pipes_mirrored;

    @Override
    public Vec3i getStructureDimensions() {
        return size;
    }

    @Override
    public boolean isMachineEnabled(Level world, ExcavatorBlockEntity mbte) {
        BlockPos wheelPos = mbte.getWheelCenterPos();
        BlockEntity center = world.m_7702_(wheelPos);
        if (center instanceof BucketWheelBlockEntity) {
            BucketWheelBlockEntity wheel = (BucketWheelBlockEntity)center;
            if (!wheel.offsetToMaster.equals((Object)BlockPos.f_121853_)) {
                wheel = (BucketWheelBlockEntity)wheel.master();
            }
            return wheel.active;
        }
        return false;
    }

    @Override
    public BlockEntity isPlacedCorrectly(Level world, AutoLubricatorTileEntity lubricator, Direction facing) {
        BlockPos target = lubricator.m_58899_().m_121945_(facing);
        BlockEntity te = world.m_7702_(target);
        if (te instanceof ExcavatorBlockEntity) {
            ExcavatorBlockEntity master = (ExcavatorBlockEntity)te;
            if ((master = (ExcavatorBlockEntity)master.master()) != null) {
                Direction dir;
                Direction direction = dir = master.getIsMirrored() ? master.getFacing().m_122427_() : master.getFacing().m_122428_();
                if (dir == facing) {
                    return master;
                }
            }
        }
        return null;
    }

    @Override
    public void lubricateClient(ClientLevel world, Fluid lubricant, int ticks, ExcavatorBlockEntity mbte) {
        BlockPos wheelPos = mbte.getWheelCenterPos();
        BlockEntity center = world.m_7702_(wheelPos);
        if (center instanceof BucketWheelBlockEntity) {
            BucketWheelBlockEntity wheel = (BucketWheelBlockEntity)center;
            if (!wheel.offsetToMaster.equals((Object)BlockPos.f_121853_)) {
                wheel = (BucketWheelBlockEntity)wheel.master();
            }
            wheel.rotation = (float)((double)wheel.rotation + (Double)IEServerConfig.MACHINES.excavator_speed.get() / 4.0);
        }
    }

    @Override
    public void lubricateServer(ServerLevel world, Fluid lubricant, int ticks, ExcavatorBlockEntity mbte) {
        BlockPos wheelPos = mbte.getWheelCenterPos();
        BlockEntity center = world.m_7702_(wheelPos);
        if (center instanceof BucketWheelBlockEntity) {
            BucketWheelBlockEntity wheel = (BucketWheelBlockEntity)center;
            if (!wheel.offsetToMaster.equals((Object)BlockPos.f_121853_)) {
                wheel = (BucketWheelBlockEntity)wheel.master();
            }
            if (ticks % 4 == 0) {
                wheel.tickServer();
            }
        }
    }

    @Override
    public void spawnLubricantParticles(ClientLevel world, AutoLubricatorTileEntity lubricator, Direction facing, ExcavatorBlockEntity mbte) {
        Direction f = mbte.getIsMirrored() ? facing : facing.m_122424_();
        float location = world.f_46441_.m_188501_();
        boolean flip = f.m_122434_() == Direction.Axis.Z ^ facing.m_122421_() == Direction.AxisDirection.POSITIVE ^ !mbte.getIsMirrored();
        float xO = 1.2f;
        float zO = -0.5f;
        float yO = 0.5f;
        if (location > 0.5f) {
            xO = 0.9f;
            yO = 0.8f;
            zO = 1.75f;
        }
        if (facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            xO = -xO + 1.0f;
        }
        if (!flip) {
            zO = -zO + 1.0f;
        }
        float x = (float)lubricator.m_58899_().m_123341_() + (f.m_122434_() == Direction.Axis.X ? xO : zO);
        float y = (float)lubricator.m_58899_().m_123342_() + yO;
        float z = (float)lubricator.m_58899_().m_123343_() + (f.m_122434_() == Direction.Axis.X ? zO : xO);
        for (int i = 0; i < 3; ++i) {
            float r1 = (world.f_46441_.m_188501_() - 0.5f) * 2.0f;
            float r2 = (world.f_46441_.m_188501_() - 0.5f) * 2.0f;
            float r3 = world.f_46441_.m_188501_();
            world.m_7106_((ParticleOptions)ParticleTypes.f_123780_, (double)x, (double)y, (double)z, (double)(r1 * 0.04f), (double)(r3 * 0.0125f), (double)(r2 * 0.025f));
        }
    }

    @Override
    public Tuple<BlockPos, Direction> getGhostBlockPosition(Level world, ExcavatorBlockEntity mbte) {
        if (!mbte.isDummy()) {
            BlockPos pos = mbte.m_58899_().m_5484_(mbte.getFacing(), 4).m_5484_(mbte.getIsMirrored() ? mbte.getFacing().m_122428_() : mbte.getFacing().m_122427_(), 2);
            Direction f = mbte.getIsMirrored() ? mbte.getFacing().m_122427_() : mbte.getFacing().m_122428_();
            return new Tuple((Object)pos, (Object)f);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderPipes(AutoLubricatorTileEntity lubricator, ExcavatorBlockEntity mbte, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        matrix.m_85837_(0.0, -1.0, 0.0);
        BlockPos offset = mbte.m_58899_().m_121996_((Vec3i)lubricator.m_58899_());
        matrix.m_85837_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
        Direction rotation = mbte.getFacing();
        switch (rotation) {
            case NORTH: {
                matrix.m_85845_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                matrix.m_85837_(-1.0, 0.0, -1.0);
                break;
            }
            case SOUTH: {
                matrix.m_85845_(new Quaternion(0.0f, 270.0f, 0.0f, true));
                matrix.m_85837_(0.0, 0.0, -2.0);
                break;
            }
            case EAST: {
                matrix.m_85837_(0.0, 0.0, -1.0);
                break;
            }
            case WEST: {
                matrix.m_85845_(new Quaternion(0.0f, 180.0f, 0.0f, true));
                matrix.m_85837_(-1.0, 0.0, -2.0);
                break;
            }
        }
        IPModel model = null;
        if (mbte.getIsMirrored()) {
            if (pipes_mirrored == null) {
                pipes_mirrored = IPModels.getSupplier("excavator_lubepipes_mirrored");
            }
            model = pipes_mirrored.get();
        } else {
            if (pipes_normal == null) {
                pipes_normal = IPModels.getSupplier("excavator_lubepipes_normal");
            }
            model = pipes_normal.get();
        }
        if (model != null) {
            model.m_7695_(matrix, buffer.m_6299_(model.m_103119_(TEXTURE)), combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

