/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ui.IDisplayHelper;

@ApiStatus.Experimental
public class EnergyView {
    public String current;
    public String max;
    public float ratio;
    @Nullable
    public Component overrideText;

    @Nullable
    public static EnergyView read(CompoundTag tag, String unit) {
        int capacity = tag.m_128451_("Capacity");
        if (capacity <= 0) {
            return null;
        }
        int cur = tag.m_128451_("Cur");
        EnergyView energyView = new EnergyView();
        energyView.current = IDisplayHelper.get().humanReadableNumber(cur, unit, false);
        energyView.max = IDisplayHelper.get().humanReadableNumber(capacity, unit, false);
        energyView.ratio = (float)cur / (float)capacity;
        return energyView;
    }

    public static CompoundTag fromForgeEnergy(IEnergyStorage storage) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Capacity", storage.getMaxEnergyStored());
        tag.m_128405_("Cur", storage.getEnergyStored());
        return tag;
    }
}

