/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.buffer.BlockStateBlockItem;
import com.railwayteam.railways.content.cycle_menu.TagCycleHandlerClient;
import com.railwayteam.railways.content.cycle_menu.TagCycleHandlerServer;
import com.railwayteam.railways.multiloader.Env;
import com.railwayteam.railways.registry.CRItems;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockStateBlockItemGroup<C, T extends IStyle<C> & Comparable<T>> {
    private static final CreateRegistrate REGISTRATE = Railways.registrate();
    private final C context;
    @NotNull
    private final Property<T> property;
    @NotNull
    private final T[] values;
    @NotNull
    private final BlockEntry<?> blockEntry;
    @NotNull
    private final TagKey<Item> cycleTag;
    @Nullable
    private final T excluded;
    @Nullable
    private final String tooltipTranslationKey;
    @NotNull
    private final NonNullUnaryOperator<ItemBuilder<BlockStateBlockItem<T>, CreateRegistrate>> itemTransformer;
    private final Map<T, ItemEntry<BlockStateBlockItem<T>>> items = new HashMap<T, ItemEntry<BlockStateBlockItem<T>>>();

    public BlockStateBlockItemGroup(C context, @NotNull Property<T> property, @NotNull T[] values, @NotNull BlockEntry<?> blockEntry, @NotNull NonNullUnaryOperator<ItemBuilder<BlockStateBlockItem<T>, CreateRegistrate>> itemTransformer, @NotNull TagKey<Item> cycleTag) {
        this(context, (Property)property, (IStyle[])values, (BlockEntry)blockEntry, (NonNullUnaryOperator)itemTransformer, (TagKey)cycleTag, null, null);
    }

    public BlockStateBlockItemGroup(C context, @NotNull Property<T> property, @NotNull T[] values, @NotNull BlockEntry<?> blockEntry, @NotNull NonNullUnaryOperator<ItemBuilder<BlockStateBlockItem<T>, CreateRegistrate>> itemTransformer, @NotNull TagKey<Item> cycleTag, @Nullable String tooltipTranslationKey) {
        this(context, (Property)property, (IStyle[])values, (BlockEntry)blockEntry, (NonNullUnaryOperator)itemTransformer, (TagKey)cycleTag, null, tooltipTranslationKey);
    }

    public BlockStateBlockItemGroup(C context, @NotNull Property<T> property, @NotNull T[] values, @NotNull BlockEntry<?> blockEntry, @NotNull NonNullUnaryOperator<ItemBuilder<BlockStateBlockItem<T>, CreateRegistrate>> itemTransformer, @NotNull TagKey<Item> cycleTag, @Nullable T excluded, @Nullable String tooltipTranslationKey) {
        this.context = context;
        this.property = property;
        this.values = values;
        this.blockEntry = blockEntry;
        this.itemTransformer = itemTransformer;
        this.cycleTag = cycleTag;
        this.excluded = excluded;
        this.tooltipTranslationKey = tooltipTranslationKey;
        this.register();
    }

    public ItemEntry<BlockStateBlockItem<T>> get(T value) {
        return this.items.get(value);
    }

    public void registerDefaultEntry(T value, ItemEntry<BlockStateBlockItem<T>> entry) {
        this.items.put(value, entry);
    }

    private void register() {
        TagCycleHandlerServer.CYCLE_TRACKER.registerCycle(this.cycleTag);
        TagCycleHandlerServer.CYCLE_TRACKER.scheduleRecompute();
        Env.CLIENT.runIfCurrent(() -> () -> {
            TagCycleHandlerClient.CYCLE_TRACKER.registerCycle(this.cycleTag);
            TagCycleHandlerClient.CYCLE_TRACKER.scheduleRecompute();
        });
        String tooltipKey = this.tooltipTranslationKey == null ? "block.railways.generic_radial" : this.tooltipTranslationKey;
        boolean primary = true;
        for (C v : this.values) {
            if (this.excluded != null && v == this.excluded) {
                primary = false;
                continue;
            }
            this.items.put(v, ((ItemBuilder)((ItemBuilder)REGISTRATE.item(v.getBlockId(this.context), BlockStateBlockItem.create((NonNullSupplier<Block>)((NonNullSupplier)() -> this.blockEntry.get()), this.property, v, primary)).properties(p -> p.m_41491_(CRItems.mainCreativeTab)).lang(v.getLangName(this.context)).onRegisterAfter(Registry.f_122904_, i -> ItemDescription.useKey((ItemLike)i, (String)tooltipKey))).transform(this.itemTransformer)).tag(new TagKey[]{this.cycleTag}).model((c, p) -> p.withExistingParent("item/" + c.getName(), v.getModel(this.context))).register());
            primary = false;
        }
    }

    public static interface IStyle<T> {
        public ResourceLocation getModel(T var1);

        public String getBlockId(T var1);

        public String getLangName(T var1);
    }
}

