/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.config;

import java.util.function.Supplier;
import mezz.jei.core.config.file.IConfigCategoryBuilder;
import mezz.jei.core.config.file.IConfigSchemaBuilder;
import mezz.jei.core.search.SearchMode;
import mezz.jei.gui.config.IIngredientFilterConfig;

public class IngredientFilterConfig
implements IIngredientFilterConfig {
    public final Supplier<SearchMode> modNameSearchMode;
    public final Supplier<SearchMode> tooltipSearchMode;
    public final Supplier<SearchMode> tagSearchMode;
    public final Supplier<SearchMode> creativeTabSearchMode;
    public final Supplier<SearchMode> colorSearchMode;
    public final Supplier<SearchMode> resourceLocationSearchMode;
    public final Supplier<Boolean> searchAdvancedTooltips;

    public IngredientFilterConfig(IConfigSchemaBuilder builder) {
        IConfigCategoryBuilder search = builder.addCategory("search");
        this.modNameSearchMode = search.addEnum("ModNameSearchMode", SearchMode.REQUIRE_PREFIX, "Search mode for Mod Names (prefix: @)");
        this.tooltipSearchMode = search.addEnum("TooltipSearchMode", SearchMode.ENABLED, "Search mode for Tooltips (prefix: #)");
        this.tagSearchMode = search.addEnum("TagSearchMode", SearchMode.REQUIRE_PREFIX, "Search mode for Tag Names (prefix: $)");
        this.creativeTabSearchMode = search.addEnum("CreativeTabSearchMode", SearchMode.DISABLED, "Search mode for Creative Tab Names (prefix: %)");
        this.colorSearchMode = search.addEnum("ColorSearchMode", SearchMode.DISABLED, "Search mode for Colors (prefix: ^)");
        this.resourceLocationSearchMode = search.addEnum("ResourceLocationSearchMode", SearchMode.DISABLED, "Search mode for resources locations (prefix: &)");
        this.searchAdvancedTooltips = search.addBoolean("SearchAdvancedTooltips", false, "Search advanced tooltips (visible with F3+H)");
    }

    @Override
    public SearchMode getModNameSearchMode() {
        return this.modNameSearchMode.get();
    }

    @Override
    public SearchMode getTooltipSearchMode() {
        return this.tooltipSearchMode.get();
    }

    @Override
    public SearchMode getTagSearchMode() {
        return this.tagSearchMode.get();
    }

    @Override
    public SearchMode getCreativeTabSearchMode() {
        return this.creativeTabSearchMode.get();
    }

    @Override
    public SearchMode getColorSearchMode() {
        return this.colorSearchMode.get();
    }

    @Override
    public SearchMode getResourceLocationSearchMode() {
        return this.resourceLocationSearchMode.get();
    }

    @Override
    public boolean getSearchAdvancedTooltips() {
        return this.searchAdvancedTooltips.get();
    }
}

