/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalmodels.imdlib.util;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.Registries;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.itsmeow.betteranimalmodels.imdlib.block.GenericSkullBlock;
import dev.itsmeow.betteranimalmodels.imdlib.blockentity.HeadBlockEntity;
import dev.itsmeow.betteranimalmodels.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalmodels.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.betteranimalmodels.imdlib.entity.util.builder.IEntityBuilder;
import dev.itsmeow.betteranimalmodels.imdlib.entity.util.variant.EntityVariant;
import dev.itsmeow.betteranimalmodels.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalmodels.imdlib.item.ItemBlockHeadType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class HeadType {
    protected static final Set<HeadType> HEADS = new HashSet<HeadType>();
    protected static final Map<String, HeadType> HEADS_MAP = new HashMap<String, HeadType>();
    protected static final Map<ResourceLocation, HeadType> HEADS_BLOCK_MAP = new HashMap<ResourceLocation, HeadType>();
    private final String name;
    private final PlacementType placement;
    private final EntityTypeContainer<? extends LivingEntity> container;
    private final String modid;
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<Function<ModelPart, EntityModel<? extends Entity>>> modelSupplier;
    public String modelLocation;
    private IVariant singletonVariant;
    private final Map<IVariant, Pair<RegistrySupplier<GenericSkullBlock>, RegistrySupplier<ItemBlockHeadType>>> heads = new HashMap<IVariant, Pair<RegistrySupplier<GenericSkullBlock>, RegistrySupplier<ItemBlockHeadType>>>();
    private final Set<RegistrySupplier<ItemBlockHeadType>> items = new HashSet<RegistrySupplier<ItemBlockHeadType>>();
    private final Set<RegistrySupplier<GenericSkullBlock>> blocks = new HashSet<RegistrySupplier<GenericSkullBlock>>();
    private final Map<ResourceLocation, IVariant> reverseVariantMap = new HashMap<ResourceLocation, IVariant>();
    private final Consumer<Registries> registerVariants;

    public HeadType(String modid, CreativeModeTab group, String name, PlacementType placement, HeadIDMapping mapping, @Nullable Function<IVariant, String> variantMapper, @Nullable IVariant singletonVariant, @Nullable String singletonID, EntityTypeContainer<? extends LivingEntity> container) {
        this.name = name;
        this.modid = modid;
        this.placement = placement;
        this.container = container;
        if (!container.hasVariants() && mapping != HeadIDMapping.SINGLETON) {
            throw new RuntimeException("Tried to create non-singleton head type with a variantless entity!");
        }
        this.registerVariants = registries -> {
            switch (mapping) {
                case NAMES: {
                    for (IVariant variant : container.getVariants()) {
                        if (!variant.hasHead()) continue;
                        this.setupVariant((Registries)registries, variant, group, variant.getName());
                    }
                    break;
                }
                case NUMBERS: {
                    for (IVariant variant : container.getVariants()) {
                        if (!variant.hasHead()) continue;
                        this.setupVariant((Registries)registries, variant, group, String.valueOf(container.getVariants().indexOf((Object)variant) + 1));
                    }
                    break;
                }
                case CUSTOM: {
                    for (IVariant variant : container.getVariants()) {
                        if (!variant.hasHead()) continue;
                        this.setupVariant((Registries)registries, variant, group, (String)variantMapper.apply(variant));
                    }
                    break;
                }
                case SINGLETON: {
                    this.setupVariant((Registries)registries, singletonVariant, group, singletonID);
                    this.singletonVariant = singletonVariant;
                    break;
                }
            }
        };
        HEADS.add(this);
        HEADS_MAP.put(name, this);
    }

    public void register(Registries registries) {
        this.registerVariants.accept(registries);
    }

    protected void setupVariant(Registries registries, IVariant variant, CreativeModeTab group, String id) {
        ResourceLocation rl = new ResourceLocation(this.getMod(), this.getName() + "_" + id);
        RegistrySupplier block = registries.get(Registry.f_122901_).register(rl, () -> new GenericSkullBlock(this, id));
        RegistrySupplier item = registries.get(Registry.f_122904_).register(rl, () -> new ItemBlockHeadType((Block)block.get(), this, id, variant, group));
        this.heads.put(variant, (Pair<RegistrySupplier<GenericSkullBlock>, RegistrySupplier<ItemBlockHeadType>>)Pair.of((Object)block, (Object)item));
        this.blocks.add((RegistrySupplier<GenericSkullBlock>)block);
        this.items.add((RegistrySupplier<ItemBlockHeadType>)item);
        this.reverseVariantMap.put(rl, variant);
        HEADS_BLOCK_MAP.put(rl, this);
    }

    public static Set<HeadType> values() {
        return HEADS;
    }

    public static HeadType valueOf(String name) {
        return HEADS_MAP.get(name);
    }

    public static HeadType valueOf(Block block) {
        return HEADS_BLOCK_MAP.get(block);
    }

    public static GenericSkullBlock[] getAllBlocks() {
        return HeadType.values().stream().map(type -> type.getBlockObjects()).flatMap(Collection::stream).map(Supplier::get).collect(Collectors.toList()).toArray(new GenericSkullBlock[0]);
    }

    public IVariant getVariantForBlock(Block block) {
        return this.reverseVariantMap.get(Registry.f_122824_.m_7981_((Object)block));
    }

    public Pair<RegistrySupplier<GenericSkullBlock>, RegistrySupplier<ItemBlockHeadType>> getPairForVariant(IVariant variant) {
        return this.heads.get(variant);
    }

    public RegistrySupplier<GenericSkullBlock> getBlockForVariant(IVariant variant) {
        if (this.getPairForVariant(variant) == null) {
            return null;
        }
        return (RegistrySupplier)this.getPairForVariant(variant).getLeft();
    }

    public RegistrySupplier<ItemBlockHeadType> getItemForVariant(IVariant variant) {
        if (this.getPairForVariant(variant) == null) {
            return null;
        }
        return (RegistrySupplier)this.getPairForVariant(variant).getRight();
    }

    public RegistrySupplier<GenericSkullBlock> getSingletonBlock() {
        if (this.getPairForVariant(this.singletonVariant) == null) {
            return null;
        }
        return (RegistrySupplier)this.getPairForVariant(this.singletonVariant).getLeft();
    }

    public RegistrySupplier<ItemBlockHeadType> getSingletonItem() {
        if (this.getPairForVariant(this.singletonVariant) == null) {
            return null;
        }
        return (RegistrySupplier)this.getPairForVariant(this.singletonVariant).getRight();
    }

    public Set<RegistrySupplier<ItemBlockHeadType>> getItemObjects() {
        return this.items;
    }

    public Set<RegistrySupplier<GenericSkullBlock>> getBlockObjects() {
        return this.blocks;
    }

    public HeadBlockEntity createTE(BlockPos pos, BlockState state) {
        return new HeadBlockEntity(this, pos, state);
    }

    public String getName() {
        return this.name;
    }

    public PlacementType getPlacementType() {
        return this.placement;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Supplier<Function<ModelPart, EntityModel<? extends Entity>>> getModelSupplier() {
        return this.modelSupplier;
    }

    public String getModelLocation() {
        return this.modelLocation;
    }

    public EntityTypeContainer<? extends LivingEntity> getContainer() {
        return this.container;
    }

    public IVariant getSingletonVariant() {
        return this.singletonVariant;
    }

    public void drop(Mob entity, int chance) {
        this.drop(entity, chance, this.getHeadID(entity).orElse(null));
    }

    public void drop(Mob entity, int chance, IVariant variant) {
        if (variant != null && !entity.f_19853_.f_46443_ && !entity.m_6162_() && entity.m_217043_().m_188503_(chance) == 0) {
            ItemStack stack = new ItemStack((ItemLike)this.getItemForVariant(variant).get());
            entity.m_5552_(stack, 0.5f);
        }
    }

    private Optional<IVariant> getHeadID(Mob entity) {
        if (entity instanceof IVariantTypes && this.container.hasVariants()) {
            IVariantTypes ent = (IVariantTypes)entity;
            return ent.getVariant();
        }
        return Optional.of(this.singletonVariant);
    }

    public String getMod() {
        return this.modid;
    }

    public static enum PlacementType {
        FLOOR_AND_WALL,
        WALL_ONLY;

    }

    public static enum HeadIDMapping {
        NAMES,
        NUMBERS,
        CUSTOM,
        SINGLETON;

    }

    public static class Builder<T extends Mob, C extends EntityTypeContainer<T>, B extends IEntityBuilder<T, C, B>> {
        private final String name;
        private final B initial;
        private PlacementType placement;
        @OnlyIn(value=Dist.CLIENT)
        private Supplier<Function<ModelPart, EntityModel<? extends Entity>>> modelSupplier;
        private String modelLocation;
        private HeadIDMapping idMapping;
        private Function<IVariant, String> customMapper;
        private IVariant singletonVariant;
        private String singletonID;
        private CreativeModeTab group;

        public Builder(B initial, String name) {
            this.initial = initial;
            this.name = name;
            this.placement = PlacementType.WALL_ONLY;
            this.idMapping = null;
        }

        public Builder<T, C, B> itemGroup(CreativeModeTab group) {
            this.group = group;
            return this;
        }

        public Builder<T, C, B> mapToNames() {
            this.idMapping = HeadIDMapping.NAMES;
            return this;
        }

        public Builder<T, C, B> mapToNumbers() {
            this.idMapping = HeadIDMapping.NUMBERS;
            return this;
        }

        public Builder<T, C, B> mapToCustom(Function<IVariant, String> customMapper) {
            this.idMapping = HeadIDMapping.CUSTOM;
            this.customMapper = customMapper;
            return this;
        }

        public Builder<T, C, B> singleton(String id, String texture) {
            this.idMapping = HeadIDMapping.SINGLETON;
            this.singletonID = id;
            this.singletonVariant = new EntityVariant(this.initial.getMod(), id, texture);
            return this;
        }

        public Builder<T, C, B> allowFloor() {
            this.placement = PlacementType.FLOOR_AND_WALL;
            return this;
        }

        public Builder<T, C, B> setModel(Supplier<Function<ModelPart, EntityModel<? extends Entity>>> modelSupplier, String modelLocation) {
            if (Platform.getEnv() == Dist.CLIENT) {
                this.modelSupplier = modelSupplier;
            }
            this.modelLocation = modelLocation;
            return this;
        }

        public B done() {
            this.initial.setHeadBuild(this::build);
            return this.initial;
        }

        public HeadType build(C container) {
            if (this.idMapping == null) {
                throw new RuntimeException("No ID mapping set for head builder " + this.name);
            }
            HeadType type = new HeadType(this.initial.getMod(), this.group, this.name, this.placement, this.idMapping, this.customMapper, this.singletonVariant, this.singletonID, (EntityTypeContainer<? extends LivingEntity>)container);
            if (Platform.getEnv() == Dist.CLIENT) {
                type.modelSupplier = this.modelSupplier;
                type.modelLocation = this.modelLocation;
            }
            return type;
        }
    }
}

