/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl.condition;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbranks.FTBRanks;
import dev.ftb.mods.ftbranks.api.RankCondition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;

public class PlaytimeCondition
implements RankCondition {
    public static final int TICKS = 1;
    public static final int SECONDS = 20;
    public static final int MINUTES = 1200;
    public static final int HOURS = 72000;
    public static final int DAYS = 1728000;
    public static final int WEEKS = 12096000;
    private final int time;
    private final int timeUnit;
    private final Stat<ResourceLocation> stat;

    public PlaytimeCondition(SNBTCompoundTag tag) {
        this.time = tag.m_128451_("time");
        if (!tag.m_128441_("time_unit")) {
            FTBRanks.LOGGER.warn("missing 'time_unit' field in playtime condition - assuming 'ticks'");
        }
        switch (tag.m_128461_("time_unit")) {
            case "seconds": {
                this.timeUnit = 20;
                break;
            }
            case "minutes": {
                this.timeUnit = 1200;
                break;
            }
            case "hours": {
                this.timeUnit = 72000;
                break;
            }
            case "days": {
                this.timeUnit = 1728000;
                break;
            }
            case "weeks": {
                this.timeUnit = 12096000;
                break;
            }
            default: {
                this.timeUnit = 1;
            }
        }
        this.stat = Stats.f_12988_.m_12902_((Object)Stats.f_144255_);
    }

    @Override
    public String getType() {
        return "playtime";
    }

    @Override
    public boolean isRankActive(ServerPlayer player) {
        return player.m_8951_().m_13015_(this.stat) >= this.time * this.timeUnit;
    }

    @Override
    public void save(SNBTCompoundTag tag) {
        tag.m_128405_("time", this.time);
        switch (this.timeUnit) {
            case 20: {
                tag.m_128359_("time_unit", "seconds");
                break;
            }
            case 1200: {
                tag.m_128359_("time_unit", "minutes");
                break;
            }
            case 72000: {
                tag.m_128359_("time_unit", "hours");
                break;
            }
            case 1728000: {
                tag.m_128359_("time_unit", "days");
                break;
            }
            case 12096000: {
                tag.m_128359_("time_unit", "weeks");
                break;
            }
            default: {
                tag.m_128359_("time_unit", "ticks");
            }
        }
    }
}

