/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.platform.api.DeferredRegister;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006DEFGHIB\t\b\u0002\u00a2\u0006\u0004\bC\u0010\u0014J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014R#\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00160\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001c\u001a\u0004\b \u0010\u001eR\u0017\u0010!\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b!\u0010\u001c\u001a\u0004\b\"\u0010\u001eR\u0017\u0010#\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b#\u0010\u001c\u001a\u0004\b$\u0010\u001eR\u0017\u0010%\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b%\u0010\u001c\u001a\u0004\b&\u0010\u001eR\u0017\u0010'\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b'\u0010\u001c\u001a\u0004\b(\u0010\u001eR\u0017\u0010)\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b)\u0010\u001c\u001a\u0004\b*\u0010\u001eR\u0017\u0010+\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b+\u0010\u001c\u001a\u0004\b,\u0010\u001eR\u0017\u0010-\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b-\u0010\u001c\u001a\u0004\b.\u0010\u001eR\u0017\u0010/\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b/\u0010\u001c\u001a\u0004\b0\u0010\u001eR\u0017\u00101\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b1\u0010\u001c\u001a\u0004\b2\u0010\u001eR\u0017\u00103\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b3\u0010\u001c\u001a\u0004\b4\u0010\u001eR\u0017\u00105\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b5\u0010\u001c\u001a\u0004\b6\u0010\u001eR\u0017\u00107\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b7\u0010\u001c\u001a\u0004\b8\u0010\u001eR\u0017\u00109\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b9\u0010\u001c\u001a\u0004\b:\u0010\u001eR\u0017\u0010;\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b;\u0010\u001c\u001a\u0004\b<\u0010\u001eR\u0017\u0010=\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b=\u0010\u001c\u001a\u0004\b>\u0010\u001eR\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020@0?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010B\u00a8\u0006J"}, d2={"Lorg/valkyrienskies/clockwork/ClockworkSounds;", "", "", "name", "Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntryBuilder;", "create", "(Ljava/lang/String;)Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntryBuilder;", "Lnet/minecraft/resources/ResourceLocation;", "id", "(Lnet/minecraft/resources/ResourceLocation;)Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntryBuilder;", "Lcom/google/gson/JsonObject;", "provideLangEntries", "()Lcom/google/gson/JsonObject;", "Lnet/minecraft/data/DataGenerator;", "generator", "Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntryProvider;", "provider", "(Lnet/minecraft/data/DataGenerator;)Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntryProvider;", "", "register", "()V", "", "Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntry;", "ALL", "Ljava/util/Map;", "getALL", "()Ljava/util/Map;", "BOING", "Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntry;", "getBOING", "()Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntry;", "DESIGNATOR_ACTIVATE", "getDESIGNATOR_ACTIVATE", "DESIGNATOR_DUMP_CLUSTER", "getDESIGNATOR_DUMP_CLUSTER", "DESIGNATOR_IDLE", "getDESIGNATOR_IDLE", "DESIGNATOR_SELECT_END", "getDESIGNATOR_SELECT_END", "DESIGNATOR_SELECT_START", "getDESIGNATOR_SELECT_START", "DOINK", "getDOINK", "PHYSICS_INFUSER_FINISH", "getPHYSICS_INFUSER_FINISH", "PHYSICS_INFUSER_INITIALIZE", "getPHYSICS_INFUSER_INITIALIZE", "PHYSICS_INFUSER_LIGHTNING", "getPHYSICS_INFUSER_LIGHTNING", "PHYSICS_INFUSER_WINDUP", "getPHYSICS_INFUSER_WINDUP", "SUPERSONIC", "getSUPERSONIC", "THICK_FLUID_EMPTY", "getTHICK_FLUID_EMPTY", "THICK_FLUID_FILL", "getTHICK_FLUID_FILL", "THICK_FLUID_SWIM", "getTHICK_FLUID_SWIM", "WELDER_WELD", "getWELDER_WELD", "WELDER_WHIRR", "getWELDER_WHIRR", "Lorg/valkyrienskies/clockwork/platform/api/DeferredRegister;", "Lnet/minecraft/sounds/SoundEvent;", "sounds", "Lorg/valkyrienskies/clockwork/platform/api/DeferredRegister;", "<init>", "ConfiguredSoundEvent", "CustomSoundEntry", "SoundEntry", "SoundEntryBuilder", "SoundEntryProvider", "WrappedSoundEntry", "clockwork"})
public final class ClockworkSounds {
    @NotNull
    public static final ClockworkSounds INSTANCE = new ClockworkSounds();
    @NotNull
    private static final Map<ResourceLocation, SoundEntry> ALL = new HashMap();
    @NotNull
    private static final SoundEntry PHYSICS_INFUSER_INITIALIZE = INSTANCE.create("physics_infuser_initialize").subtitle("Physics Infuser starts").category(SoundSource.BLOCKS).attenuationDistance(32).build();
    @NotNull
    private static final SoundEntry PHYSICS_INFUSER_WINDUP = INSTANCE.create("physics_infuser_windup").subtitle("Physics Infuser windup").category(SoundSource.BLOCKS).attenuationDistance(32).build();
    @NotNull
    private static final SoundEntry PHYSICS_INFUSER_LIGHTNING = INSTANCE.create("physics_infuser_lightning").subtitle("Zap!").category(SoundSource.BLOCKS).attenuationDistance(16).build();
    @NotNull
    private static final SoundEntry THICK_FLUID_SWIM = INSTANCE.create("thick_fluid_swim").subtitle("Swimming through thick fluid").category(SoundSource.BLOCKS).attenuationDistance(16).build();
    @NotNull
    private static final SoundEntry THICK_FLUID_FILL = INSTANCE.create("thick_fluid_fill").subtitle("Filled with a thick fluid").category(SoundSource.PLAYERS).attenuationDistance(16).build();
    @NotNull
    private static final SoundEntry THICK_FLUID_EMPTY = INSTANCE.create("thick_fluid_empty").subtitle("Emptied a thick fluid").category(SoundSource.PLAYERS).attenuationDistance(16).build();
    @NotNull
    private static final SoundEntry PHYSICS_INFUSER_FINISH = INSTANCE.create("physics_infuser_finish").subtitle("Physics Infuser infuses").category(SoundSource.BLOCKS).attenuationDistance(64).build();
    @NotNull
    private static final SoundEntry WELDER_WELD = INSTANCE.create("welder_weld").subtitle("Welder welds").category(SoundSource.PLAYERS).attenuationDistance(16).build();
    @NotNull
    private static final SoundEntry WELDER_WHIRR = INSTANCE.create("welder_whirr").subtitle("Welder whirrs").category(SoundSource.PLAYERS).attenuationDistance(16).build();
    @NotNull
    private static final SoundEntry SUPERSONIC = INSTANCE.create("supersonic").subtitle("Supersonic").category(SoundSource.RECORDS).attenuationDistance(32).build();
    @NotNull
    private static final SoundEntry DESIGNATOR_ACTIVATE = INSTANCE.create("designator_activate").subtitle("Designator activates").category(SoundSource.PLAYERS).attenuationDistance(16).build();
    @NotNull
    private static final SoundEntry DESIGNATOR_DUMP_CLUSTER = INSTANCE.create("designator_dump_cluster").subtitle("Designator discharges").category(SoundSource.PLAYERS).attenuationDistance(16).build();
    @NotNull
    private static final SoundEntry DESIGNATOR_SELECT_START = INSTANCE.create("designator_select_start").subtitle("Designator starts up").category(SoundSource.PLAYERS).attenuationDistance(16).build();
    @NotNull
    private static final SoundEntry DESIGNATOR_SELECT_END = INSTANCE.create("designator_select_end").subtitle("Designator selects").category(SoundSource.PLAYERS).attenuationDistance(16).build();
    @NotNull
    private static final SoundEntry DESIGNATOR_IDLE = INSTANCE.create("designator_idle").subtitle("Designator fizzles").category(SoundSource.PLAYERS).attenuationDistance(16).build();
    @NotNull
    private static final SoundEntry BOING = INSTANCE.create("boing").subtitle("Boioing!").category(SoundSource.BLOCKS).attenuationDistance(16).build();
    @NotNull
    private static final SoundEntry DOINK = INSTANCE.create("doink").subtitle("Doink.").category(SoundSource.BLOCKS).attenuationDistance(16).build();
    @NotNull
    private static final DeferredRegister<SoundEvent> sounds;

    private ClockworkSounds() {
    }

    @NotNull
    public final Map<ResourceLocation, SoundEntry> getALL() {
        return ALL;
    }

    @NotNull
    public final SoundEntry getPHYSICS_INFUSER_INITIALIZE() {
        return PHYSICS_INFUSER_INITIALIZE;
    }

    @NotNull
    public final SoundEntry getPHYSICS_INFUSER_WINDUP() {
        return PHYSICS_INFUSER_WINDUP;
    }

    @NotNull
    public final SoundEntry getPHYSICS_INFUSER_LIGHTNING() {
        return PHYSICS_INFUSER_LIGHTNING;
    }

    @NotNull
    public final SoundEntry getTHICK_FLUID_SWIM() {
        return THICK_FLUID_SWIM;
    }

    @NotNull
    public final SoundEntry getTHICK_FLUID_FILL() {
        return THICK_FLUID_FILL;
    }

    @NotNull
    public final SoundEntry getTHICK_FLUID_EMPTY() {
        return THICK_FLUID_EMPTY;
    }

    @NotNull
    public final SoundEntry getPHYSICS_INFUSER_FINISH() {
        return PHYSICS_INFUSER_FINISH;
    }

    @NotNull
    public final SoundEntry getWELDER_WELD() {
        return WELDER_WELD;
    }

    @NotNull
    public final SoundEntry getWELDER_WHIRR() {
        return WELDER_WHIRR;
    }

    @NotNull
    public final SoundEntry getSUPERSONIC() {
        return SUPERSONIC;
    }

    @NotNull
    public final SoundEntry getDESIGNATOR_ACTIVATE() {
        return DESIGNATOR_ACTIVATE;
    }

    @NotNull
    public final SoundEntry getDESIGNATOR_DUMP_CLUSTER() {
        return DESIGNATOR_DUMP_CLUSTER;
    }

    @NotNull
    public final SoundEntry getDESIGNATOR_SELECT_START() {
        return DESIGNATOR_SELECT_START;
    }

    @NotNull
    public final SoundEntry getDESIGNATOR_SELECT_END() {
        return DESIGNATOR_SELECT_END;
    }

    @NotNull
    public final SoundEntry getDESIGNATOR_IDLE() {
        return DESIGNATOR_IDLE;
    }

    @NotNull
    public final SoundEntry getBOING() {
        return BOING;
    }

    @NotNull
    public final SoundEntry getDOINK() {
        return DOINK;
    }

    private final SoundEntryBuilder create(String name) {
        return this.create(ClockworkMod.asResource(name));
    }

    @NotNull
    public final SoundEntryBuilder create(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new SoundEntryBuilder(id);
    }

    @JvmStatic
    public static final void register() {
        for (SoundEntry entry : ALL.values()) {
            entry.register();
        }
        sounds.registerAll();
    }

    @NotNull
    public final JsonObject provideLangEntries() {
        JsonObject object = new JsonObject();
        for (SoundEntry entry : ALL.values()) {
            if (!entry.hasSubtitle()) continue;
            object.addProperty(entry.getSubtitleKey(), entry.getSubtitle());
        }
        return object;
    }

    @NotNull
    public final SoundEntryProvider provider(@NotNull DataGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        return new SoundEntryProvider(generator);
    }

    static {
        DeferredRegister deferredRegister = DeferredRegister.create(BuiltInRegistries.f_256894_, "vs_clockwork");
        Intrinsics.checkNotNullExpressionValue(deferredRegister, (String)"create(...)");
        sounds = deferredRegister;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ4\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0019\u001a\u0004\b\u001a\u0010\u0005R\u0017\u0010\f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u001b\u001a\u0004\b\u001c\u0010\bR\u0017\u0010\u000b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001b\u001a\u0004\b\u001d\u0010\b\u00a8\u0006 "}, d2={"Lorg/valkyrienskies/clockwork/ClockworkSounds$ConfiguredSoundEvent;", "", "Ljava/util/function/Supplier;", "Lnet/minecraft/sounds/SoundEvent;", "component1", "()Ljava/util/function/Supplier;", "", "component2", "()F", "component3", "event", "volume", "pitch", "copy", "(Ljava/util/function/Supplier;FF)Lorg/valkyrienskies/clockwork/ClockworkSounds$ConfiguredSoundEvent;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/function/Supplier;", "getEvent", "F", "getPitch", "getVolume", "<init>", "(Ljava/util/function/Supplier;FF)V", "clockwork"})
    public static final class ConfiguredSoundEvent {
        @NotNull
        private final Supplier<SoundEvent> event;
        private final float volume;
        private final float pitch;

        public ConfiguredSoundEvent(@NotNull Supplier<SoundEvent> event, float volume, float pitch) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            this.event = event;
            this.volume = volume;
            this.pitch = pitch;
        }

        @NotNull
        public final Supplier<SoundEvent> getEvent() {
            return this.event;
        }

        public final float getVolume() {
            return this.volume;
        }

        public final float getPitch() {
            return this.pitch;
        }

        @NotNull
        public final Supplier<SoundEvent> component1() {
            return this.event;
        }

        public final float component2() {
            return this.volume;
        }

        public final float component3() {
            return this.pitch;
        }

        @NotNull
        public final ConfiguredSoundEvent copy(@NotNull Supplier<SoundEvent> event, float volume, float pitch) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            return new ConfiguredSoundEvent(event, volume, pitch);
        }

        public static /* synthetic */ ConfiguredSoundEvent copy$default(ConfiguredSoundEvent configuredSoundEvent, Supplier supplier, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                supplier = configuredSoundEvent.event;
            }
            if ((n & 2) != 0) {
                f = configuredSoundEvent.volume;
            }
            if ((n & 4) != 0) {
                f2 = configuredSoundEvent.pitch;
            }
            return configuredSoundEvent.copy(supplier, f, f2);
        }

        @NotNull
        public String toString() {
            return "ConfiguredSoundEvent(event=" + this.event + ", volume=" + this.volume + ", pitch=" + this.pitch + ")";
        }

        public int hashCode() {
            int result = this.event.hashCode();
            result = result * 31 + Float.hashCode(this.volume);
            result = result * 31 + Float.hashCode(this.pitch);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConfiguredSoundEvent)) {
                return false;
            }
            ConfiguredSoundEvent configuredSoundEvent = (ConfiguredSoundEvent)other;
            if (!Intrinsics.areEqual(this.event, configuredSoundEvent.event)) {
                return false;
            }
            if (Float.compare(this.volume, configuredSoundEvent.volume) != 0) {
                return false;
            }
            return Float.compare(this.pitch, configuredSoundEvent.pitch) == 0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010*\u001a\u00020#\u0012\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"\u0012\b\u0010,\u001a\u0004\u0018\u00010+\u0012\u0006\u0010.\u001a\u00020-\u0012\u0006\u00100\u001a\u00020/\u00a2\u0006\u0004\b1\u00102JK\u0010\u000e\u001a\u00020\r2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJI\u0010\u0012\u001a\u00020\r2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0019\u0010\u0018\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R.\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a8\u0016@TX\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R(\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u00063"}, d2={"Lorg/valkyrienskies/clockwork/ClockworkSounds$CustomSoundEntry;", "Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntry;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "entity", "", "x", "y", "z", "", "volume", "pitch", "", "play", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;DDDFF)V", "", "fade", "playAt", "(Lnet/minecraft/world/level/Level;DDDFFZ)V", "register", "()V", "Lcom/google/gson/JsonObject;", "json", "write", "(Lcom/google/gson/JsonObject;)V", "Lnet/minecraft/sounds/SoundEvent;", "<set-?>", "mainEvent", "Lnet/minecraft/sounds/SoundEvent;", "getMainEvent", "()Lnet/minecraft/sounds/SoundEvent;", "setMainEvent", "(Lnet/minecraft/sounds/SoundEvent;)V", "", "Lnet/minecraft/resources/ResourceLocation;", "variants", "Ljava/util/List;", "getVariants", "()Ljava/util/List;", "setVariants", "(Ljava/util/List;)V", "id", "", "subtitle", "Lnet/minecraft/sounds/SoundSource;", "category", "", "attenuationDistance", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Ljava/util/List;Ljava/lang/String;Lnet/minecraft/sounds/SoundSource;I)V", "clockwork"})
    private static final class CustomSoundEntry
    extends SoundEntry {
        @NotNull
        private List<? extends ResourceLocation> variants;
        @Nullable
        private SoundEvent mainEvent;

        public CustomSoundEntry(@NotNull ResourceLocation id, @NotNull List<? extends ResourceLocation> variants, @Nullable String subtitle, @NotNull SoundSource category, int attenuationDistance) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(variants, (String)"variants");
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            super(id, subtitle, category, attenuationDistance);
            this.variants = variants;
        }

        @NotNull
        protected final List<ResourceLocation> getVariants() {
            return this.variants;
        }

        protected final void setVariants(@NotNull List<? extends ResourceLocation> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.variants = list;
        }

        @Override
        @Nullable
        public SoundEvent getMainEvent() {
            return this.mainEvent;
        }

        protected void setMainEvent(@Nullable SoundEvent soundEvent) {
            this.mainEvent = soundEvent;
        }

        @Override
        public void register() {
            sounds.register(this.getId().m_135815_(), () -> CustomSoundEntry.register$lambda$0(this));
        }

        @Override
        public void write(@Nullable JsonObject json) {
            JsonObject entry = new JsonObject();
            JsonArray list = new JsonArray();
            JsonObject s = new JsonObject();
            s.addProperty("name", this.getId().toString());
            s.addProperty("type", "file");
            if (this.getAttenuationDistance() != 0) {
                s.addProperty("attenuation_distance", (Number)this.getAttenuationDistance());
            }
            list.add((JsonElement)s);
            for (ResourceLocation resourceLocation : this.variants) {
                s = new JsonObject();
                s.addProperty("name", resourceLocation.toString());
                s.addProperty("type", "file");
                if (this.getAttenuationDistance() != 0) {
                    s.addProperty("attenuation_distance", (Number)this.getAttenuationDistance());
                }
                list.add((JsonElement)s);
            }
            entry.add("sounds", (JsonElement)list);
            if (this.hasSubtitle()) {
                entry.addProperty("subtitle", this.getSubtitleKey());
            }
            JsonObject jsonObject = json;
            Intrinsics.checkNotNull((Object)jsonObject);
            jsonObject.add(this.getId().m_135815_(), (JsonElement)entry);
        }

        @Override
        public void play(@Nullable Level world, @Nullable Player entity, double x, double y, double z, float volume, float pitch) {
            Level level = world;
            Intrinsics.checkNotNull((Object)level);
            level.m_6263_(entity, x, y, z, this.getMainEvent(), this.getCategory(), volume, pitch);
        }

        @Override
        public void playAt(@Nullable Level world, double x, double y, double z, float volume, float pitch, boolean fade) {
            Level level = world;
            Intrinsics.checkNotNull((Object)level);
            level.m_7785_(x, y, z, this.getMainEvent(), this.getCategory(), volume, pitch, fade);
        }

        private static final SoundEvent register$lambda$0(CustomSoundEntry this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.setMainEvent(SoundEvent.m_262824_((ResourceLocation)this$0.getId()));
            SoundEvent soundEvent = this$0.getMainEvent();
            Intrinsics.checkNotNull((Object)soundEvent);
            return soundEvent;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001B)\u0012\u0006\u00107\u001a\u000206\u0012\b\u0010B\u001a\u0004\u0018\u00010A\u0012\u0006\u00100\u001a\u00020/\u0012\u0006\u0010)\u001a\u00020(\u00a2\u0006\u0004\bJ\u0010KJ\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004JK\u0010\u0011\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH&\u00a2\u0006\u0004\b\u0011\u0010\u0012J?\u0010\u0011\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0015J9\u0010\u0011\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0004\b\u0011\u0010\u0017JI\u0010\u0019\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0019\u0010\u001aJ7\u0010\u0019\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001bJ7\u0010\u0019\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001cJ+\u0010\u001e\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u001d2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ5\u0010 \u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u0010H&\u00a2\u0006\u0004\b\"\u0010#J\u0019\u0010&\u001a\u00020\u00102\b\u0010%\u001a\u0004\u0018\u00010$H&\u00a2\u0006\u0004\b&\u0010'R\"\u0010)\u001a\u00020(8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\"\u00100\u001a\u00020/8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b0\u00101\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\"\u00107\u001a\u0002068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0016\u0010@\u001a\u0004\u0018\u00010=8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R$\u0010B\u001a\u0004\u0018\u00010A8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bB\u0010C\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u0011\u0010I\u001a\u00020A8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010E\u00a8\u0006L"}, d2={"Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntry;", "", "", "hasSubtitle", "()Z", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "entity", "", "x", "y", "z", "", "volume", "pitch", "", "play", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;DDDFF)V", "Lnet/minecraft/core/Vec3i;", "pos", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/Vec3i;FF)V", "Lnet/minecraft/world/phys/Vec3;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;FF)V", "fade", "playAt", "(Lnet/minecraft/world/level/Level;DDDFFZ)V", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/Vec3i;FFZ)V", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;FFZ)V", "Lnet/minecraft/world/entity/Entity;", "playFrom", "(Lnet/minecraft/world/entity/Entity;FF)V", "playOnServer", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/Vec3i;FF)V", "register", "()V", "Lcom/google/gson/JsonObject;", "json", "write", "(Lcom/google/gson/JsonObject;)V", "", "attenuationDistance", "I", "getAttenuationDistance", "()I", "setAttenuationDistance", "(I)V", "Lnet/minecraft/sounds/SoundSource;", "category", "Lnet/minecraft/sounds/SoundSource;", "getCategory", "()Lnet/minecraft/sounds/SoundSource;", "setCategory", "(Lnet/minecraft/sounds/SoundSource;)V", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "setId", "(Lnet/minecraft/resources/ResourceLocation;)V", "Lnet/minecraft/sounds/SoundEvent;", "getMainEvent", "()Lnet/minecraft/sounds/SoundEvent;", "mainEvent", "", "subtitle", "Ljava/lang/String;", "getSubtitle", "()Ljava/lang/String;", "setSubtitle", "(Ljava/lang/String;)V", "getSubtitleKey", "subtitleKey", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/String;Lnet/minecraft/sounds/SoundSource;I)V", "clockwork"})
    public static abstract class SoundEntry {
        @NotNull
        private ResourceLocation id;
        @Nullable
        private String subtitle;
        @NotNull
        private SoundSource category;
        private int attenuationDistance;

        public SoundEntry(@NotNull ResourceLocation id, @Nullable String subtitle, @NotNull SoundSource category, int attenuationDistance) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            this.id = id;
            this.subtitle = subtitle;
            this.category = category;
            this.attenuationDistance = attenuationDistance;
        }

        @NotNull
        public final ResourceLocation getId() {
            return this.id;
        }

        public final void setId(@NotNull ResourceLocation resourceLocation) {
            Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
            this.id = resourceLocation;
        }

        @Nullable
        public final String getSubtitle() {
            return this.subtitle;
        }

        public final void setSubtitle(@Nullable String string) {
            this.subtitle = string;
        }

        @NotNull
        protected final SoundSource getCategory() {
            return this.category;
        }

        protected final void setCategory(@NotNull SoundSource soundSource) {
            Intrinsics.checkNotNullParameter((Object)soundSource, (String)"<set-?>");
            this.category = soundSource;
        }

        protected final int getAttenuationDistance() {
            return this.attenuationDistance;
        }

        protected final void setAttenuationDistance(int n) {
            this.attenuationDistance = n;
        }

        public abstract void register();

        public abstract void write(@Nullable JsonObject var1);

        @Nullable
        public abstract SoundEvent getMainEvent();

        @NotNull
        public final String getSubtitleKey() {
            return this.id.m_135827_() + ".subtitle." + this.id.m_135815_();
        }

        public final boolean hasSubtitle() {
            return this.subtitle != null;
        }

        @JvmOverloads
        public final void playOnServer(@Nullable Level world, @NotNull Vec3i pos, float volume, float pitch) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.play(world, null, pos, volume, pitch);
        }

        public static /* synthetic */ void playOnServer$default(SoundEntry soundEntry, Level level, Vec3i vec3i, float f, float f2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: playOnServer");
            }
            if ((n & 4) != 0) {
                f = 1.0f;
            }
            if ((n & 8) != 0) {
                f2 = 1.0f;
            }
            soundEntry.playOnServer(level, vec3i, f, f2);
        }

        @JvmOverloads
        public final void playFrom(@NotNull Entity entity, float volume, float pitch) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            if (!entity.m_20067_()) {
                Level level = entity.m_9236_();
                BlockPos blockPos = entity.m_20183_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
                this.play(level, null, (Vec3i)blockPos, volume, pitch);
            }
        }

        public static /* synthetic */ void playFrom$default(SoundEntry soundEntry, Entity entity, float f, float f2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: playFrom");
            }
            if ((n & 2) != 0) {
                f = 1.0f;
            }
            if ((n & 4) != 0) {
                f2 = 1.0f;
            }
            soundEntry.playFrom(entity, f, f2);
        }

        @JvmOverloads
        public final void play(@Nullable Level world, @Nullable Player entity, @NotNull Vec3i pos, float volume, float pitch) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.play(world, entity, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, volume, pitch);
        }

        public static /* synthetic */ void play$default(SoundEntry soundEntry, Level level, Player player, Vec3i vec3i, float f, float f2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: play");
            }
            if ((n & 8) != 0) {
                f = 1.0f;
            }
            if ((n & 0x10) != 0) {
                f2 = 1.0f;
            }
            soundEntry.play(level, player, vec3i, f, f2);
        }

        public final void play(@Nullable Level world, @Nullable Player entity, @NotNull Vec3 pos, float volume, float pitch) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.play(world, entity, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), volume, pitch);
        }

        public abstract void play(@Nullable Level var1, @Nullable Player var2, double var3, double var5, double var7, float var9, float var10);

        public final void playAt(@Nullable Level world, @NotNull Vec3i pos, float volume, float pitch, boolean fade) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.playAt(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, volume, pitch, fade);
        }

        public final void playAt(@Nullable Level world, @NotNull Vec3 pos, float volume, float pitch, boolean fade) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.playAt(world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), volume, pitch, fade);
        }

        public abstract void playAt(@Nullable Level var1, double var2, double var4, double var6, float var8, float var9, boolean var10);

        @JvmOverloads
        public final void playOnServer(@Nullable Level world, @NotNull Vec3i pos, float volume) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            SoundEntry.playOnServer$default(this, world, pos, volume, 0.0f, 8, null);
        }

        @JvmOverloads
        public final void playOnServer(@Nullable Level world, @NotNull Vec3i pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            SoundEntry.playOnServer$default(this, world, pos, 0.0f, 0.0f, 12, null);
        }

        @JvmOverloads
        public final void playFrom(@NotNull Entity entity, float volume) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            SoundEntry.playFrom$default(this, entity, volume, 0.0f, 4, null);
        }

        @JvmOverloads
        public final void playFrom(@NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            SoundEntry.playFrom$default(this, entity, 0.0f, 0.0f, 6, null);
        }

        @JvmOverloads
        public final void play(@Nullable Level world, @Nullable Player entity, @NotNull Vec3i pos, float volume) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            SoundEntry.play$default(this, world, entity, pos, volume, 0.0f, 16, null);
        }

        @JvmOverloads
        public final void play(@Nullable Level world, @Nullable Player entity, @NotNull Vec3i pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            SoundEntry.play$default(this, world, entity, pos, 0.0f, 0.0f, 24, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u001a\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b>\u0010-J\u0015\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J+\u0010\u001b\u001a\u00020\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cJ+\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00002\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0005R\"\u0010\u000b\u001a\u00020\t8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\"\u0010\u0011\u001a\u00020\u00108\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\"\u0010\u0007\u001a\u00020\u00068\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010\u001e\u001a\u0004\u0018\u00010\u00028\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102R(\u00104\u001a\b\u0012\u0004\u0012\u00020\u0006038\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109R(\u0010;\u001a\b\u0012\u0004\u0012\u00020:038\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b;\u00105\u001a\u0004\b<\u00107\"\u0004\b=\u00109\u00a8\u0006?"}, d2={"Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntryBuilder;", "", "", "name", "addVariant", "(Ljava/lang/String;)Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntryBuilder;", "Lnet/minecraft/resources/ResourceLocation;", "id", "(Lnet/minecraft/resources/ResourceLocation;)Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntryBuilder;", "", "distance", "attenuationDistance", "(I)Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntryBuilder;", "Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntry;", "build", "()Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntry;", "Lnet/minecraft/sounds/SoundSource;", "category", "(Lnet/minecraft/sounds/SoundSource;)Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntryBuilder;", "noSubtitle", "()Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntryBuilder;", "Ljava/util/function/Supplier;", "Lnet/minecraft/sounds/SoundEvent;", "event", "", "volume", "pitch", "playExisting", "(Ljava/util/function/Supplier;FF)Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntryBuilder;", "(Lnet/minecraft/sounds/SoundEvent;FF)Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntryBuilder;", "subtitle", "I", "getAttenuationDistance", "()I", "setAttenuationDistance", "(I)V", "Lnet/minecraft/sounds/SoundSource;", "getCategory", "()Lnet/minecraft/sounds/SoundSource;", "setCategory", "(Lnet/minecraft/sounds/SoundSource;)V", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "setId", "(Lnet/minecraft/resources/ResourceLocation;)V", "Ljava/lang/String;", "getSubtitle", "()Ljava/lang/String;", "setSubtitle", "(Ljava/lang/String;)V", "", "variants", "Ljava/util/List;", "getVariants", "()Ljava/util/List;", "setVariants", "(Ljava/util/List;)V", "Lorg/valkyrienskies/clockwork/ClockworkSounds$ConfiguredSoundEvent;", "wrappedEvents", "getWrappedEvents", "setWrappedEvents", "<init>", "clockwork"})
    public static final class SoundEntryBuilder {
        @NotNull
        private ResourceLocation id;
        @Nullable
        private String subtitle;
        @NotNull
        private SoundSource category;
        @NotNull
        private List<ConfiguredSoundEvent> wrappedEvents;
        @NotNull
        private List<ResourceLocation> variants;
        private int attenuationDistance;

        public SoundEntryBuilder(@NotNull ResourceLocation id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
            this.subtitle = "unregistered";
            this.category = SoundSource.BLOCKS;
            this.wrappedEvents = new ArrayList();
            this.variants = new ArrayList();
        }

        @NotNull
        protected final ResourceLocation getId() {
            return this.id;
        }

        protected final void setId(@NotNull ResourceLocation resourceLocation) {
            Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
            this.id = resourceLocation;
        }

        @Nullable
        protected final String getSubtitle() {
            return this.subtitle;
        }

        protected final void setSubtitle(@Nullable String string) {
            this.subtitle = string;
        }

        @NotNull
        protected final SoundSource getCategory() {
            return this.category;
        }

        protected final void setCategory(@NotNull SoundSource soundSource) {
            Intrinsics.checkNotNullParameter((Object)soundSource, (String)"<set-?>");
            this.category = soundSource;
        }

        @NotNull
        protected final List<ConfiguredSoundEvent> getWrappedEvents() {
            return this.wrappedEvents;
        }

        protected final void setWrappedEvents(@NotNull List<ConfiguredSoundEvent> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.wrappedEvents = list;
        }

        @NotNull
        protected final List<ResourceLocation> getVariants() {
            return this.variants;
        }

        protected final void setVariants(@NotNull List<ResourceLocation> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.variants = list;
        }

        protected final int getAttenuationDistance() {
            return this.attenuationDistance;
        }

        protected final void setAttenuationDistance(int n) {
            this.attenuationDistance = n;
        }

        @NotNull
        public final SoundEntryBuilder subtitle(@Nullable String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        @NotNull
        public final SoundEntryBuilder attenuationDistance(int distance) {
            this.attenuationDistance = distance;
            return this;
        }

        @NotNull
        public final SoundEntryBuilder noSubtitle() {
            this.subtitle = null;
            return this;
        }

        @NotNull
        public final SoundEntryBuilder category(@NotNull SoundSource category) {
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            this.category = category;
            return this;
        }

        @NotNull
        public final SoundEntryBuilder addVariant(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.addVariant(ClockworkMod.asResource(name));
        }

        @NotNull
        public final SoundEntryBuilder addVariant(@NotNull ResourceLocation id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.variants.add(id);
            return this;
        }

        @NotNull
        public final SoundEntryBuilder playExisting(@NotNull Supplier<SoundEvent> event, float volume, float pitch) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            this.wrappedEvents.add(new ConfiguredSoundEvent(event, volume, pitch));
            return this;
        }

        @JvmOverloads
        @NotNull
        public final SoundEntryBuilder playExisting(@NotNull SoundEvent event, float volume, float pitch) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return this.playExisting(() -> SoundEntryBuilder.playExisting$lambda$0(event), volume, pitch);
        }

        public static /* synthetic */ SoundEntryBuilder playExisting$default(SoundEntryBuilder soundEntryBuilder, SoundEvent soundEvent, float f, float f2, int n, Object object) {
            if ((n & 2) != 0) {
                f = 1.0f;
            }
            if ((n & 4) != 0) {
                f2 = 1.0f;
            }
            return soundEntryBuilder.playExisting(soundEvent, f, f2);
        }

        @NotNull
        public final SoundEntry build() {
            SoundEntry soundEntry;
            if (this.wrappedEvents.isEmpty()) {
                soundEntry = new CustomSoundEntry(this.id, this.variants, this.subtitle, this.category, this.attenuationDistance);
            } else {
                String string = this.subtitle;
                Intrinsics.checkNotNull((Object)string);
                soundEntry = new WrappedSoundEntry(this.id, string, this.wrappedEvents, this.category, this.attenuationDistance);
            }
            SoundEntry entry = soundEntry;
            INSTANCE.getALL().put(entry.getId(), entry);
            return entry;
        }

        @JvmOverloads
        @NotNull
        public final SoundEntryBuilder playExisting(@NotNull SoundEvent event, float volume) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return SoundEntryBuilder.playExisting$default(this, event, volume, 0.0f, 4, null);
        }

        @JvmOverloads
        @NotNull
        public final SoundEntryBuilder playExisting(@NotNull SoundEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return SoundEntryBuilder.playExisting$default(this, event, 0.0f, 0.0f, 6, null);
        }

        private static final SoundEvent playExisting$lambda$0(SoundEvent $event) {
            Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
            return $event;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntryProvider;", "Lnet/minecraft/data/DataProvider;", "Ljava/nio/file/Path;", "path", "Lnet/minecraft/data/CachedOutput;", "cache", "", "generate", "(Ljava/nio/file/Path;Lnet/minecraft/data/CachedOutput;)V", "", "getName", "()Ljava/lang/String;", "output", "Ljava/util/concurrent/CompletableFuture;", "run", "(Lnet/minecraft/data/CachedOutput;)Ljava/util/concurrent/CompletableFuture;", "Lnet/minecraft/data/DataGenerator;", "generator", "Lnet/minecraft/data/DataGenerator;", "<init>", "(Lnet/minecraft/data/DataGenerator;)V", "clockwork"})
    public static final class SoundEntryProvider
    implements DataProvider {
        @NotNull
        private final DataGenerator generator;

        public SoundEntryProvider(@NotNull DataGenerator generator) {
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            this.generator = generator;
        }

        @NotNull
        public CompletableFuture<?> m_213708_(@NotNull CachedOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @NotNull
        public String m_6055_() {
            return "Clockwork's Custom Sounds";
        }

        public final void generate(@NotNull Path path, @Nullable CachedOutput cache) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Path path2 = path;
            Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            Path path3 = path2.resolve("assets/vs_clockwork");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            path2 = path3;
            try {
                JsonObject json = new JsonObject();
                INSTANCE.getALL().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(arg_0 -> SoundEntryProvider.generate$lambda$0((Function1)new Function1<Map.Entry<? extends ResourceLocation, ? extends SoundEntry>, Unit>(json){
                    final /* synthetic */ JsonObject $json;
                    {
                        this.$json = $json;
                        super(1);
                    }

                    public final void invoke(@NotNull Map.Entry<? extends ResourceLocation, ? extends SoundEntry> entry) {
                        Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                        SoundEntry value = entry.getValue();
                        value.write(this.$json);
                    }
                }, arg_0));
                DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)json), (Path)path2.resolve("sounds.json"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private static final void generate$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u00012B5\u0012\u0006\u0010*\u001a\u00020\u0004\u0012\u0006\u0010,\u001a\u00020+\u0012\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'\u0012\u0006\u0010.\u001a\u00020-\u0012\u0006\u0010/\u001a\u00020\u0002\u00a2\u0006\u0004\b0\u00101J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006JK\u0010\u0013\u001a\u00020\u00122\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014JI\u0010\u0017\u001a\u00020\u00122\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0019\u0010\u001d\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010&\u001a\u0004\u0018\u00010#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010\"\u00a8\u00063"}, d2={"Lorg/valkyrienskies/clockwork/ClockworkSounds$WrappedSoundEntry;", "Lorg/valkyrienskies/clockwork/ClockworkSounds$SoundEntry;", "", "i", "Lnet/minecraft/resources/ResourceLocation;", "getIdOf", "(I)Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "entity", "", "x", "y", "z", "", "volume", "pitch", "", "play", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;DDDFF)V", "", "fade", "playAt", "(Lnet/minecraft/world/level/Level;DDDFFZ)V", "register", "()V", "Lcom/google/gson/JsonObject;", "json", "write", "(Lcom/google/gson/JsonObject;)V", "", "Lorg/valkyrienskies/clockwork/ClockworkSounds$WrappedSoundEntry$CompiledSoundEvent;", "compiledEvents", "Ljava/util/List;", "Lnet/minecraft/sounds/SoundEvent;", "getMainEvent", "()Lnet/minecraft/sounds/SoundEvent;", "mainEvent", "", "Lorg/valkyrienskies/clockwork/ClockworkSounds$ConfiguredSoundEvent;", "wrappedEvents", "id", "", "subtitle", "Lnet/minecraft/sounds/SoundSource;", "category", "attenuationDistance", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/String;Ljava/util/List;Lnet/minecraft/sounds/SoundSource;I)V", "CompiledSoundEvent", "clockwork"})
    private static final class WrappedSoundEntry
    extends SoundEntry {
        @NotNull
        private final List<ConfiguredSoundEvent> wrappedEvents;
        @NotNull
        private final List<CompiledSoundEvent> compiledEvents;

        public WrappedSoundEntry(@NotNull ResourceLocation id, @NotNull String subtitle, @NotNull List<ConfiguredSoundEvent> wrappedEvents, @NotNull SoundSource category, int attenuationDistance) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)subtitle, (String)"subtitle");
            Intrinsics.checkNotNullParameter(wrappedEvents, (String)"wrappedEvents");
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            super(id, subtitle, category, attenuationDistance);
            this.wrappedEvents = wrappedEvents;
            this.compiledEvents = new ArrayList();
        }

        @Override
        public void register() {
            int n = this.wrappedEvents.size();
            for (int i = 0; i < n; ++i) {
                ConfiguredSoundEvent configuredSoundEvent = this.wrappedEvents.get(i);
                float volume = configuredSoundEvent.component2();
                float pitch = configuredSoundEvent.component3();
                ResourceLocation location = this.getIdOf(i);
                SoundEvent event = SoundEvent.m_262824_((ResourceLocation)location);
                Intrinsics.checkNotNull((Object)event);
                this.compiledEvents.add(new CompiledSoundEvent(event, volume, pitch));
            }
            Iterator<CompiledSoundEvent> iterator = this.compiledEvents.iterator();
            while (iterator.hasNext()) {
                SoundEvent event1 = iterator.next().component1();
                sounds.register(event1.m_11660_().m_135815_(), () -> WrappedSoundEntry.register$lambda$0(event1));
            }
        }

        @Override
        @Nullable
        public SoundEvent getMainEvent() {
            return this.compiledEvents.get(0).getEvent();
        }

        @NotNull
        protected final ResourceLocation getIdOf(int i) {
            return new ResourceLocation(this.getId().m_135827_(), (String)(i == 0 ? this.getId().m_135815_() : this.getId().m_135815_() + "_compounded_" + i));
        }

        @Override
        public void write(@Nullable JsonObject json) {
            int n = this.wrappedEvents.size();
            for (int i = 0; i < n; ++i) {
                Supplier<SoundEvent> event1 = this.wrappedEvents.get(i).component1();
                JsonObject entry = new JsonObject();
                JsonArray list = new JsonArray();
                JsonObject s = new JsonObject();
                s.addProperty("name", event1.get().m_11660_().toString());
                s.addProperty("type", "event");
                if (this.getAttenuationDistance() != 0) {
                    s.addProperty("attenuation_distance", (Number)this.getAttenuationDistance());
                }
                list.add((JsonElement)s);
                entry.add("sounds", (JsonElement)list);
                if (i == 0 && this.hasSubtitle()) {
                    entry.addProperty("subtitle", this.getSubtitleKey());
                }
                JsonObject jsonObject = json;
                Intrinsics.checkNotNull((Object)jsonObject);
                jsonObject.add(this.getIdOf(i).m_135815_(), (JsonElement)entry);
            }
        }

        @Override
        public void play(@Nullable Level world, @Nullable Player entity, double x, double y, double z, float volume, float pitch) {
            for (CompiledSoundEvent compiledSoundEvent : this.compiledEvents) {
                SoundEvent event1 = compiledSoundEvent.component1();
                float volume1 = compiledSoundEvent.component2();
                float pitch1 = compiledSoundEvent.component3();
                Level level = world;
                Intrinsics.checkNotNull((Object)level);
                level.m_6263_(entity, x, y, z, event1, this.getCategory(), volume1 * volume, pitch1 * pitch);
            }
        }

        @Override
        public void playAt(@Nullable Level world, double x, double y, double z, float volume, float pitch, boolean fade) {
            for (CompiledSoundEvent compiledSoundEvent : this.compiledEvents) {
                SoundEvent event1 = compiledSoundEvent.component1();
                float volume1 = compiledSoundEvent.component2();
                float pitch1 = compiledSoundEvent.component3();
                Level level = world;
                Intrinsics.checkNotNull((Object)level);
                level.m_7785_(x, y, z, event1, this.getCategory(), volume1 * volume, pitch1 * pitch, fade);
            }
        }

        private static final SoundEvent register$lambda$0(SoundEvent $event1) {
            Intrinsics.checkNotNullParameter((Object)$event1, (String)"$event1");
            return $event1;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J.\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0018\u001a\u0004\b\u0019\u0010\u0004R\u0017\u0010\u000b\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001a\u001a\u0004\b\u001b\u0010\u0007R\u0017\u0010\n\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u001a\u001a\u0004\b\u001c\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/valkyrienskies/clockwork/ClockworkSounds$WrappedSoundEntry$CompiledSoundEvent;", "", "Lnet/minecraft/sounds/SoundEvent;", "component1", "()Lnet/minecraft/sounds/SoundEvent;", "", "component2", "()F", "component3", "event", "volume", "pitch", "copy", "(Lnet/minecraft/sounds/SoundEvent;FF)Lorg/valkyrienskies/clockwork/ClockworkSounds$WrappedSoundEntry$CompiledSoundEvent;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/sounds/SoundEvent;", "getEvent", "F", "getPitch", "getVolume", "<init>", "(Lnet/minecraft/sounds/SoundEvent;FF)V", "clockwork"})
        private static final class CompiledSoundEvent {
            @NotNull
            private final SoundEvent event;
            private final float volume;
            private final float pitch;

            public CompiledSoundEvent(@NotNull SoundEvent event, float volume, float pitch) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.event = event;
                this.volume = volume;
                this.pitch = pitch;
            }

            @NotNull
            public final SoundEvent getEvent() {
                return this.event;
            }

            public final float getVolume() {
                return this.volume;
            }

            public final float getPitch() {
                return this.pitch;
            }

            @NotNull
            public final SoundEvent component1() {
                return this.event;
            }

            public final float component2() {
                return this.volume;
            }

            public final float component3() {
                return this.pitch;
            }

            @NotNull
            public final CompiledSoundEvent copy(@NotNull SoundEvent event, float volume, float pitch) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return new CompiledSoundEvent(event, volume, pitch);
            }

            public static /* synthetic */ CompiledSoundEvent copy$default(CompiledSoundEvent compiledSoundEvent, SoundEvent soundEvent, float f, float f2, int n, Object object) {
                if ((n & 1) != 0) {
                    soundEvent = compiledSoundEvent.event;
                }
                if ((n & 2) != 0) {
                    f = compiledSoundEvent.volume;
                }
                if ((n & 4) != 0) {
                    f2 = compiledSoundEvent.pitch;
                }
                return compiledSoundEvent.copy(soundEvent, f, f2);
            }

            @NotNull
            public String toString() {
                return "CompiledSoundEvent(event=" + this.event + ", volume=" + this.volume + ", pitch=" + this.pitch + ")";
            }

            public int hashCode() {
                int result = this.event.hashCode();
                result = result * 31 + Float.hashCode(this.volume);
                result = result * 31 + Float.hashCode(this.pitch);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CompiledSoundEvent)) {
                    return false;
                }
                CompiledSoundEvent compiledSoundEvent = (CompiledSoundEvent)other;
                if (!Intrinsics.areEqual((Object)this.event, (Object)compiledSoundEvent.event)) {
                    return false;
                }
                if (Float.compare(this.volume, compiledSoundEvent.volume) != 0) {
                    return false;
                }
                return Float.compare(this.pitch, compiledSoundEvent.pitch) == 0;
            }
        }
    }
}

