/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.phys.gyro;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.contraptions.phys.gyro.GyroBlockEntity;
import org.valkyrienskies.clockwork.util.render.RenderUtil;
import org.valkyrienskies.clockwork.util.render.TransformData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\u0010!\u001a\u0004\u0018\u00010 \u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ9\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013JA\u0010\u0018\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019JC\u0010\u001c\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006$"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroBlockEntityRenderer;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntityRenderer;", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroBlockEntity;", "te", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lcom/simibubi/create/foundation/render/SuperByteBuffer;", "getRotatedModel", "(Lorg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroBlockEntity;Lnet/minecraft/world/level/block/state/BlockState;)Lcom/simibubi/create/foundation/render/SuperByteBuffer;", "be", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "", "light", "blockState", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "renderCore", "(Lorg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroBlockEntity;Lcom/mojang/blaze3d/vertex/PoseStack;ILnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/client/renderer/MultiBufferSource;)V", "", "angle", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "vb", "renderGyro", "(Lorg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroBlockEntity;Lcom/mojang/blaze3d/vertex/PoseStack;ILnet/minecraft/world/level/block/state/BlockState;FLcom/mojang/blaze3d/vertex/VertexConsumer;)V", "partialTicks", "overlay", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "crystalAngle", "F", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "clockwork"})
public final class GyroBlockEntityRenderer
extends KineticBlockEntityRenderer<GyroBlockEntity> {
    private float crystalAngle;

    public GyroBlockEntityRenderer(@Nullable BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(@NotNull GyroBlockEntity be, float partialTicks, @Nullable PoseStack ms, @Nullable MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)be), (String)"be");
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        BlockState blockState = be.m_58900_();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        BlockState blockState2 = blockState;
        float speed = be.getVisualSpeed().getValue(partialTicks) * (float)3 / 10.0f;
        float angle = be.getAngle() + speed * partialTicks;
        MultiBufferSource multiBufferSource = buffer;
        Intrinsics.checkNotNull((Object)multiBufferSource);
        VertexConsumer vb = multiBufferSource.m_6299_(RenderType.m_110451_());
        Intrinsics.checkNotNull((Object)vb);
        this.renderGyro(be, ms, light, blockState2, angle, vb);
        this.renderCore(be, ms, light, blockState2, buffer);
        SuperByteBuffer indicator = CachedBufferer.partial((PartialModel)ClockworkPartials.INSTANCE.getGYRO_BASE(), (BlockState)blockState2);
        indicator.light(light).color(255, 255, 255, 255).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        KineticBlockEntity kineticBlockEntity = be;
        BlockState blockState3 = be.m_58900_();
        Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"getBlockState(...)");
        KineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)kineticBlockEntity, (SuperByteBuffer)this.getRotatedModel(be, blockState3), (PoseStack)ms, (VertexConsumer)buffer.m_6299_(RenderType.m_110451_()), (int)light);
    }

    private final void renderCore(GyroBlockEntity be, PoseStack ms, int light, BlockState blockState, MultiBufferSource buffer) {
        float interpolatedAngle = be.getInterpolatedCoreAngle(AnimationTickHolder.getPartialTicks() - 1.0f);
        TransformData innerData = new TransformData(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(interpolatedAngle, interpolatedAngle, 0.0f));
        TransformData data = new TransformData(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f));
        TransformData outerData = new TransformData(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f));
        PoseStack poseStack = ms;
        Intrinsics.checkNotNull((Object)poseStack);
        RenderUtil.INSTANCE.renderCubeMatrix(poseStack, buffer, blockState, innerData, data, outerData, 1.5f, light);
    }

    private final void renderGyro(GyroBlockEntity be, PoseStack ms, int light, BlockState blockState, float angle, VertexConsumer vb) {
        SuperByteBuffer wheel = CachedBufferer.block((BlockState)blockState);
        KineticBlockEntityRenderer.kineticRotationTransform((SuperByteBuffer)wheel, (KineticBlockEntity)be, (Direction.Axis)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be), (float)AngleHelper.rad((double)angle), (int)light);
        wheel.translate(0.0, 1.0, 0.0);
        wheel.renderInto(ms, vb);
    }

    @NotNull
    protected SuperByteBuffer getRotatedModel(@NotNull GyroBlockEntity te, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)te), (String)"te");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        SuperByteBuffer superByteBuffer = CachedBufferer.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)state, (Direction)Direction.DOWN);
        Intrinsics.checkNotNullExpressionValue((Object)superByteBuffer, (String)"partialFacing(...)");
        return superByteBuffer;
    }
}

