/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.phys.gyro;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.content.contraptions.phys.gyro.GyroStabilizerKt;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ServerTickListener;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 ;2\u00020\u00012\u00020\u0002:\u0001;B\u0007\u00a2\u0006\u0004\b:\u0010\u000eJ\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eR$\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016R*\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00188\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010\u0012R\"\u0010!\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\u0016\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\"\u0010&\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010\u0016\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R$\u0010*\u001a\u0004\u0018\u00010)8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\"\u0010\t\u001a\u00020\b8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u0012\u001a\u0004\b0\u0010\u0014\"\u0004\b1\u00102R\"\u00104\u001a\u0002038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109\u00a8\u0006<"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroShipControl;", "Lorg/valkyrienskies/core/api/ships/ShipForcesInducer;", "Lorg/valkyrienskies/core/api/ships/ServerTickListener;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "", "applyForces", "(Lorg/valkyrienskies/core/api/ships/PhysShip;)V", "", "speed", "", "calculateStrength", "(F)D", "deleteIfEmpty", "()V", "onServerTick", "<set-?>", "consumed", "F", "getConsumed", "()F", "extraForceAngular", "D", "extraForceLinear", "", "v", "gyros", "I", "getGyros", "()I", "setGyros", "(I)V", "physConsumption", "powerAngular", "getPowerAngular", "()D", "setPowerAngular", "(D)V", "powerLinear", "getPowerLinear", "setPowerLinear", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "getShip$clockwork", "()Lorg/valkyrienskies/core/api/ships/ServerShip;", "setShip$clockwork", "(Lorg/valkyrienskies/core/api/ships/ServerShip;)V", "getSpeed$clockwork", "setSpeed$clockwork", "(F)V", "Lorg/joml/Vector3dc;", "targetVector", "Lorg/joml/Vector3dc;", "getTargetVector", "()Lorg/joml/Vector3dc;", "setTargetVector", "(Lorg/joml/Vector3dc;)V", "<init>", "Companion", "clockwork"})
@SourceDebugExtension(value={"SMAP\nGyroShipControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GyroShipControl.kt\norg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroShipControl\n+ 2 ServerShip.kt\norg/valkyrienskies/core/api/ships/ServerShipKt\n*L\n1#1,87:1\n39#2:88\n*S KotlinDebug\n*F\n+ 1 GyroShipControl.kt\norg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroShipControl\n*L\n54#1:88\n*E\n"})
public final class GyroShipControl
implements ShipForcesInducer,
ServerTickListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Vector3dc targetVector = (Vector3dc)new Vector3d(0.0, 1.0, 0.0);
    private float physConsumption;
    private double extraForceLinear;
    private double extraForceAngular;
    @JsonIgnore
    @Nullable
    private ServerShip ship;
    private float speed;
    private double powerLinear;
    private double powerAngular;
    private int gyros;
    private float consumed;

    @NotNull
    public final Vector3dc getTargetVector() {
        return this.targetVector;
    }

    public final void setTargetVector(@NotNull Vector3dc vector3dc) {
        Intrinsics.checkNotNullParameter((Object)vector3dc, (String)"<set-?>");
        this.targetVector = vector3dc;
    }

    @Nullable
    public final ServerShip getShip$clockwork() {
        return this.ship;
    }

    public final void setShip$clockwork(@Nullable ServerShip serverShip) {
        this.ship = serverShip;
    }

    public final float getSpeed$clockwork() {
        return this.speed;
    }

    public final void setSpeed$clockwork(float f) {
        this.speed = f;
    }

    public void applyForces(@NotNull PhysShip physShip) {
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        if (this.gyros < 1) {
            return;
        }
        PhysShipImpl cfr_ignored_0 = (PhysShipImpl)physShip;
        Vector3dc omega = ((PhysShipImpl)physShip).getPoseVel().getOmega();
        if (this.ship == null) {
            return;
        }
        double strength = this.calculateStrength(this.speed);
        GyroStabilizerKt.gyroStabilizer((PhysShipImpl)physShip, omega, (PhysShipImpl)physShip, strength, this.targetVector);
    }

    private final double calculateStrength(float speed) {
        double y = 128.0 / (1.0 + Math.exp((double)6 - (double)speed * 0.05));
        return RangesKt.coerceIn((double)y, (double)0.0, (double)100.0);
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteIfEmpty() {
        block1: {
            if (this.gyros > 0) break block1;
            ServerShip serverShip = this.ship;
            if (serverShip != null) {
                void $this$saveAttachment$iv;
                ServerShip serverShip2 = serverShip;
                Object value$iv = null;
                boolean $i$f$saveAttachment = false;
                $this$saveAttachment$iv.saveAttachment(GyroShipControl.class, value$iv);
            }
        }
    }

    public void onServerTick() {
        this.extraForceLinear = this.powerLinear;
        this.powerLinear = 0.0;
        this.extraForceAngular = this.powerAngular;
        this.powerAngular = 0.0;
        this.consumed = this.physConsumption * 0.1f;
        this.physConsumption = 0.0f;
    }

    public final double getPowerLinear() {
        return this.powerLinear;
    }

    public final void setPowerLinear(double d) {
        this.powerLinear = d;
    }

    public final double getPowerAngular() {
        return this.powerAngular;
    }

    public final void setPowerAngular(double d) {
        this.powerAngular = d;
    }

    public final int getGyros() {
        return this.gyros;
    }

    public final void setGyros(int v) {
        this.gyros = v;
        this.deleteIfEmpty();
    }

    public final float getConsumed() {
        return this.consumed;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroShipControl$Companion;", "", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "Lorg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroShipControl;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/ServerShip;)Lorg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroShipControl;", "<init>", "()V", "clockwork"})
    @SourceDebugExtension(value={"SMAP\nGyroShipControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GyroShipControl.kt\norg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroShipControl$Companion\n+ 2 ServerShip.kt\norg/valkyrienskies/core/api/ships/ServerShipKt\n*L\n1#1,87:1\n42#2:88\n39#2:89\n*S KotlinDebug\n*F\n+ 1 GyroShipControl.kt\norg/valkyrienskies/clockwork/content/contraptions/phys/gyro/GyroShipControl$Companion\n*L\n80#1:88\n82#1:89\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GyroShipControl getOrCreate(@NotNull ServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            ServerShip $this$getAttachment$iv = ship;
            boolean $i$f$getAttachment = false;
            GyroShipControl gyroShipControl = (GyroShipControl)$this$getAttachment$iv.getAttachment(GyroShipControl.class);
            if (gyroShipControl == null) {
                GyroShipControl gyroShipControl2;
                GyroShipControl it = gyroShipControl2 = new GyroShipControl();
                boolean bl = false;
                ServerShip $this$saveAttachment$iv = ship;
                boolean $i$f$saveAttachment = false;
                $this$saveAttachment$iv.saveAttachment(GyroShipControl.class, (Object)it);
                gyroShipControl = gyroShipControl2;
            }
            return gyroShipControl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

