/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.tool;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkConfig;
import org.valkyrienskies.clockwork.ClockworkItems;
import org.valkyrienskies.clockwork.ClockworkPackets;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.CreativeGravitronItem;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.GravitronDialPacket;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.GravitronForceInducer;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.GravitronForceInducerData;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.GravitronGrabPacket;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.GravitronItem;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.GravitronState;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.tool.GravitronToolBase;
import org.valkyrienskies.clockwork.util.ClockworkUtils;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/tool/GrabTool;", "Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/tool/GravitronToolBase;", "", "delta", "", "handleMouseWheel", "(D)Z", "handleRightClick", "()Z", "<init>", "()V", "Companion", "clockwork"})
public final class GrabTool
extends GravitronToolBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean handleRightClick() {
        this.updateTargetPos();
        if (this.getClickedPos() != null && this.getClickedLocation() != null) {
            BlockPos blockPos = this.getClickedPos();
            Intrinsics.checkNotNull((Object)blockPos);
            Vec3 vec3 = this.getClickedLocation();
            Intrinsics.checkNotNull((Object)vec3);
            ClockworkPackets.Companion.sendToServer(new GravitronGrabPacket(blockPos, vec3, GravitronToolBase.GRAB));
        }
        return true;
    }

    @Override
    public boolean handleMouseWheel(double delta) {
        return false;
    }

    @JvmStatic
    public static final void tick(@NotNull Player player) {
        Companion.tick(player);
    }

    @JvmStatic
    public static final boolean tryGrabShip(@NotNull ServerLevel level, @NotNull Player player, @NotNull BlockPos clickedPos, @NotNull Vec3 clickLocation, boolean isCreative) {
        return Companion.tryGrabShip(level, player, clickedPos, clickLocation, isCreative);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b-\u0010.J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J'\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J7\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ'\u0010#\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b#\u0010$J1\u0010'\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0004\b'\u0010(J/\u0010+\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020!2\u0006\u0010*\u001a\u00020)H\u0002\u00a2\u0006\u0004\b+\u0010,\u00a8\u0006/"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/tool/GrabTool$Companion;", "", "Lnet/minecraft/world/entity/player/Player;", "player", "", "dropShip", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "Lorg/joml/Vector3dc;", "grabPosInShip", "", "grabShip", "(Lnet/minecraft/world/entity/player/Player;Lorg/valkyrienskies/core/api/ships/ServerShip;Lorg/joml/Vector3dc;)V", "", "pitch", "yaw", "Lorg/joml/Quaterniond;", "playerRotToQuaternion", "(DD)Lorg/joml/Quaterniond;", "tick", "(Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lnet/minecraft/core/BlockPos;", "clickedPos", "Lnet/minecraft/world/phys/Vec3;", "clickLocation", "isCreative", "tryGrabShip", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/Vec3;Z)Z", "Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/GravitronState;", "s", "Lnet/minecraft/world/entity/Entity;", "entity", "updateShip", "(Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/GravitronState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;)V", "Lorg/joml/Vector2d;", "customRotation", "updateShipCommon", "(Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/GravitronState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;Lorg/joml/Vector2d;)V", "Lnet/minecraft/core/Direction;", "dir", "updateShipDirection", "(Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/GravitronState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/core/Direction;)V", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        private final Quaterniond playerRotToQuaternion(double pitch, double yaw) {
            Quaterniond quaterniond = new Quaterniond().rotateY(Math.toRadians(-yaw)).rotateX(Math.toRadians(pitch));
            Intrinsics.checkNotNullExpressionValue((Object)quaterniond, (String)"rotateX(...)");
            return quaterniond;
        }

        public final boolean dropShip(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (GravitronState.Companion.getState(player).getShipID() != null && player.m_9236_() instanceof ServerLevel) {
                Level level = player.m_9236_();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level;
                QueryableShipData queryableShipData = VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).getLoadedShips();
                Long l = GravitronState.Companion.getState(player).getShipID();
                Intrinsics.checkNotNull((Object)l);
                LoadedServerShip ship = (LoadedServerShip)queryableShipData.getById(l.longValue());
                if (ship != null) {
                    GravitronForceInducer gravitronForceInducer = GravitronForceInducer.Companion.getOrCreate(ship);
                    gravitronForceInducer.setData(null);
                    GravitronState.Companion.getState(player).setShipID(null);
                    return true;
                }
            }
            return false;
        }

        private final void updateShipCommon(GravitronState s, ServerLevel level, Entity entity, Vector2d customRotation) {
            if (s.getShipID() != null) {
                QueryableShipData queryableShipData = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips();
                Long l = s.getShipID();
                Intrinsics.checkNotNull((Object)l);
                LoadedServerShip ship = (LoadedServerShip)queryableShipData.getById(l.longValue());
                if (ship != null && s.getPlayerGrabbedRotation() != null && s.getShipGrabbedDistance() != null && s.getShipGrabbedPos() != null && s.getHeldBlockPos() != null) {
                    Vector2d vector2d = customRotation;
                    if (vector2d == null) {
                        vector2d = new Vector2d((double)entity.m_146909_(), (double)entity.m_146908_());
                    }
                    Vector2d playerCurrentRotation = vector2d;
                    Vector2dc vector2dc = s.getPlayerGrabbedRotation();
                    Intrinsics.checkNotNull((Object)vector2dc);
                    double d = vector2dc.x();
                    Vector2dc vector2dc2 = s.getPlayerGrabbedRotation();
                    Intrinsics.checkNotNull((Object)vector2dc2);
                    Quaterniond origPlayerRot = this.playerRotToQuaternion(d, vector2dc2.y()).normalize();
                    Quaterniond newPlayerRot = this.playerRotToQuaternion(playerCurrentRotation.x(), playerCurrentRotation.y()).normalize();
                    Quaterniond deltaPlayerRot = newPlayerRot.mul((Quaterniondc)origPlayerRot.conjugate(new Quaterniond()), new Quaterniond());
                    Quaterniond rotation = deltaPlayerRot.mul(s.getShipGrabbedRot(), new Quaterniond()).normalize();
                    Vec3 vec3 = entity.m_20154_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getLookAngle(...)");
                    Vector3d vector3d = VectorConversionsMCKt.toJOML((Vec3)vec3).normalize();
                    Double d2 = s.getShipGrabbedDistance();
                    Intrinsics.checkNotNull((Object)d2);
                    Vector3d lookDif = vector3d.mul(d2.doubleValue());
                    Vec3 vec32 = entity.m_146892_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getEyePosition(...)");
                    s.setHeldBlockPos((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)vec32).add((Vector3dc)lookDif));
                    Vector3d location = new Vector3d(s.getShipGrabbedPos());
                    Vector3d position = new Vector3d(s.getHeldBlockPos());
                    GravitronForceInducer gravitronForceInducer = GravitronForceInducer.Companion.getOrCreate(ship);
                    Vector3dc vector3dc = (Vector3dc)position;
                    Intrinsics.checkNotNull((Object)rotation);
                    GravitronForceInducerData newData = new GravitronForceInducerData(vector3dc, (Quaterniondc)rotation, (Vector3dc)location);
                    gravitronForceInducer.setData(newData);
                }
            }
        }

        private final void updateShip(GravitronState s, ServerLevel level, Entity entity) {
            this.updateShipCommon(s, level, entity, null);
        }

        private final void updateShipDirection(GravitronState s, ServerLevel level, Entity entity, Direction dir) {
            Vector2d lockedCurrentRotation = new Vector2d(0.0, (double)(dir.m_122416_() * 90));
            this.updateShipCommon(s, level, entity, lockedCurrentRotation);
        }

        @JvmStatic
        public final void tick(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (player.m_9236_() instanceof ServerLevel) {
                GravitronState s = GravitronState.Companion.getState(player);
                ItemStack graviton = player.m_21205_();
                Level level = player.m_9236_();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level;
                boolean bl = graviton.m_150930_(((GravitronItem)((Object)ClockworkItems.GRAVITRON.get())).m_5456_());
                boolean bl2 = graviton.m_150930_(((CreativeGravitronItem)((Object)ClockworkItems.CREATIVE_GRAVITRON.get())).m_5456_());
                if (s.getShipID() != null && (bl || bl2)) {
                    this.updateShip(s, serverLevel, (Entity)player);
                }
                if (graviton.m_41782_()) {
                    CompoundTag compoundTag = graviton.m_41783_();
                    Intrinsics.checkNotNull((Object)compoundTag);
                    if (compoundTag.m_128441_("GrabbedPosInShip") && !player.m_36335_().m_41519_(graviton.m_41720_())) {
                        CompoundTag tag;
                        CompoundTag compoundTag2 = tag = graviton.m_41783_();
                        Intrinsics.checkNotNull((Object)compoundTag2);
                        ListTag listTag = compoundTag2.m_128437_("GrabbedPosInShip", 6);
                        Intrinsics.checkNotNullExpressionValue((Object)listTag, (String)"getList(...)");
                        Vec3 clickLocation = ClockworkUtils.readVec3(listTag);
                        long id = tag.m_128454_("ShipId");
                        LoadedServerShip ship = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).getLoadedShips().getById(id);
                        if (ship != null) {
                            Vector3d transformedPos = ship.getWorldToShip().transformPosition((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)clickLocation), new Vector3d());
                            ServerShip serverShip = (ServerShip)ship;
                            Intrinsics.checkNotNull((Object)transformedPos);
                            this.grabShip(player, serverShip, (Vector3dc)transformedPos);
                            graviton.m_41749_("ShipId");
                            graviton.m_41749_("GrabbedPosInShip");
                        }
                    }
                }
            }
        }

        @JvmStatic
        public final boolean tryGrabShip(@NotNull ServerLevel level, @NotNull Player player, @NotNull BlockPos clickedPos, @NotNull Vec3 clickLocation, boolean isCreative) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)clickedPos, (String)"clickedPos");
            Intrinsics.checkNotNullParameter((Object)clickLocation, (String)"clickLocation");
            if (this.dropShip(player)) {
                return true;
            }
            ServerShip ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)level, (BlockPos)clickedPos);
            Vector3dc grabPosInShip = (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)clickLocation);
            Vector3d grabPosInWorld = new Vector3d(grabPosInShip);
            if (VSGameUtilsKt.isBlockInShipyard((Level)((Level)level), (BlockPos)clickedPos) && ship == null) {
                return false;
            }
            if (ship == null) {
                return false;
            }
            ship.getShipToWorld().transformPosition(grabPosInWorld);
            if (!isCreative) {
                double mass = ship.getInertiaData().getMass();
                if (player instanceof ServerPlayer) {
                    float q = (float)mass / ((float)ClockworkConfig.SERVER.getMaxGravitronMass() * 1000.0f);
                    float angle = GravitronState.Companion.mapValueToAngle(q * (float)100);
                    ClockworkPackets.Companion.sendTo(new GravitronDialPacket(angle), (ServerPlayer)player);
                }
                if (mass > (double)(ClockworkConfig.SERVER.getMaxGravitronMass() * 1000) * 0.9) {
                    player.m_5661_((Component)Component.m_237113_((String)("Ship's starting to get heavy! " + (int)mass + " / " + ClockworkConfig.SERVER.getMaxGravitronMass() * 1000)).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
                }
                if (mass > (double)(ClockworkConfig.SERVER.getMaxGravitronMass() * 1000)) {
                    player.m_5661_((Component)Component.m_237113_((String)("Ship too heavy! " + (int)mass + " / " + ClockworkConfig.SERVER.getMaxGravitronMass() * 1000)).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                    return false;
                }
            }
            this.grabShip(player, ship, grabPosInShip);
            return true;
        }

        private final void grabShip(Player player, ServerShip ship, Vector3dc grabPosInShip) {
            GravitronState s = GravitronState.Companion.getState(player);
            Vector3d heldPosInWorld = new Vector3d();
            ship.getTransform().getShipToWorld().transformPosition((Vector3dc)new Vector3d(grabPosInShip), heldPosInWorld);
            s.setShipID(ship.getId());
            s.setHeldBlockPos((Vector3dc)heldPosInWorld);
            s.setPlayerGrabbedRotation((Vector2dc)new Vector2d((double)player.m_146909_(), (double)player.m_146908_()));
            s.setShipGrabbedPos((Vector3dc)new Vector3d(grabPosInShip));
            s.setShipGrabbedRot(ship.getTransform().getShipToWorldRotation());
            Vec3 vec3 = player.m_146892_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
            s.setShipGrabbedDistance(VectorConversionsMCKt.toJOML((Vec3)vec3).distance((Vector3dc)heldPosInWorld));
            ship.setStatic(false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

