/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.kinetics.resistor;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.util.ClockworkConstants;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\f\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010)\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010&\u001a\u00020+\u00a2\u0006\u0004\b,\u0010-J%\u0010\b\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001e\u0010\fJ\u001f\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u001dR\"\u0010 \u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\"\u0010&\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010!\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%\u00a8\u0006."}, d2={"Lorg/valkyrienskies/clockwork/content/kinetics/resistor/RedstoneResistorBlockEntity;", "Lcom/simibubi/create/content/kinetics/transmission/SplitShaftBlockEntity;", "Lcom/simibubi/create/content/equipment/goggles/IHaveGoggleInformation;", "", "Lnet/minecraft/network/chat/Component;", "tooltip", "", "isPlayerSneaking", "addToGoggleTooltip", "(Ljava/util/List;Z)Z", "", "detachKinetics", "()V", "Lnet/minecraft/world/level/Level;", "worldIn", "Lnet/minecraft/core/BlockPos;", "pos", "", "getPower", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I", "Lnet/minecraft/core/Direction;", "face", "", "getRotationSpeedModifier", "(Lnet/minecraft/core/Direction;)F", "Lnet/minecraft/nbt/CompoundTag;", "compound", "clientPacket", "read", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "tick", "write", "lastChange", "I", "getLastChange", "()I", "setLastChange", "(I)V", "state", "getState", "setState", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public class RedstoneResistorBlockEntity
extends SplitShaftBlockEntity
implements IHaveGoggleInformation {
    private int state;
    private int lastChange;

    public RedstoneResistorBlockEntity(@Nullable BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int n) {
        this.state = n;
    }

    public final int getLastChange() {
        return this.lastChange;
    }

    public final void setLastChange(int n) {
        this.lastChange = n;
    }

    public void tick() {
        super.tick();
        this.lastChange = this.state;
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        this.state = this.getPower(level, blockPos);
        if (this.state != this.lastChange) {
            this.detachKinetics();
        }
    }

    public void detachKinetics() {
        RotationPropagator.handleRemoved((Level)this.f_58857_, (BlockPos)this.f_58858_, (KineticBlockEntity)((KineticBlockEntity)this));
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        level.m_186464_(this.f_58858_, this.m_58900_().m_60734_(), 0, TickPriority.EXTREMELY_HIGH);
    }

    public void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.m_128405_(ClockworkConstants.Nbt.INSTANCE.getREDSTONE_LEVEL(), this.state);
        compound.m_128405_(ClockworkConstants.Nbt.INSTANCE.getCHANGE_TIMER(), this.lastChange);
        super.write(compound, clientPacket);
    }

    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.state = compound.m_128451_(ClockworkConstants.Nbt.INSTANCE.getREDSTONE_LEVEL());
        this.lastChange = compound.m_128451_(ClockworkConstants.Nbt.INSTANCE.getCHANGE_TIMER());
        super.read(compound, clientPacket);
    }

    private final int getPower(Level worldIn, BlockPos pos) {
        int power = 0;
        Intrinsics.checkNotNullExpressionValue((Object)Iterate.directions, (String)"directions");
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.m_277185_(pos.m_121945_(direction), direction), power);
        }
        Intrinsics.checkNotNullExpressionValue((Object)Iterate.directions, (String)"directions");
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.m_277185_(pos.m_121945_(direction), Direction.UP), power);
        }
        return power;
    }

    public float getRotationSpeedModifier(@NotNull Direction face) {
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        if (this.hasSource() && face != this.getSourceFacing()) {
            float i = (float)Math.abs(this.state - 15) / 15.0f;
            return i;
        }
        return 1.0f;
    }

    public boolean addToGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Object[] objectArray = new Object[]{this.state};
        MutableComponent mutableComponent = SplitShaftBlockEntity.componentSpacing.m_6879_().m_7220_((Component)Lang.translateDirect((String)"tooltip.analogStrength", (Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
        tooltip.add((Component)mutableComponent);
        return true;
    }
}

