/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.kinetics.sequenced_seat;

import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.InputKey;
import org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.SequencedSeatRuleList;
import org.valkyrienskies.clockwork.integration.cc.ComputerAttachmentHandler;
import org.valkyrienskies.clockwork.platform.PlatformUtils;
import org.valkyrienskies.clockwork.util.ClockworkConstants;
import org.valkyrienskies.clockwork.util.MinecraftUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\u0012\f\u00108\u001a\b\u0012\u0002\b\u0003\u0018\u000107\u0012\b\u0010:\u001a\u0004\u0018\u000109\u0012\b\u0010<\u001a\u0004\u0018\u00010;\u00a2\u0006\u0004\b=\u0010>J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\t\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0006J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001b\u0010\u001c\u001a\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u001c\u0010\u001dJ-\u0010\"\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\b\u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010$\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b$\u0010\u0019R$\u0010\u001f\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001f\u0010&\u001a\u0004\b'\u0010(R\u0017\u0010*\u001a\u00020)8\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u0017\u0010/\u001a\u00020.8\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b\u0005\u00101R$\u0010\u001e\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001e\u0010&\u001a\u0004\b2\u0010(R\u0014\u00103\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00100R$\u0010 \u001a\u00020\b2\u0006\u0010%\u001a\u00020\b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b \u0010&\u001a\u0004\b4\u0010(R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u00105R$\u0010!\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b!\u0010&\u001a\u0004\b6\u0010(\u00a8\u0006?"}, d2={"Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatBlockEntity;", "Lcom/simibubi/create/content/kinetics/transmission/SplitShaftBlockEntity;", "Lnet/minecraft/core/Direction;", "direction", "", "getDegreesAwayFromBase", "(Lnet/minecraft/core/Direction;)F", "face", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList;", "getList", "(Lnet/minecraft/core/Direction;)Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList;", "Lnet/minecraft/world/level/block/Rotation;", "rotation", "(Lnet/minecraft/world/level/block/Rotation;)Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList;", "getRotationSpeedModifier", "", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/InputKey;", "pressedKeys", "()Ljava/util/Set;", "Lnet/minecraft/nbt/CompoundTag;", "compound", "", "clientPacket", "", "read", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "tick", "()V", "updateInput", "(Ljava/util/Set;)V", "forwardRules", "backwardRules", "leftRules", "rightRules", "updateRules", "(Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList;Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList;Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList;Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList;)V", "write", "<set-?>", "Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList;", "getBackwardRules", "()Lorg/valkyrienskies/clockwork/content/kinetics/sequenced_seat/SequencedSeatRuleList;", "Lorg/valkyrienskies/clockwork/integration/cc/ComputerAttachmentHandler;", "computerHandler", "Lorg/valkyrienskies/clockwork/integration/cc/ComputerAttachmentHandler;", "getComputerHandler", "()Lorg/valkyrienskies/clockwork/integration/cc/ComputerAttachmentHandler;", "", "degreesAwayFromBase", "[F", "()[F", "getForwardRules", "lastModifier", "getLeftRules", "Ljava/util/Set;", "getRightRules", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "typeIn", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public final class SequencedSeatBlockEntity
extends SplitShaftBlockEntity {
    @NotNull
    private SequencedSeatRuleList forwardRules = SequencedSeatRuleList.Companion.defaultList(Rotation.NONE);
    @NotNull
    private SequencedSeatRuleList backwardRules = SequencedSeatRuleList.Companion.defaultList(Rotation.CLOCKWISE_180);
    @NotNull
    private SequencedSeatRuleList leftRules = SequencedSeatRuleList.Companion.defaultList(Rotation.COUNTERCLOCKWISE_90);
    @NotNull
    private SequencedSeatRuleList rightRules = SequencedSeatRuleList.Companion.defaultList(Rotation.CLOCKWISE_90);
    @NotNull
    private Set<? extends InputKey> pressedKeys = SetsKt.emptySet();
    @NotNull
    private final float[] degreesAwayFromBase = new float[4];
    @NotNull
    private final float[] lastModifier = new float[4];
    @NotNull
    private final ComputerAttachmentHandler computerHandler = new ComputerAttachmentHandler();

    public SequencedSeatBlockEntity(@Nullable BlockEntityType<?> typeIn, @Nullable BlockPos pos, @Nullable BlockState state) {
        super(typeIn, pos, state);
    }

    @NotNull
    public final SequencedSeatRuleList getForwardRules() {
        return this.forwardRules;
    }

    @NotNull
    public final SequencedSeatRuleList getBackwardRules() {
        return this.backwardRules;
    }

    @NotNull
    public final SequencedSeatRuleList getLeftRules() {
        return this.leftRules;
    }

    @NotNull
    public final SequencedSeatRuleList getRightRules() {
        return this.rightRules;
    }

    @NotNull
    public final float[] getDegreesAwayFromBase() {
        return this.degreesAwayFromBase;
    }

    @NotNull
    public final ComputerAttachmentHandler getComputerHandler() {
        return this.computerHandler;
    }

    public void tick() {
        super.tick();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            Direction dir = (Direction)EntriesMappings.entries$0.get(i + 2);
            float modifier = this.getRotationSpeedModifier(dir);
            float[] fArray = this.degreesAwayFromBase;
            int n = i;
            fArray[n] = fArray[n] + SplitShaftBlockEntity.convertToAngular((float)(modifier * this.speed));
            if (!(modifier == this.lastModifier[i])) {
                this.detachKinetics();
                this.attachKinetics();
            }
            this.lastModifier[i] = modifier;
            if (this.degreesAwayFromBase[i] > 360.0f) {
                fArray = this.degreesAwayFromBase;
                n = i;
                fArray[n] = fArray[n] - 360.0f;
            }
            if (!(this.degreesAwayFromBase[i] < 0.0f)) continue;
            fArray = this.degreesAwayFromBase;
            n = i;
            fArray[n] = fArray[n] + 360.0f;
        }
    }

    public float getRotationSpeedModifier(@NotNull Direction face) {
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        if (this.isVirtual() || !this.hasSource()) {
            return 1.0f;
        }
        if (this.getSourceFacing() != Direction.DOWN) {
            return 0.0f;
        }
        return face == this.getSourceFacing() ? 1.0f : this.getList(face).currentModifier(this, face);
    }

    @NotNull
    public final SequencedSeatRuleList getList(@Nullable Direction face) {
        Direction forward = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        Intrinsics.checkNotNull((Object)forward);
        Direction direction = face;
        Intrinsics.checkNotNull((Object)direction);
        Rotation rotation = MinecraftUtil.INSTANCE.between(forward, direction);
        return this.getList(rotation);
    }

    @NotNull
    public final SequencedSeatRuleList getList(@NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        return switch (WhenMappings.$EnumSwitchMapping$0[rotation.ordinal()]) {
            case 1 -> this.forwardRules;
            case 2 -> this.rightRules;
            case 3 -> this.backwardRules;
            case 4 -> this.leftRules;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final Set<InputKey> pressedKeys() {
        return this.pressedKeys;
    }

    protected void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.write(compound, clientPacket);
        compound.m_128365_(ClockworkConstants.Nbt.INSTANCE.getFORWARD_RULES(), (Tag)this.forwardRules.serializeNBT());
        compound.m_128365_(ClockworkConstants.Nbt.INSTANCE.getBACKWARD_RULES(), (Tag)this.backwardRules.serializeNBT());
        compound.m_128365_(ClockworkConstants.Nbt.INSTANCE.getLEFT_RULES(), (Tag)this.leftRules.serializeNBT());
        compound.m_128365_(ClockworkConstants.Nbt.INSTANCE.getRIGHT_RULES(), (Tag)this.rightRules.serializeNBT());
    }

    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.read(compound, clientPacket);
        ListTag listTag = compound.m_128437_(ClockworkConstants.Nbt.INSTANCE.getFORWARD_RULES(), 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag, (String)"getList(...)");
        this.forwardRules.deserializeNBT(listTag);
        ListTag listTag2 = compound.m_128437_(ClockworkConstants.Nbt.INSTANCE.getBACKWARD_RULES(), 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag2, (String)"getList(...)");
        this.backwardRules.deserializeNBT(listTag2);
        ListTag listTag3 = compound.m_128437_(ClockworkConstants.Nbt.INSTANCE.getLEFT_RULES(), 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag3, (String)"getList(...)");
        this.leftRules.deserializeNBT(listTag3);
        ListTag listTag4 = compound.m_128437_(ClockworkConstants.Nbt.INSTANCE.getRIGHT_RULES(), 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag4, (String)"getList(...)");
        this.rightRules.deserializeNBT(listTag4);
    }

    public final void updateRules(@NotNull SequencedSeatRuleList forwardRules, @NotNull SequencedSeatRuleList backwardRules, @NotNull SequencedSeatRuleList leftRules, @NotNull SequencedSeatRuleList rightRules) {
        Intrinsics.checkNotNullParameter((Object)forwardRules, (String)"forwardRules");
        Intrinsics.checkNotNullParameter((Object)backwardRules, (String)"backwardRules");
        Intrinsics.checkNotNullParameter((Object)leftRules, (String)"leftRules");
        Intrinsics.checkNotNullParameter((Object)rightRules, (String)"rightRules");
        this.forwardRules = forwardRules;
        this.backwardRules = backwardRules;
        this.leftRules = leftRules;
        this.rightRules = rightRules;
        this.sendData();
        this.m_6596_();
        this.detachKinetics();
        this.attachKinetics();
    }

    public final void updateInput(@NotNull Set<? extends InputKey> pressedKeys) {
        Intrinsics.checkNotNullParameter(pressedKeys, (String)"pressedKeys");
        if (Intrinsics.areEqual(this.pressedKeys, pressedKeys)) {
            return;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_ && PlatformUtils.isModLoaded("computercraft")) {
            List event = new ArrayList();
            this.pressedKeys.forEach(arg_0 -> SequencedSeatBlockEntity.updateInput$lambda$0(event, arg_0));
            this.computerHandler.sendEvent("command_seat_keys", event);
        }
        this.pressedKeys = pressedKeys;
    }

    public final float getDegreesAwayFromBase(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return this.degreesAwayFromBase[direction.ordinal() - 2];
    }

    private static final void updateInput$lambda$0(List $event, InputKey key) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        $event.add(key.name());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Rotation.values().length];
            try {
                nArray[Rotation.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rotation.CLOCKWISE_90.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rotation.CLOCKWISE_180.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rotation.COUNTERCLOCKWISE_90.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

