/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.mixin.content.fan;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.clockwork.content.forces.EncasedFanController;
import org.valkyrienskies.clockwork.content.propulsion.singleton.fan.EncasedFanCreateData;
import org.valkyrienskies.clockwork.content.propulsion.singleton.fan.EncasedFanUpdateData;
import org.valkyrienskies.clockwork.util.ClockworkConstants;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={EncasedFanBlockEntity.class})
public abstract class MixinEncasedFanTileEntity
extends KineticBlockEntity {
    private Integer vs_clockwork$fanID = null;
    private boolean vs_clockwork$alreadyAdded = false;

    public MixinEncasedFanTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Unique
    private void vs_clockwork$handleController() {
        LoadedServerShip ship = null;
        if (!this.f_58857_.f_46443_ && VSGameUtilsKt.getShipObjectManagingPos((Level)this.f_58857_, (Vec3i)this.m_58899_()) != null) {
            ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)((ServerLevel)this.f_58857_), (Vec3i)this.m_58899_());
        }
        if (ship != null) {
            if (!this.vs_clockwork$alreadyAdded && this.vs_clockwork$fanID == null) {
                Vector3d pos = VectorConversionsMCKt.toJOMLD((Vec3i)this.f_58858_);
                Vector3d axis = VectorConversionsMCKt.toJOMLD((Vec3i)((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_());
                EncasedFanCreateData data = new EncasedFanCreateData((Vector3dc)pos, (Vector3dc)axis, this.speed);
                this.vs_clockwork$fanID = EncasedFanController.Companion.getOrCreate((ServerShip)ship).addEncasedFan(data);
                this.vs_clockwork$alreadyAdded = true;
            }
            if (this.vs_clockwork$alreadyAdded && this.vs_clockwork$fanID != null) {
                EncasedFanUpdateData data = new EncasedFanUpdateData(this.speed);
                EncasedFanController.Companion.getOrCreate((ServerShip)ship).updateEncasedFan(this.vs_clockwork$fanID, data);
            }
            if (this.m_58901_() && this.vs_clockwork$fanID != null) {
                EncasedFanController.Companion.getOrCreate((ServerShip)ship).removeEncasedFan(this.vs_clockwork$fanID);
                this.vs_clockwork$fanID = null;
                this.vs_clockwork$alreadyAdded = false;
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, remap=false)
    private void vs_clockwork$injectTick(CallbackInfo ci) {
        this.vs_clockwork$handleController();
    }

    @Inject(method={"write"}, at={@At(value="TAIL")}, remap=false)
    private void vs_clockwork$injectWrite(CompoundTag compound, boolean clientPacket, CallbackInfo ci) {
        compound.m_128379_(ClockworkConstants.Nbt.ALREADY_ADDED, this.vs_clockwork$alreadyAdded);
        if (this.vs_clockwork$fanID != null) {
            compound.m_128405_(ClockworkConstants.Nbt.FAN_ID, this.vs_clockwork$fanID.intValue());
        }
    }

    @Inject(method={"read"}, at={@At(value="TAIL")}, remap=false)
    private void vs_clockwork$injectRead(CompoundTag compound, boolean clientPacket, CallbackInfo ci) {
        this.vs_clockwork$alreadyAdded = compound.m_128471_(ClockworkConstants.Nbt.ALREADY_ADDED);
        if (compound.m_128441_(ClockworkConstants.Nbt.FAN_ID)) {
            this.vs_clockwork$fanID = compound.m_128451_(ClockworkConstants.Nbt.FAN_ID);
        }
    }
}

