/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util;

import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.foundation.utility.UniqueLinkedList;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ;\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lorg/valkyrienskies/clockwork/util/GlueAssembler;", "", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lorg/valkyrienskies/core/util/datastructures/DenseBlockPosSet;", "collectGlued", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lorg/valkyrienskies/core/util/datastructures/DenseBlockPosSet;", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "", "isAllowed", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/world/level/LevelAccessor;", "Ljava/util/Queue;", "frontier", "visited", "", "Lnet/minecraft/world/entity/Entity;", "cache", "", "visitBlock", "(Lnet/minecraft/world/level/LevelAccessor;Ljava/util/Queue;Lorg/valkyrienskies/core/util/datastructures/DenseBlockPosSet;Ljava/util/Set;)V", "<init>", "()V", "clockwork"})
public final class GlueAssembler {
    @NotNull
    public static final GlueAssembler INSTANCE = new GlueAssembler();

    private GlueAssembler() {
    }

    @Nullable
    public final DenseBlockPosSet collectGlued(@NotNull Level level, @NotNull BlockPos pos) throws AssemblyException {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Set toRemove = new HashSet();
        DenseBlockPosSet result = new DenseBlockPosSet();
        Queue frontier = (Queue)new UniqueLinkedList();
        if (level.m_8055_(pos).m_60795_()) {
            return null;
        }
        frontier.add(pos);
        for (int limit = 100000; 0 < limit; --limit) {
            if (frontier.isEmpty()) {
                if (result.isEmpty()) {
                    throw new AssemblyException((Component)Component.m_237113_((String)"No blocks found!"));
                }
                return result;
            }
            this.visitBlock((LevelAccessor)level, frontier, result, toRemove);
        }
        toRemove.forEach(GlueAssembler::collectGlued$lambda$0);
        AssemblyException assemblyException = AssemblyException.structureTooLarge();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)assemblyException), (String)"structureTooLarge(...)");
        throw (Throwable)assemblyException;
    }

    private final void visitBlock(LevelAccessor level, Queue<BlockPos> frontier, DenseBlockPosSet visited, Set<? extends Entity> cache) throws AssemblyException {
        BlockPos blockPos = frontier.poll();
        Intrinsics.checkNotNull((Object)blockPos);
        BlockPos pos = blockPos;
        visited.add(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        for (Direction direction : Direction.values()) {
            BlockPos newPos;
            Intrinsics.checkNotNull(cache, (String)"null cannot be cast to non-null type kotlin.collections.Set<com.simibubi.create.content.contraptions.glue.SuperGlueEntity>");
            if (!SuperGlueEntity.isGlued((LevelAccessor)level, (BlockPos)pos, (Direction)direction, cache) || visited.contains((newPos = pos.m_121945_(direction)).m_123341_(), newPos.m_123342_(), newPos.m_123343_())) continue;
            BlockState state = level.m_8055_(newPos);
            Intrinsics.checkNotNull((Object)state);
            if (!this.isAllowed(state) || state.m_60795_()) continue;
            frontier.add(newPos);
        }
    }

    private final boolean isAllowed(BlockState state) {
        return true;
    }

    private static final void collectGlued$lambda$0(Entity obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.m_146870_();
    }
}

