/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.AlarmBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.PlayAlarmSound;
import net.geforcemods.securitycraft.util.AlarmSoundHandler;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class AlarmBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    public static final int MAXIMUM_ALARM_SOUND_LENGTH = 3600;
    private Option.IntOption range;
    private Option.DisabledOption disabled;
    private Option.BooleanOption resetCooldown;
    private int cooldown;
    private boolean isPowered;
    private SoundEvent sound;
    private float pitch;
    private boolean soundPlaying;
    private int soundLength;

    public AlarmBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.ALARM_BLOCK_ENTITY.get(), pos, state);
        this.range = new Option.IntOption("range", 17, 0, (Integer)ConfigHandler.getOrDefault(ConfigHandler.SERVER.maxAlarmRange), 1);
        this.disabled = new Option.DisabledOption(false);
        this.resetCooldown = new Option.BooleanOption("resetCooldown", true);
        this.cooldown = 0;
        this.isPowered = false;
        this.sound = SCSounds.ALARM.event;
        this.pitch = 1.0f;
        this.soundPlaying = false;
        this.soundLength = 2;
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.f_46443_ && this.soundPlaying && (this.isDisabled() || !((Boolean)this.m_58900_().m_61143_((Property)AlarmBlock.LIT)).booleanValue())) {
            this.stopPlayingSound();
        }
        if (!this.isDisabled() && --this.cooldown <= 0) {
            if (!level.f_46443_ && this.isPowered) {
                double rangeSqr = Math.pow(((Integer)this.range.get()).intValue(), 2.0);
                Holder soundEventHolder = BuiltInRegistries.f_256894_.m_263177_((Object)(this.isModuleEnabled(ModuleType.SMART) ? this.sound : SCSounds.ALARM.event));
                for (ServerPlayer player : ((ServerLevel)level).m_8795_(p -> p.m_20183_().m_123331_((Vec3i)pos) <= rangeSqr)) {
                    float volume = (float)(1.0 - player.m_20183_().m_123331_((Vec3i)pos) / rangeSqr);
                    SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PlayAlarmSound(this.f_58858_, (Holder<SoundEvent>)soundEventHolder, volume, this.getPitch(), player.m_20193_().f_46441_.m_188505_()));
                }
            }
            this.setCooldown(this.soundLength * 20);
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("cooldown", this.cooldown);
        tag.m_128379_("isPowered", this.isPowered);
        tag.m_128359_("sound", this.sound.m_11660_().toString());
        tag.m_128350_("pitch", this.pitch);
        tag.m_128405_("delay", this.soundLength);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.cooldown = tag.m_128451_("cooldown");
        this.isPowered = tag.m_128471_("isPowered");
        if (tag.m_128425_("sound", 8)) {
            this.setSound(new ResourceLocation(tag.m_128461_("sound")));
        } else {
            this.setSound(SCSounds.ALARM.location);
        }
        this.pitch = tag.m_128441_("pitch") ? tag.m_128457_("pitch") : 1.0f;
        this.soundLength = tag.m_128451_("delay");
    }

    public void setSound(ResourceLocation soundEvent) {
        this.sound = SoundEvent.m_262824_((ResourceLocation)soundEvent);
        this.m_6596_();
    }

    public SoundEvent getSound() {
        return this.isModuleEnabled(ModuleType.SMART) ? this.sound : SCSounds.ALARM.event;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getSoundLength() {
        return this.soundLength;
    }

    public void setSoundLength(int soundLength) {
        this.soundLength = Mth.m_14045_((int)soundLength, (int)1, (int)3600);
        this.setCooldown(0);
        if (this.f_58857_.f_46443_) {
            this.stopPlayingSound();
        }
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
        this.m_6596_();
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean isPowered) {
        this.isPowered = isPowered;
        if (isPowered && ((Boolean)this.resetCooldown.get()).booleanValue()) {
            this.setCooldown(0);
        }
        this.m_6596_();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range, this.disabled, this.resetCooldown};
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_.f_46443_ && this.soundPlaying) {
            this.stopPlayingSound();
        }
    }

    public void playSound(Level level, double x, double y, double z, Holder<SoundEvent> sound, float volume, float pitch, long seed) {
        AlarmSoundHandler.playSound(this, level, x, y, z, sound, SoundSource.BLOCKS, volume, pitch, seed);
        this.soundPlaying = true;
    }

    public void stopPlayingSound() {
        AlarmSoundHandler.stopCurrentSound(this);
        this.soundPlaying = false;
    }
}

