/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.MotionActivatedLightBlock;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class MotionActivatedLightBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    private static final int TICKS_BETWEEN_ATTACKS = 5;
    private Option.IntOption searchRadiusOption = new Option.IntOption("searchRadius", 5, 5, 20, 1);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private int cooldown = 5;

    public MotionActivatedLightBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.MOTION_LIGHT_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        boolean shouldBeOn;
        if (this.isDisabled() || this.cooldown-- > 0) {
            return;
        }
        List entities = level.m_6443_(LivingEntity.class, new AABB(pos).m_82400_((double)((Integer)this.searchRadiusOption.get()).intValue()), e -> !this.respectInvisibility.isConsideredInvisible((LivingEntity)e) && e.m_142065_() && !(e instanceof Sentry) && !(e instanceof ArmorStand));
        boolean bl = shouldBeOn = !entities.isEmpty();
        if ((Boolean)state.m_61143_((Property)MotionActivatedLightBlock.LIT) != shouldBeOn) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)MotionActivatedLightBlock.LIT, (Comparable)Boolean.valueOf(shouldBeOn)));
        }
        this.cooldown = 5;
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.disabled && ((Boolean)((Option.BooleanOption)option).get()).booleanValue() && ((Boolean)this.m_58900_().m_61143_((Property)MotionActivatedLightBlock.LIT)).booleanValue()) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)MotionActivatedLightBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
        super.onOptionChanged(option);
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[0];
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadiusOption, this.disabled, this.respectInvisibility};
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }
}

