/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class BlockEntityTracker<BE extends BlockEntity> {
    public static final BlockEntityTracker<SonicSecuritySystemBlockEntity> SONIC_SECURITY_SYSTEM = new BlockEntityTracker<SonicSecuritySystemBlockEntity>(be -> 30);
    public static final BlockEntityTracker<BlockChangeDetectorBlockEntity> BLOCK_CHANGE_DETECTOR = new BlockEntityTracker<BlockChangeDetectorBlockEntity>(be -> be.getRange());
    public static final BlockEntityTracker<RiftStabilizerBlockEntity> RIFT_STABILIZER = new BlockEntityTracker<RiftStabilizerBlockEntity>(RiftStabilizerBlockEntity::getRange);
    public static final BlockEntityTracker<SecureRedstoneInterfaceBlockEntity> SECURE_REDSTONE_INTERFACE = new BlockEntityTracker<SecureRedstoneInterfaceBlockEntity>(SecureRedstoneInterfaceBlockEntity::getSenderRange);
    private final Map<ResourceKey<Level>, Collection<BlockPos>> trackedBlockEntities = new ConcurrentHashMap<ResourceKey<Level>, Collection<BlockPos>>();
    private final Function<BE, Integer> range;

    private BlockEntityTracker(Function<BE, Integer> range) {
        this.range = range;
    }

    public void track(BE be) {
        this.getTrackedBlockEntities(be.m_58904_()).add(be.m_58899_().m_7949_());
    }

    public void stopTracking(BE be) {
        this.getTrackedBlockEntities(be.m_58904_()).remove(be.m_58899_());
    }

    public List<BE> getBlockEntitiesInRange(Level level, BlockPos pos) {
        return this.getBlockEntitiesInRange(level, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
    }

    public List<BE> getBlockEntitiesInRange(Level level, Vec3 pos) {
        return this.iterate(level, (list, bePos) -> {
            BlockEntity be = level.m_7702_(bePos);
            if (be != null && this.canReach(be, pos)) {
                list.add(be);
            }
        });
    }

    public List<BE> getBlockEntitiesAround(Level level, BlockPos pos, int range) {
        return this.iterate(level, (list, bePos) -> {
            if (this.isInRange(pos, range, new Vec3((double)bePos.m_123341_(), (double)bePos.m_123342_(), (double)bePos.m_123343_()))) {
                list.add(level.m_7702_(bePos));
            }
        });
    }

    private List<BE> iterate(Level level, BiConsumer<List<BE>, BlockPos> listAdder) {
        Collection<BlockPos> blockEntities = this.getTrackedBlockEntities(level);
        ArrayList returnValue = new ArrayList();
        Iterator<BlockPos> it = blockEntities.iterator();
        while (it.hasNext()) {
            BlockPos bePos = it.next();
            if (bePos != null) {
                try {
                    listAdder.accept(returnValue, bePos);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            it.remove();
        }
        return returnValue;
    }

    public Collection<BlockPos> getTrackedBlockEntities(Level level) {
        Collection<BlockPos> blockEntities = this.trackedBlockEntities.get(level.m_46472_());
        if (blockEntities == null) {
            blockEntities = ConcurrentHashMap.newKeySet();
            this.trackedBlockEntities.put((ResourceKey<Level>)level.m_46472_(), blockEntities);
        }
        return blockEntities;
    }

    public boolean canReach(BE be, Vec3 pos) {
        return this.isInRange(be.m_58899_(), this.range.apply(be), pos);
    }

    public boolean isInRange(BlockPos around, int range, Vec3 pos) {
        AABB testRange = new AABB(around).m_82400_((double)range);
        return testRange.f_82288_ <= pos.f_82479_ && testRange.f_82289_ <= pos.f_82480_ && testRange.f_82290_ <= pos.f_82481_ && testRange.f_82291_ >= pos.f_82479_ && testRange.f_82292_ >= pos.f_82480_ && testRange.f_82293_ >= pos.f_82481_;
    }
}

