/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadDoorBlockEntity;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;

public class SetPasscode {
    private BlockPos pos;
    private int entityId;
    private String passcode;

    public SetPasscode() {
    }

    public SetPasscode(BlockPos pos, String code) {
        this.pos = pos;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(code);
    }

    public SetPasscode(int entityId, String code) {
        this.entityId = entityId;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(code);
    }

    public SetPasscode(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.pos = buf.m_130135_();
        } else {
            this.entityId = buf.m_130242_();
        }
        this.passcode = buf.m_130136_(0x1FFFFFFF);
    }

    public void encode(FriendlyByteBuf buf) {
        boolean hasPos = this.pos != null;
        buf.writeBoolean(hasPos);
        if (hasPos) {
            buf.m_130064_(this.pos);
        } else {
            buf.m_130130_(this.entityId);
        }
        buf.m_130070_(this.passcode);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        IOwnable ownable;
        ServerPlayer player = ctx.get().getSender();
        Level level = player.m_9236_();
        IPasscodeProtected passcodeProtected = this.getPasscodeProtected(level);
        if (passcodeProtected != null && (!(passcodeProtected instanceof IOwnable) || (ownable = (IOwnable)((Object)passcodeProtected)).isOwnedBy((Entity)player))) {
            passcodeProtected.hashAndSetPasscode(this.passcode, arg_0 -> this.lambda$handle$0(passcodeProtected, level, (Player)player, arg_0));
            if (this.pos != null) {
                if (passcodeProtected instanceof KeypadChestBlockEntity) {
                    KeypadChestBlockEntity chestBe = (KeypadChestBlockEntity)passcodeProtected;
                    SetPasscode.checkAndUpdateAdjacentChest(chestBe, level, this.pos, this.passcode, passcodeProtected.getSalt());
                } else if (passcodeProtected instanceof KeypadDoorBlockEntity) {
                    KeypadDoorBlockEntity doorBe = (KeypadDoorBlockEntity)passcodeProtected;
                    SetPasscode.checkAndUpdateAdjacentDoor(doorBe, level, this.passcode, passcodeProtected.getSalt());
                }
            }
        }
    }

    private static void checkAndUpdateAdjacentChest(KeypadChestBlockEntity be, Level level, BlockPos pos, String codeToSet, byte[] salt) {
        BlockPos offsetPos;
        BlockEntity otherBe;
        if (be.m_58900_().m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE && (otherBe = level.m_7702_(offsetPos = pos.m_121945_(ChestBlock.m_51584_((BlockState)be.m_58900_())))) instanceof KeypadChestBlockEntity) {
            KeypadChestBlockEntity chestBe = (KeypadChestBlockEntity)otherBe;
            if (be.getOwner().owns(chestBe)) {
                chestBe.hashAndSetPasscode(codeToSet, salt);
                level.m_7260_(offsetPos, otherBe.m_58900_(), otherBe.m_58900_(), 2);
            }
        }
    }

    private static void checkAndUpdateAdjacentDoor(KeypadDoorBlockEntity be, Level level, String codeToSet, byte[] salt) {
        be.runForOtherHalf(otherBe -> {
            if (be.getOwner().owns((IOwnable)otherBe)) {
                otherBe.hashAndSetPasscode(codeToSet, salt);
                level.m_7260_(otherBe.m_58899_(), otherBe.m_58900_(), otherBe.m_58900_(), 2);
            }
        });
    }

    private IPasscodeProtected getPasscodeProtected(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (blockEntity instanceof IPasscodeProtected) {
                IPasscodeProtected pp = (IPasscodeProtected)blockEntity;
                return pp;
            }
        } else {
            Entity entity = level.m_6815_(this.entityId);
            if (entity instanceof IPasscodeProtected) {
                IPasscodeProtected pp = (IPasscodeProtected)entity;
                return pp;
            }
        }
        return null;
    }

    private /* synthetic */ void lambda$handle$0(IPasscodeProtected passcodeProtected, Level level, Player player, byte[] b) {
        passcodeProtected.openPasscodeGUI(level, this.pos, player);
    }
}

