/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.core.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OptionCategories {
    private static String defaultCategory = "default";
    private static final Map<String, String> categoryByName = new HashMap<String, String>();
    private static final List<String> categoryOrder = new ArrayList<String>();

    public static void load() {
        try (InputStream stream = OptionCategories.class.getResourceAsStream("/modernfix/option_categories.json");){
            if (stream == null) {
                throw new FileNotFoundException("option_categories.json");
            }
            JsonObject object = new JsonParser().parse(new JsonReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8))).getAsJsonObject();
            defaultCategory = object.get("default").getAsString();
            JsonObject obj = object.get("categories").getAsJsonObject();
            for (Map.Entry category : obj.entrySet()) {
                categoryOrder.add((String)category.getKey());
                for (JsonElement e : ((JsonElement)category.getValue()).getAsJsonArray()) {
                    categoryByName.put(e.getAsString(), (String)category.getKey());
                }
            }
        }
        catch (IOException | RuntimeException e) {
            e.printStackTrace();
            categoryOrder.clear();
            categoryByName.clear();
            categoryOrder.add("default");
        }
    }

    public static List<String> getCategoriesInOrder() {
        return Collections.unmodifiableList(categoryOrder);
    }

    public static String getCategoryForOption(String optionName) {
        String category = categoryByName.get(optionName);
        if (category == null) {
            int lastDotIdx = optionName.lastIndexOf(46);
            category = lastDotIdx > 0 ? OptionCategories.getCategoryForOption(optionName.substring(0, lastDotIdx - 1)) : defaultCategory;
        }
        return category;
    }
}

