/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.packet;

import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import org.embeddedt.modernfix.ModernFix;

public class EntityIDSyncPacket {
    private Map<Class<? extends Entity>, List<Pair<String, Integer>>> map;

    public EntityIDSyncPacket(Map<Class<? extends Entity>, List<Pair<String, Integer>>> map) {
        this.map = map;
    }

    public Map<Class<? extends Entity>, List<Pair<String, Integer>>> getFieldInfo() {
        return this.map;
    }

    public EntityIDSyncPacket() {
        this.map = new HashMap<Class<? extends Entity>, List<Pair<String, Integer>>>();
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130130_(this.map.keySet().size());
        for (Map.Entry<Class<? extends Entity>, List<Pair<String, Integer>>> entry : this.map.entrySet()) {
            buf.m_130070_(entry.getKey().getName());
            buf.m_130130_(entry.getValue().size());
            for (Pair<String, Integer> field : entry.getValue()) {
                buf.m_130070_((String)field.getFirst());
                buf.m_130130_(((Integer)field.getSecond()).intValue());
            }
        }
    }

    public static EntityIDSyncPacket deserialize(FriendlyByteBuf buf) {
        EntityIDSyncPacket self = new EntityIDSyncPacket();
        int numEntityClasses = buf.m_130242_();
        for (int i = 0; i < numEntityClasses; ++i) {
            String clzName = buf.m_130277_();
            try {
                Class<?> clz;
                try {
                    clz = Class.forName(clzName);
                }
                catch (ClassNotFoundException e) {
                    ModernFix.LOGGER.warn("Entity class not found: {}", (Object)clzName);
                    break;
                }
                if (!Entity.class.isAssignableFrom(clz)) {
                    ModernFix.LOGGER.error("Not an entity: " + clzName);
                    break;
                }
                int numFields = buf.m_130242_();
                for (int j = 0; j < numFields; ++j) {
                    String fieldName = buf.m_130277_();
                    int id = buf.m_130242_();
                    Field f = clz.getDeclaredField(fieldName);
                    if (!Modifier.isStatic(f.getModifiers())) continue;
                    f.setAccessible(true);
                    if (!EntityDataAccessor.class.isAssignableFrom(f.get(null).getClass())) {
                        ModernFix.LOGGER.error("Not a data accessor field: " + String.valueOf(clz) + "." + fieldName);
                        continue;
                    }
                    self.map.computeIfAbsent(clz, k -> new ArrayList()).add(Pair.of((Object)fieldName, (Object)id));
                }
                continue;
            }
            catch (ReflectiveOperationException e) {
                ModernFix.LOGGER.error("Error deserializing packet", (Throwable)e);
            }
        }
        return self;
    }
}

