/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.violetmoon.zeta.block.ext.IZetaBlockExtensions;
import org.violetmoon.zeta.module.IDisableable;
import org.violetmoon.zeta.registry.CreativeTabManager;

public interface IZetaBlock
extends IZetaBlockExtensions,
IDisableable<IZetaBlock> {
    default public Block getBlock() {
        return (Block)this;
    }

    default public Block setCreativeTab(ResourceKey<CreativeModeTab> tab) {
        Block b = this.getBlock();
        CreativeTabManager.addToCreativeTab(tab, (ItemLike)b);
        return b;
    }

    default public Block setCreativeTab(ResourceKey<CreativeModeTab> tab, ItemLike parent, boolean behindParent) {
        Block b = this.getBlock();
        CreativeTabManager.addToCreativeTabNextTo(tab, (ItemLike)b, parent, behindParent);
        return b;
    }

    @Override
    default public int getFlammabilityZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_61148_().containsKey((Object)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return 0;
        }
        SoundType totallyMaterialTrustMeImADolphin = state.m_60827_();
        if (totallyMaterialTrustMeImADolphin == SoundType.f_56745_) {
            return 60;
        }
        if (totallyMaterialTrustMeImADolphin == SoundType.f_56736_ || state.m_278200_()) {
            return 20;
        }
        ResourceLocation loc = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_());
        if (loc != null && (loc.m_135815_().endsWith("_log") || loc.m_135815_().endsWith("_wood"))) {
            return 5;
        }
        return 0;
    }

    @Override
    default public int getFireSpreadSpeedZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_61148_().containsKey((Object)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return 0;
        }
        SoundType gaming = state.m_60827_();
        if (gaming == SoundType.f_56745_) {
            return 30;
        }
        if (gaming == SoundType.f_56736_ || state.m_278200_()) {
            return 5;
        }
        return 0;
    }
}

