/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.config.type;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.ConfigFlagManager;
import org.violetmoon.zeta.config.type.IBiomeConfig;
import org.violetmoon.zeta.config.type.IConfigType;
import org.violetmoon.zeta.module.ZetaModule;

public class BiomeTagConfig
implements IBiomeConfig,
IConfigType {
    private final Object mutex = new Object();
    @Config(name="Biome Tags")
    private List<String> biomeTagStrings;
    @Config
    private boolean isBlacklist;
    private List<TagKey<Biome>> tags;

    @SafeVarargs
    protected BiomeTagConfig(boolean isBlacklist, TagKey<Biome> ... tagsIn) {
        this.isBlacklist = isBlacklist;
        this.biomeTagStrings = new LinkedList<String>();
        for (TagKey<Biome> t : tagsIn) {
            this.biomeTagStrings.add(t.f_203868_().toString());
        }
    }

    private BiomeTagConfig(boolean isBlacklist, String ... types) {
        this.isBlacklist = isBlacklist;
        this.biomeTagStrings = new LinkedList<String>();
        this.biomeTagStrings.addAll(Arrays.asList(types));
    }

    protected static BiomeTagConfig fromStrings(boolean isBlacklist, String ... types) {
        return new BiomeTagConfig(isBlacklist, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canSpawn(Holder<Biome> biome) {
        if (biome == null) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.tags == null) {
                this.updateTypes();
            }
            for (TagKey<Biome> tag : this.tags) {
                if (!biome.m_203656_(tag)) continue;
                return !this.isBlacklist;
            }
            return this.isBlacklist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReload(ZetaModule module, ConfigFlagManager flagManager) {
        Object object = this.mutex;
        synchronized (object) {
            this.updateTypes();
        }
    }

    public void updateTypes() {
        this.tags = new LinkedList<TagKey<Biome>>();
        for (String s : this.biomeTagStrings) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(s));
            if (tag == null) continue;
            this.tags.add((TagKey<Biome>)tag);
        }
    }
}

