/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zetaimplforge.event;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.mod.ZetaMod;

public class ForgeEventsRemapper<Z, F extends Event> {
    private final Class<F> forgeEventRoot;
    private final Class<Z> zetaEventRoot;
    private final Map<Class<? extends Z>, Function<? extends F, ? extends Z>> forgeToZetaMap = new Object2ObjectOpenHashMap();
    private final Map<Class<? extends Z>, Function<? extends Z, ? extends F>> zetaToForgeMap = new Object2ObjectOpenHashMap();
    private final Map<Class<? extends Z>, Class<?>> generics = new Object2ObjectOpenHashMap();
    private final Map<Class<? extends Z>, Class<?>> zetaToForgeEventClassHack = new Object2ObjectOpenHashMap();
    private static final Map<Class<?>, VanillaGuiOverlay> GUI_OVERLAY_CACHE = new ConcurrentHashMap();
    private static final Pattern INNER_CLASS_PATTERN = Pattern.compile("\\$([^$]+)\\$");
    private static final Map<Class<?>, EventPriority> PRIORITY_CACHE = new ConcurrentHashMap();

    public ForgeEventsRemapper(Class<Z> zetaEventRoot, Class<F> forgeEventRoot) {
        this.forgeEventRoot = forgeEventRoot;
        this.zetaEventRoot = zetaEventRoot;
    }

    protected <Z2 extends Z> F remapEvent(@NotNull Z2 zetaEvent, Class<?> firedAs) {
        Function<? extends Z, ? extends F> zetaToForgeFunc = this.zetaToForgeMap.get(firedAs);
        if (zetaToForgeFunc == null) {
            return (F)((Event)zetaEvent);
        }
        return this.createForgeEvent(zetaEvent, zetaToForgeFunc);
    }

    @Nullable
    protected Consumer<? extends F> remapMethod(MethodHandle originalEventConsumer, Class<?> zetaEventBaseClass, Class<?> forgeEventClass) {
        Function<Object, Object> forgeToZetaFunc = this.forgeToZetaMap.get(zetaEventBaseClass);
        if (forgeToZetaFunc == null) {
            if (this.forgeEventRoot.isAssignableFrom(zetaEventBaseClass)) {
                forgeToZetaFunc = event -> {
                    try {
                        return event;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                };
            } else {
                return null;
            }
        }
        return this.createForgeConsumer(originalEventConsumer, forgeToZetaFunc, zetaEventBaseClass, forgeEventClass);
    }

    private <T extends Z> F createForgeEvent(@NotNull Z event, Function<T, ? extends F> function) {
        return (F)((Event)function.apply(event));
    }

    private <F2 extends F, Z2 extends Z> Consumer<F2> createForgeConsumer(MethodHandle zetaEventConsumer, Function<F2, Z2> forgeToZetaFunc, Class<?> zetaEventBaseClass, Class<?> forgeEventClass) {
        VanillaGuiOverlay overlay = ForgeEventsRemapper.guessGuiOverlayFromClassName(zetaEventBaseClass, forgeEventClass);
        if (overlay != null) {
            return event -> {
                try {
                    RenderGuiOverlayEvent rge = (RenderGuiOverlayEvent)event;
                    if (rge.getOverlay() != overlay.type()) {
                        return;
                    }
                    zetaEventConsumer.invoke(forgeToZetaFunc.apply(event));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }
        Phase phase = Phase.guessFromClassName(zetaEventBaseClass, forgeEventClass);
        if (phase != Phase.NONE) {
            return event -> {
                try {
                    TickEvent te = (TickEvent)event;
                    if (phase == Phase.START ^ te.phase == TickEvent.Phase.START) {
                        return;
                    }
                    zetaEventConsumer.invoke(forgeToZetaFunc.apply(event));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }
        return event -> {
            try {
                zetaEventConsumer.invoke(forgeToZetaFunc.apply(event));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Deprecated
    public <S extends Z, C extends Z> void registerWrapperWithGeneric(Class<C> baseZetaEventClass, Class<S> forgeZetaEventClass, Class<?> genericClass) {
        this.registerWrapper(baseZetaEventClass, forgeZetaEventClass);
        this.generics.put(baseZetaEventClass, genericClass);
    }

    @Deprecated
    public <ZF extends Z, ZB extends Z> void registerWrapper(Class<ZB> baseZetaEventClass, Class<ZF> forgeZetaEventClass) {
        this.registerWrapper(baseZetaEventClass, forgeZetaEventClass, null);
    }

    @Deprecated
    public <ZF extends Z, ZB extends Z> void registerWrapperWithGeneric(Class<ZB> baseZetaEventClass, Class<ZF> forgeZetaEventClass, Function<? extends F, ZF> constructor, Class<?> genericClass) {
        this.registerWrapper(baseZetaEventClass, forgeZetaEventClass, constructor);
        this.generics.put(baseZetaEventClass, genericClass);
    }

    public <ZF extends Z, ZB extends Z, F2 extends F> void registerWrapper(Class<ZB> baseZetaEventClass, Class<F2> forgeEventClass, Function<F2, ZF> constructor, Function<ZF, ? extends F> unwrapper) {
        this.zetaToForgeEventClassHack.put(baseZetaEventClass, forgeEventClass);
        this.forgeToZetaMap.put(baseZetaEventClass, constructor);
        this.zetaToForgeMap.put(baseZetaEventClass, unwrapper);
    }

    public <ZF extends Z, ZB extends Z, F2 extends F> void registerWrapperWithGenerics(Class<ZB> baseZetaEventClass, Class<F2> forgeEventClass, Function<F2, ZF> constructor, Function<ZF, ? extends F> unwrapper, Class<?> genericClass) {
        this.zetaToForgeEventClassHack.put(baseZetaEventClass, forgeEventClass);
        this.forgeToZetaMap.put(baseZetaEventClass, constructor);
        this.zetaToForgeMap.put(baseZetaEventClass, unwrapper);
        this.generics.put(baseZetaEventClass, genericClass);
    }

    @Deprecated
    public <ZF extends Z, ZB extends Z> void registerWrapper(Class<ZB> baseZetaEventClass, Class<ZF> forgeZetaEventClass, @Nullable Function<? extends F, ZF> constructor) {
        Function old2 = null;
        boolean isNoWrapper = false;
        if (constructor == null) {
            if (this.forgeEventRoot.isAssignableFrom(forgeZetaEventClass)) {
                this.zetaToForgeEventClassHack.put(baseZetaEventClass, forgeZetaEventClass);
                constructor = baseZetaEventClass.isAssignableFrom(forgeZetaEventClass) ? event -> {
                    try {
                        return event;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } : this.findWrappedZetaEvent(forgeZetaEventClass, baseZetaEventClass);
                isNoWrapper = true;
            }
            if (constructor == null) {
                constructor = this.findForgeWrapper(forgeZetaEventClass, baseZetaEventClass);
            }
        }
        if (constructor == null) {
            throw new RuntimeException("No Forge-Event-wrapping constructor found for Zeta event class " + forgeZetaEventClass);
        }
        Function<? extends F, ZF> old1 = this.forgeToZetaMap.put(baseZetaEventClass, constructor);
        Function zetaToForge = null;
        if (!isNoWrapper) {
            zetaToForge = this.findWrappedForgeEvent(forgeZetaEventClass, baseZetaEventClass);
        }
        if (zetaToForge == null) {
            zetaToForge = this.findZetaWrapper(forgeZetaEventClass);
        }
        if (zetaToForge != null) {
            old2 = this.zetaToForgeMap.put(baseZetaEventClass, zetaToForge);
        }
        if (old1 != null || old2 != null) {
            throw new RuntimeException("Event class " + baseZetaEventClass + " already registered");
        }
    }

    private <Z2 extends Z, F2 extends F> Function<F2, Z2> findForgeWrapper(Class<Z2> zetaEventClass, Class<? extends Z> baseZetaEventClass) {
        for (Constructor<?> constructor : zetaEventClass.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1 || !this.forgeEventRoot.isAssignableFrom(parameterTypes[0])) continue;
            this.zetaToForgeEventClassHack.put(baseZetaEventClass, parameterTypes[0]);
            return event -> {
                try {
                    return constructor.newInstance(event);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create new instance of event class " + zetaEventClass, e);
                }
            };
        }
        return null;
    }

    private <Z2 extends Z, F2 extends F> Function<Z2, F2> findZetaWrapper(Class<Z2> zetaEventClass) {
        for (Constructor<?> constructor : zetaEventClass.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1 || !this.zetaEventRoot.isAssignableFrom(parameterTypes[0])) continue;
            return event -> {
                try {
                    return (Event)constructor.newInstance(event);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create new instance of event class " + zetaEventClass, e);
                }
            };
        }
        if (this.forgeEventRoot.isAssignableFrom(zetaEventClass)) {
            return null;
        }
        throw new RuntimeException("No Zeta-Event-wrapping constructor found for Zeta event class " + zetaEventClass);
    }

    private <Z2 extends Z, F2 extends F> Function<Z2, F2> findWrappedForgeEvent(Class<Z2> zetaEventClass, Class<? extends Z> baseZetaEventClass) {
        Field eventField = ForgeEventsRemapper.findFieldInClassHierarchy(zetaEventClass, f -> this.forgeEventRoot.isAssignableFrom(f.getType()));
        if (eventField != null) {
            eventField.setAccessible(true);
            if (!this.zetaToForgeEventClassHack.containsKey(baseZetaEventClass)) {
                this.zetaToForgeEventClassHack.put(baseZetaEventClass, eventField.getType());
            }
            return instance -> {
                try {
                    return (Event)eventField.get(instance);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        if (this.forgeEventRoot.isAssignableFrom(zetaEventClass)) {
            if (!this.zetaToForgeEventClassHack.containsKey(baseZetaEventClass)) {
                this.zetaToForgeEventClassHack.put(baseZetaEventClass, zetaEventClass);
            }
            return null;
        }
        throw new RuntimeException("No e forge Event found for Zeta event class " + zetaEventClass);
    }

    private <Z2 extends Z, F2 extends F> Function<F2, Z2> findWrappedZetaEvent(Class<Z2> zetaEventClass, Class<? extends Z> baseZetaEventClass) {
        Field eventField = ForgeEventsRemapper.findFieldInClassHierarchy(zetaEventClass, f -> this.zetaEventRoot.isAssignableFrom(f.getType()));
        if (eventField != null) {
            eventField.setAccessible(true);
            return instance -> {
                try {
                    return eventField.get(instance);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        throw new RuntimeException("No e Zeta Event found for Zeta event class " + zetaEventClass);
    }

    public static Field findFieldInClassHierarchy(Class<?> clazz, Predicate<Field> predicate) {
        while (clazz != null) {
            for (Field f : clazz.getDeclaredFields()) {
                if (!predicate.test(f)) continue;
                return f;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    protected <F2 extends F> void registerListenerToForgeWithPriorityAndGenerics(IEventBus bus, Class<?> owningClazz, Consumer<F2> consumer, Class<?> zetaEventClass, Class forgeEventClass) {
        EventPriority priority = ForgeEventsRemapper.guessPriorityFromClassName(owningClazz);
        Class<?> gen = this.generics.get(zetaEventClass);
        if (forgeEventClass == null) {
            throw new RuntimeException("No event type found for " + zetaEventClass);
        }
        if (gen != null) {
            bus.addGenericListener(gen, priority, false, forgeEventClass, consumer);
        } else {
            bus.addListener(priority, false, forgeEventClass, consumer);
        }
    }

    public Object remapAndRegister(IEventBus forgeBus, Class<?> owningClazz, MethodHandle handle, Class<?> zetaEventClass) {
        Class<?> forgeEventClass = this.zetaToForgeEventClassHack.get(zetaEventClass);
        Consumer<F> consumer = this.remapMethod(handle, zetaEventClass, forgeEventClass);
        if (consumer == null) {
            if (this.isClientEvent(zetaEventClass)) {
                if (ZetaMod.ZETA.isProduction) {
                    ZetaMod.LOGGER.error("Client event {} was found in a non client only class!", zetaEventClass);
                    return new Object();
                }
                throw new RuntimeException("Client event " + zetaEventClass + " was found in a non client only class!");
            }
            throw new RuntimeException("Could not convert Zeta event class " + zetaEventClass + " to Forge event (in class " + owningClazz + "). You must register its subclass using registerSubclass.");
        }
        this.registerListenerToForgeWithPriorityAndGenerics(forgeBus, owningClazz, consumer, zetaEventClass, forgeEventClass);
        return consumer;
    }

    @Deprecated(forRemoval=true)
    private boolean isClientEvent(Class<?> zetaEventClass) {
        String path = zetaEventClass.getPackageName();
        return path.startsWith("org.violetmoon.zeta.client.event");
    }

    @Nullable
    private static VanillaGuiOverlay guessGuiOverlayFromClassName(Class<?> zetaEventClass, Class<?> forgeEventClass) {
        if (!RenderGuiOverlayEvent.class.isAssignableFrom(forgeEventClass)) {
            return null;
        }
        return GUI_OVERLAY_CACHE.computeIfAbsent(zetaEventClass, zec -> {
            Matcher match = INNER_CLASS_PATTERN.matcher(zetaEventClass.getName());
            if (!match.find()) {
                return null;
            }
            String simpleName = match.group(1);
            for (VanillaGuiOverlay overlay : VanillaGuiOverlay.values()) {
                if (!simpleName.equalsIgnoreCase(overlay.name().replace("_", ""))) continue;
                return overlay;
            }
            return null;
        });
    }

    private static EventPriority guessPriorityFromClassName(Class<?> zetaEventClass) {
        return PRIORITY_CACHE.computeIfAbsent(zetaEventClass, zec -> {
            String simpleName = zec.getSimpleName();
            for (EventPriority p : EventPriority.values()) {
                String name = WordUtils.capitalizeFully((String)p.name().toLowerCase());
                if (!simpleName.endsWith(name)) continue;
                return p;
            }
            return EventPriority.NORMAL;
        });
    }

    public ForgeEventsRemapper<Z, F> makeCopy() {
        ForgeEventsRemapper<Z, F> copy = new ForgeEventsRemapper<Z, F>(this.zetaEventRoot, this.forgeEventRoot);
        copy.forgeToZetaMap.putAll(this.forgeToZetaMap);
        copy.zetaToForgeMap.putAll(this.zetaToForgeMap);
        copy.generics.putAll(this.generics);
        copy.zetaToForgeEventClassHack.putAll(this.zetaToForgeEventClassHack);
        return copy;
    }

    private static enum Phase {
        NONE,
        START,
        END;


        private static Phase guessFromClassName(Class<?> zetaEventClass, Class<?> forgeClass) {
            if (!TickEvent.class.isAssignableFrom(forgeClass)) {
                return NONE;
            }
            String simpleName = zetaEventClass.getSimpleName();
            if (simpleName.equals("Start")) {
                return START;
            }
            if (simpleName.equals("End")) {
                return END;
            }
            return NONE;
        }
    }
}

