/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.SimpleInstaller;
import net.minecraftforge.installer.SwingUtil;
import net.minecraftforge.installer.actions.ActionCanceledException;
import net.minecraftforge.installer.actions.PostProcessors;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.json.Util;
import net.minecraftforge.installer.json.Version;

public abstract class Action {
    protected final InstallV1 profile;
    protected final ProgressCallback monitor;
    protected final PostProcessors processors;
    protected final Version version;
    private List<Artifact> grabbed = new ArrayList<Artifact>();

    protected Action(InstallV1 profile, ProgressCallback monitor, boolean isClient) {
        this.profile = profile;
        this.monitor = monitor;
        this.processors = new PostProcessors(profile, isClient, monitor);
        this.version = Util.loadVersion(profile);
    }

    protected void error(String message) {
        if (!SimpleInstaller.headless) {
            JOptionPane.showOptionDialog(null, message, "Error", -1, 0, null, new Object[]{"Ok", SwingUtil.createLogButton()}, "");
        }
        this.monitor.stage(message);
    }

    public abstract boolean run(File var1, File var2) throws ActionCanceledException;

    public abstract boolean isPathValid(File var1);

    public abstract String getFileError(File var1);

    public abstract String getSuccessMessage();

    protected List<Version.Library> getLibraries() {
        ArrayList<Version.Library> libraries = new ArrayList<Version.Library>();
        libraries.addAll(Arrays.asList(this.version.getLibraries()));
        libraries.addAll(Arrays.asList(this.processors.getLibraries()));
        return libraries;
    }

    protected boolean downloadLibraries(File librariesDir, List<File> additionalLibDirs) throws ActionCanceledException {
        this.monitor.start("Downloading libraries");
        this.monitor.message(String.format("Found %d additional library directories", additionalLibDirs.size()));
        List<Version.Library> libraries = this.getLibraries();
        StringBuilder output = new StringBuilder();
        double steps = libraries.size();
        int progress = 1;
        for (Version.Library lib : libraries) {
            Version.LibraryDownload download;
            this.checkCancel();
            this.monitor.progress((double)progress++ / steps);
            if (DownloadUtils.downloadLibrary(this.monitor, this.profile.getMirror(), lib, librariesDir, this.grabbed, additionalLibDirs) || (download = lib.getDownloads() == null ? null : lib.getDownloads().getArtifact()) == null || download.getUrl().isEmpty()) continue;
            output.append('\n').append(lib.getName());
        }
        String bad = output.toString();
        if (!bad.isEmpty()) {
            this.error("These libraries failed to download. Try again.\n" + bad);
            return false;
        }
        return true;
    }

    protected int downloadedCount() {
        return this.grabbed.size();
    }

    protected int getTaskCount() {
        return this.profile.getLibraries().length + this.processors.getTaskCount();
    }

    protected void checkCancel() throws ActionCanceledException {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            throw new ActionCanceledException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean downloadVanilla(File target, String side) {
        if (target.exists()) return true;
        File parent = target.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        String resource = "/cache/vanilla/" + side + ".jar";
        try (InputStream input = Action.class.getResourceAsStream(resource);){
            if (input != null) {
                this.monitor.message("  Extracting from " + resource);
                Files.copy(input, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.error("Failed to extract vanilla jar from " + resource);
            e.printStackTrace();
            return false;
        }
        Version vanilla = Util.getVanillaVersion(this.profile.getMinecraft());
        if (vanilla == null) {
            this.error("Failed to download version manifest, can not find " + side + " jar URL.");
            return false;
        }
        Version.Download dl = vanilla.getDownload(side);
        if (dl == null) {
            this.error("Failed to download minecraft " + side + " jar, info missing from manifest");
            return false;
        }
        if (DownloadUtils.download(this.monitor, this.profile.getMirror(), dl, target)) return true;
        target.delete();
        this.error("Downloading minecraft " + side + " failed, invalid checksum.\n" + ("client".equals(side) ? "Try again, or use the vanilla launcher to install the vanilla version." : "Try again, or manually place server jar to skip download."));
        return false;
    }
}

