/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork;

import com.simibubi.create.foundation.config.ConfigBase;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class TrackworkConfigs {
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    private static TServer server;
    private static TClient client;

    public static TClient client() {
        return client;
    }

    public static TServer server() {
        return server;
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll(builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void register(ModLoadingContext context) {
        server = TrackworkConfigs.register(TServer::new, ModConfig.Type.SERVER);
        client = TrackworkConfigs.register(TClient::new, ModConfig.Type.CLIENT);
        for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
            context.registerConfig(pair.getKey(), (IConfigSpec)pair.getValue().specification);
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != event.getConfig().getSpec()) continue;
            config.onLoad();
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != event.getConfig().getSpec()) continue;
            config.onReload();
        }
    }

    public static class TClient
    extends ConfigBase {
        public final ConfigBase.ConfigInt trackRenderDist = this.i(256, "trackRenderDist", new String[]{"Track render distance"});

        public String getName() {
            return "client";
        }
    }

    public static class TServer
    extends ConfigBase {
        public final ConfigBase.ConfigBool enableStress = this.b(false, "enableTrackStress", new String[]{"Enable track Kinetic Stress"});
        public final ConfigBase.ConfigFloat stressMult = this.f(0.02f, 0.0f, "stressMultiplier", new String[]{"Stress multiplier, units SU/(ton x RPM)"});
        public final ConfigBase.ConfigInt maxRPM = this.i(256, 1, "maxTrackRPM", new String[]{"Maximum Track RPM, 1 RPM ~ 0.104 m/s"});
        public final ConfigBase.ConfigBool enableTrackThrow = this.b(false, "enableTrackThrow", new String[]{"Enable entire tracks being thrown off by explosions"});
        public final ConfigBase.ConfigInt wheelPairDist = this.i(7, 5, 15, "wheelPairDistance", new String[]{"The max distance between wheels where steering, etc. will be paired"});

        public String getName() {
            return "server";
        }
    }
}

