/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityCarInventoryBase;
import de.maxhenkel.car.gui.ContainerCar;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class GuiCar
extends ScreenBase<ContainerCar> {
    private static final ResourceLocation CAR_GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_car.png");
    private static final int fontColor = 0x404040;
    private Inventory playerInv;
    private EntityCarInventoryBase car;

    public GuiCar(ContainerCar containerCar, Inventory playerInv, Component title) {
        super(CAR_GUI_TEXTURE, containerCar, playerInv, title);
        this.playerInv = playerInv;
        this.car = containerCar.getCar();
        this.f_97726_ = 176;
        this.f_97727_ = 248;
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280649_(this.f_96547_, this.car.m_5446_().m_7532_(), 7, 87, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.playerInv.m_5446_().m_7532_(), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.getFuelString().m_7532_(), 7, 9, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.getDamageString().m_7532_(), 7, 35, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.getBatteryString().m_7532_(), 95, 9, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.getTempString().m_7532_(), 95, 35, 0x404040, false);
    }

    public float getFuelPercent() {
        float fuelPerc = (float)this.car.getFuelAmount() / (float)this.car.getMaxFuel() * 100.0f;
        return MathUtils.round(fuelPerc, 2);
    }

    public int getBatteryPercent() {
        return (int)(this.car.getBatteryPercentage() * 100.0f);
    }

    public float getTemperatureCelsius() {
        return MathUtils.round(this.car.getTemperature(), 2);
    }

    public float getTemperatureFarenheit() {
        return MathUtils.round(this.car.getTemperature() * 1.8f + 32.0f, 2);
    }

    public float getTemperaturePercent() {
        float temp = this.car.getTemperature();
        if (temp > 100.0f) {
            temp = 100.0f;
        }
        if (temp < 0.0f) {
            temp = 0.0f;
        }
        return temp / 100.0f;
    }

    public float getDamagePercent() {
        float dmg = this.car.getDamage();
        dmg = Math.min(dmg, 100.0f);
        return MathUtils.round(dmg, 2);
    }

    public Component getFuelString() {
        return Component.m_237110_((String)"gui.car_fuel", (Object[])new Object[]{String.valueOf(this.getFuelPercent())});
    }

    public Component getDamageString() {
        return Component.m_237110_((String)"gui.car_damage", (Object[])new Object[]{String.valueOf(this.getDamagePercent())});
    }

    public Component getBatteryString() {
        return Component.m_237110_((String)"gui.car_battery", (Object[])new Object[]{String.valueOf(this.getBatteryPercent())});
    }

    public Component getTempString() {
        if (((Boolean)Main.CLIENT_CONFIG.tempInFarenheit.get()).booleanValue()) {
            return Component.m_237110_((String)"gui.car_temperature_farenheit", (Object[])new Object[]{String.valueOf(this.getTemperatureFarenheit())});
        }
        return Component.m_237110_((String)"gui.car_temperature_celsius", (Object[])new Object[]{String.valueOf(this.getTemperatureCelsius())});
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawFuel(guiGraphics, this.getFuelPercent());
        this.drawDamage(guiGraphics, 100.0f - this.getDamagePercent());
        this.drawBattery(guiGraphics, this.car.getBatteryPercentage());
        this.drawTemp(guiGraphics, this.getTemperaturePercent());
    }

    public void drawFuel(GuiGraphics guiGraphics, float percent) {
        percent = Math.min(100.0f, percent);
        int scaled = (int)((double)(72.0f * percent) / 100.0);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(CAR_GUI_TEXTURE, i + 8, j + 20, 176, 0, scaled, 10);
    }

    public void drawDamage(GuiGraphics guiGraphics, float percent) {
        percent = Math.min(100.0f, percent);
        int scaled = (int)((double)(72.0f * percent) / 100.0);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(CAR_GUI_TEXTURE, i + 8, j + 46, 176, 10, scaled, 10);
    }

    public void drawTemp(GuiGraphics guiGraphics, float percent) {
        percent = Math.min(100.0f, percent);
        int scaled = (int)(72.0f * percent);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(CAR_GUI_TEXTURE, i + 96, j + 46, 176, 30, scaled, 10);
    }

    public void drawBattery(GuiGraphics guiGraphics, float percent) {
        percent = Math.min(100.0f, percent);
        int scaled = (int)(72.0f * percent);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(CAR_GUI_TEXTURE, i + 96, j + 20, 176, 20, scaled, 10);
    }
}

