/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.light.LightListener;
import com.jozufozu.flywheel.light.LightUpdater;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrackInstance
extends BlockEntityInstance<TrackBlockEntity> {
    private List<BezierTrackInstance> instances;

    public TrackInstance(MaterialManager materialManager, TrackBlockEntity track) {
        super(materialManager, (BlockEntity)track);
        this.update();
    }

    public void update() {
        if (((TrackBlockEntity)this.blockEntity).connections.isEmpty()) {
            return;
        }
        this.remove();
        this.instances = ((TrackBlockEntity)this.blockEntity).connections.values().stream().map(this::createInstance).filter(Objects::nonNull).toList();
        LightUpdater.get((LevelAccessor)this.world).addListener((LightListener)this);
    }

    public ImmutableBox getVolume() {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        out.addAll(((TrackBlockEntity)this.blockEntity).connections.keySet());
        out.addAll(((TrackBlockEntity)this.blockEntity).connections.keySet());
        return GridAlignedBB.containingAll(out);
    }

    public void updateLight() {
        if (this.instances == null) {
            return;
        }
        this.instances.forEach(BezierTrackInstance::updateLight);
    }

    @Nullable
    private BezierTrackInstance createInstance(BezierConnection bc) {
        if (!bc.isPrimary()) {
            return null;
        }
        return new BezierTrackInstance(bc);
    }

    public void remove() {
        if (this.instances == null) {
            return;
        }
        this.instances.forEach(BezierTrackInstance::delete);
    }

    private class BezierTrackInstance {
        private final ModelData[] ties;
        private final ModelData[] left;
        private final ModelData[] right;
        private final BlockPos[] tiesLightPos;
        private final BlockPos[] leftLightPos;
        private final BlockPos[] rightLightPos;
        @Nullable
        private GirderInstance girder;

        private BezierTrackInstance(BezierConnection bc) {
            BlockPos tePosition = (BlockPos)bc.tePositions.getFirst();
            this.girder = bc.hasGirder ? new GirderInstance(bc) : null;
            PoseStack pose = new PoseStack();
            TransformStack.cast((PoseStack)pose).translate((Vec3i)TrackInstance.this.getInstancePosition());
            Material mat = TrackInstance.this.materialManager.cutout(RenderType.m_110457_()).material(Materials.TRANSFORMED);
            int segCount = bc.getSegmentCount();
            this.ties = new ModelData[segCount];
            this.left = new ModelData[segCount];
            this.right = new ModelData[segCount];
            this.tiesLightPos = new BlockPos[segCount];
            this.leftLightPos = new BlockPos[segCount];
            this.rightLightPos = new BlockPos[segCount];
            TrackMaterial.TrackModelHolder modelHolder = bc.getMaterial().getModelHolder();
            mat.getModel(modelHolder.tie()).createInstances((InstanceData[])this.ties);
            mat.getModel(modelHolder.segment_left()).createInstances((InstanceData[])this.left);
            mat.getModel(modelHolder.segment_right()).createInstances((InstanceData[])this.right);
            BezierConnection.SegmentAngles[] segments = bc.getBakedSegments();
            for (int i = 1; i < segments.length; ++i) {
                BezierConnection.SegmentAngles segment = segments[i];
                int modelIndex = i - 1;
                this.ties[modelIndex].setTransform(pose).mulPose(segment.tieTransform.m_252922_()).mulNormal(segment.tieTransform.m_252943_());
                this.tiesLightPos[modelIndex] = segment.lightPosition.m_121955_((Vec3i)tePosition);
                for (boolean first : Iterate.trueAndFalse) {
                    PoseStack.Pose transform = segment.railTransforms.get(first);
                    (first ? this.left : this.right)[modelIndex].setTransform(pose).mulPose(transform.m_252922_()).mulNormal(transform.m_252943_());
                    (first ? this.leftLightPos : this.rightLightPos)[modelIndex] = segment.lightPosition.m_121955_((Vec3i)tePosition);
                }
            }
            this.updateLight();
        }

        void delete() {
            for (ModelData d : this.ties) {
                d.delete();
            }
            for (ModelData d : this.left) {
                d.delete();
            }
            for (ModelData d : this.right) {
                d.delete();
            }
            if (this.girder != null) {
                this.girder.delete();
            }
        }

        void updateLight() {
            int i;
            for (i = 0; i < this.ties.length; ++i) {
                this.ties[i].updateLight((BlockAndTintGetter)TrackInstance.this.world, this.tiesLightPos[i]);
            }
            for (i = 0; i < this.left.length; ++i) {
                this.left[i].updateLight((BlockAndTintGetter)TrackInstance.this.world, this.leftLightPos[i]);
            }
            for (i = 0; i < this.right.length; ++i) {
                this.right[i].updateLight((BlockAndTintGetter)TrackInstance.this.world, this.rightLightPos[i]);
            }
            if (this.girder != null) {
                this.girder.updateLight();
            }
        }

        private class GirderInstance {
            private final Couple<ModelData[]> beams;
            private final Couple<Couple<ModelData[]>> beamCaps;
            private final BlockPos[] lightPos;

            private GirderInstance(BezierConnection bc) {
                BlockPos tePosition = (BlockPos)bc.tePositions.getFirst();
                PoseStack pose = new PoseStack();
                ((TransformStack)TransformStack.cast((PoseStack)pose).translate((Vec3i)TrackInstance.this.getInstancePosition())).nudge((int)((BlockPos)bc.tePositions.getFirst()).m_121878_());
                Material mat = TrackInstance.this.materialManager.cutout(RenderType.m_110457_()).material(Materials.TRANSFORMED);
                int segCount = bc.getSegmentCount();
                this.beams = Couple.create(() -> new ModelData[segCount]);
                this.beamCaps = Couple.create(() -> Couple.create(() -> new ModelData[segCount]));
                this.lightPos = new BlockPos[segCount];
                this.beams.forEach(arg_0 -> ((Instancer)mat.getModel(AllPartialModels.GIRDER_SEGMENT_MIDDLE)).createInstances(arg_0));
                this.beamCaps.forEachWithContext((c, top) -> c.forEach(arg_0 -> ((Instancer)mat.getModel(top.booleanValue() ? AllPartialModels.GIRDER_SEGMENT_TOP : AllPartialModels.GIRDER_SEGMENT_BOTTOM)).createInstances(arg_0)));
                BezierConnection.GirderAngles[] bakedGirders = bc.getBakedGirders();
                for (int i = 1; i < bakedGirders.length; ++i) {
                    BezierConnection.GirderAngles segment = bakedGirders[i];
                    int modelIndex = i - 1;
                    this.lightPos[modelIndex] = segment.lightPosition.m_121955_((Vec3i)tePosition);
                    for (boolean first : Iterate.trueAndFalse) {
                        PoseStack.Pose beamTransform = segment.beams.get(first);
                        this.beams.get(first)[modelIndex].setTransform(pose).mulPose(beamTransform.m_252922_()).mulNormal(beamTransform.m_252943_());
                        for (boolean top2 : Iterate.trueAndFalse) {
                            PoseStack.Pose beamCapTransform = segment.beamCaps.get(top2).get(first);
                            this.beamCaps.get(top2).get(first)[modelIndex].setTransform(pose).mulPose(beamCapTransform.m_252922_()).mulNormal(beamCapTransform.m_252943_());
                        }
                    }
                }
                this.updateLight();
            }

            void delete() {
                this.beams.forEach(arr -> {
                    for (ModelData d : arr) {
                        d.delete();
                    }
                });
                this.beamCaps.forEach(c -> c.forEach(arr -> {
                    for (ModelData d : arr) {
                        d.delete();
                    }
                }));
            }

            void updateLight() {
                this.beams.forEach(arr -> {
                    for (int i = 0; i < ((ModelData[])arr).length; ++i) {
                        arr[i].updateLight((BlockAndTintGetter)TrackInstance.this.world, this.lightPos[i]);
                    }
                });
                this.beamCaps.forEach(c -> c.forEach(arr -> {
                    for (int i = 0; i < ((ModelData[])arr).length; ++i) {
                        arr[i].updateLight((BlockAndTintGetter)TrackInstance.this.world, this.lightPos[i]);
                    }
                }));
            }
        }
    }
}

