/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.cable_blocks.copycat_cable_block;

import com.drmangotea.tfmg.blocks.electricity.base.IHaveCables;
import com.drmangotea.tfmg.blocks.electricity.base.cables.ConnectNeightborsPacket;
import com.drmangotea.tfmg.blocks.electricity.cable_blocks.copycat_cable_block.CopycatCableBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelDataManager;
import net.minecraftforge.network.PacketDistributor;

public class CopycatCableBlock
extends Block
implements IBE<CopycatCableBlockEntity>,
IWrenchable,
IHaveCables {
    public CopycatCableBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        this.onWrenched(state, context);
        return super.onSneakWrenched(state, context);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return this.onBlockEntityUse((BlockGetter)context.m_43725_(), context.m_8083_(), ufte -> {
            ItemStack consumedItem = ufte.getConsumedItem();
            if (!ufte.hasCustomMaterial()) {
                return InteractionResult.PASS;
            }
            Player player = context.m_43723_();
            if (!player.m_7500_()) {
                player.m_150109_().m_150079_(consumedItem);
            }
            context.m_43725_().m_46796_(2001, context.m_8083_(), Block.m_49956_((BlockState)ufte.m_58900_()));
            ufte.setMaterial(AllBlocks.COPYCAT_BASE.getDefaultState());
            ufte.setConsumedItem(ItemStack.f_41583_);
            return InteractionResult.SUCCESS;
        });
    }

    public void m_6807_(BlockState pState, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new ConnectNeightborsPacket(pos));
        this.withBlockEntityDo((BlockGetter)level, pos, CopycatCableBlockEntity::onPlaced);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer == null) {
            return InteractionResult.PASS;
        }
        Direction face = pHit.m_82434_();
        ItemStack itemInHand = pPlayer.m_21120_(pHand);
        BlockState materialIn = this.getAcceptedBlockState(pLevel, pPos, itemInHand, face);
        if (materialIn != null) {
            materialIn = this.prepareMaterial(pLevel, pPos, pState, pPlayer, pHand, pHit, materialIn);
        }
        if (materialIn == null) {
            return InteractionResult.PASS;
        }
        BlockState material = materialIn;
        return this.onBlockEntityUse((BlockGetter)pLevel, pPos, ufte -> {
            if (ufte.getMaterial().m_60713_(material.m_60734_())) {
                if (!ufte.cycleMaterial()) {
                    return InteractionResult.PASS;
                }
                ufte.m_58904_().m_5594_(null, ufte.m_58899_(), SoundEvents.f_12013_, SoundSource.BLOCKS, 0.75f, 0.95f);
                return InteractionResult.SUCCESS;
            }
            if (ufte.hasCustomMaterial()) {
                return InteractionResult.PASS;
            }
            if (pLevel.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            ufte.setMaterial(material);
            ufte.setConsumedItem(itemInHand);
            ufte.m_58904_().m_5594_(null, ufte.m_58899_(), material.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 0.75f);
            if (pPlayer.m_7500_()) {
                return InteractionResult.SUCCESS;
            }
            itemInHand.m_41774_(1);
            if (itemInHand.m_41619_()) {
                pPlayer.m_21008_(pHand, ItemStack.f_41583_);
            }
            return InteractionResult.SUCCESS;
        });
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        if (pPlacer == null) {
            return;
        }
        ItemStack offhandItem = pPlacer.m_21120_(InteractionHand.OFF_HAND);
        BlockState appliedState = this.getAcceptedBlockState(pLevel, pPos, offhandItem, Direction.m_122382_((Entity)pPlacer)[0]);
        if (appliedState == null) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, ufte -> {
            Player player;
            if (ufte.hasCustomMaterial()) {
                return;
            }
            ufte.setMaterial(appliedState);
            ufte.setConsumedItem(offhandItem);
            if (pPlacer instanceof Player && (player = (Player)pPlacer).m_7500_()) {
                return;
            }
            offhandItem.m_41774_(1);
            if (offhandItem.m_41619_()) {
                pPlacer.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            }
        });
    }

    @Nullable
    public BlockState getAcceptedBlockState(Level pLevel, BlockPos pPos, ItemStack item, Direction face) {
        Item item2 = item.m_41720_();
        if (!(item2 instanceof BlockItem)) {
            return null;
        }
        BlockItem bi = (BlockItem)item2;
        Block block = bi.m_40614_();
        if (block instanceof CopycatBlock || block instanceof CopycatCableBlock) {
            return null;
        }
        BlockState appliedState = block.m_49966_();
        boolean hardCodedAllow = this.isAcceptedRegardless(appliedState);
        if (!AllTags.AllBlockTags.COPYCAT_ALLOW.matches(block) && !hardCodedAllow) {
            if (AllTags.AllBlockTags.COPYCAT_DENY.matches(block)) {
                return null;
            }
            if (block instanceof EntityBlock) {
                return null;
            }
            if (block instanceof StairBlock) {
                return null;
            }
            if (pLevel != null) {
                VoxelShape shape = appliedState.m_60808_((BlockGetter)pLevel, pPos);
                if (shape.m_83281_() || !shape.m_83215_().equals((Object)Shapes.m_83144_().m_83215_())) {
                    return null;
                }
                VoxelShape collisionShape = appliedState.m_60812_((BlockGetter)pLevel, pPos);
                if (collisionShape.m_83281_()) {
                    return null;
                }
            }
        }
        if (face != null) {
            Direction.Axis axis = face.m_122434_();
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61372_)) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)face);
            }
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61374_) && axis != Direction.Axis.Y) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)face);
            }
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61365_)) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis);
            }
            if (appliedState.m_61138_((Property)BlockStateProperties.f_61364_) && axis != Direction.Axis.Y) {
                appliedState = (BlockState)appliedState.m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)axis);
            }
        }
        return appliedState;
    }

    public boolean isAcceptedRegardless(BlockState material) {
        return false;
    }

    public BlockState prepareMaterial(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer, InteractionHand pHand, BlockHitResult pHit, BlockState material) {
        return material;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean pIsMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
        if (!state.m_155947_() || state.m_60734_() == newState.m_60734_()) {
            return;
        }
        if (!pIsMoving) {
            this.withBlockEntityDo((BlockGetter)level, pos, ufte -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)ufte.getConsumedItem()));
        }
        level.m_46747_(pos);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.m_5707_(pLevel, pPos, pState, pPlayer);
        if (pPlayer.m_7500_()) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, ufte -> ufte.setConsumedItem(ItemStack.f_41583_));
        }
    }

    public Class<CopycatCableBlockEntity> getBlockEntityClass() {
        return CopycatCableBlockEntity.class;
    }

    public BlockEntityType<? extends CopycatCableBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.COPYCAT_CABLE.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        if (this.isIgnoredConnectivitySide(level, state, side, pos, queryPos)) {
            return state;
        }
        ModelDataManager modelDataManager = level.getModelDataManager();
        if (modelDataManager == null) {
            return CopycatCableBlock.getMaterial((BlockGetter)level, pos);
        }
        return CopycatModel.getMaterial((ModelData)modelDataManager.getAt(pos));
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        return false;
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        return true;
    }

    public static BlockState getMaterial(BlockGetter reader, BlockPos targetPos) {
        BlockEntity blockEntity = reader.m_7702_(targetPos);
        if (blockEntity instanceof CopycatCableBlockEntity) {
            CopycatCableBlockEntity cbe = (CopycatCableBlockEntity)blockEntity;
            return cbe.getMaterial();
        }
        return Blocks.f_50016_.m_49966_();
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return false;
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return false;
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return CopycatCableBlock.getMaterial((BlockGetter)level, pos).m_60827_();
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return CopycatCableBlock.getMaterial((BlockGetter)level, pos).getFriction(level, pos, entity);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return CopycatCableBlock.getMaterial(level, pos).getLightEmission(level, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return CopycatCableBlock.getMaterial(level, pos).canHarvestBlock(level, pos, player);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return CopycatCableBlock.getMaterial(level, pos).getExplosionResistance(level, pos, explosion);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockState material = CopycatCableBlock.getMaterial(level, pos);
        if (TFMGBlocks.COPYCAT_CABLE_BASE.has(material) || player != null && player.m_6144_()) {
            return new ItemStack((ItemLike)this);
        }
        return material.getCloneItemStack(target, level, pos, player);
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return CopycatCableBlock.getMaterial((BlockGetter)level, pos).addLandingEffects(level, pos, state2, entity, numberOfParticles);
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        return CopycatCableBlock.getMaterial((BlockGetter)level, pos).addRunningEffects(level, pos, entity);
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        return CopycatCableBlock.getMaterial((BlockGetter)level, pos).getEnchantPowerBonus(level, pos);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return CopycatCableBlock.getMaterial(level, pos).canEntityDestroy(level, pos, entity);
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        BlockState material = CopycatCableBlock.getMaterial((BlockGetter)pLevel, pPos);
        material.m_60734_().m_142072_(pLevel, material, pPos, pEntity, pFallDistance);
    }

    public float m_5880_(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        return CopycatCableBlock.getMaterial(pLevel, pPos).m_60625_(pPlayer, pLevel, pPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor wrappedColor() {
        return new WrappedBlockColor();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WrappedBlockColor
    implements BlockColor {
        public int m_92566_(BlockState pState, @Nullable BlockAndTintGetter pLevel, @Nullable BlockPos pPos, int pTintIndex) {
            if (pLevel == null || pPos == null) {
                return GrassColor.m_46415_((double)0.5, (double)1.0);
            }
            return Minecraft.m_91087_().m_91298_().m_92577_(CopycatCableBlock.getMaterial((BlockGetter)pLevel, pPos), pLevel, pPos, pTintIndex);
        }
    }
}

