/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.electric_pump;

import com.drmangotea.tfmg.CreateTFMG;
import com.drmangotea.tfmg.base.MaxBlockVoltage;
import com.drmangotea.tfmg.base.TFMGTools;
import com.drmangotea.tfmg.blocks.electricity.base.IHaveCables;
import com.drmangotea.tfmg.blocks.electricity.base.TFMGForgeEnergyStorage;
import com.drmangotea.tfmg.blocks.electricity.base.VoltageAlteringBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.base.cables.ElectricNetworkManager;
import com.drmangotea.tfmg.blocks.electricity.base.cables.ElectricalNetwork;
import com.drmangotea.tfmg.blocks.electricity.base.cables.EnergyNetworkUpdatePacket;
import com.drmangotea.tfmg.blocks.electricity.base.cables.IElectric;
import com.drmangotea.tfmg.blocks.electricity.base.cables.WireConnection;
import com.drmangotea.tfmg.blocks.electricity.base.cables.WireManager;
import com.drmangotea.tfmg.blocks.electricity.cable_blocks.CableHubBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.simibubi.create.Create;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.PipeConnection;
import com.simibubi.create.content.fluids.pump.PumpBlock;
import com.simibubi.create.content.fluids.pump.PumpBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class ElectricPumpBlockEntity
extends PumpBlockEntity
implements IElectric {
    public long network = this.getId();
    public Player player = null;
    public int voltage = 0;
    boolean destroyed = false;
    public boolean networkUpdate = false;
    public boolean needsVoltageUpdate = false;
    private LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    public final TFMGForgeEnergyStorage energy = this.createEnergyStorage();
    public ArrayList<WireConnection> wireConnections = new ArrayList();

    public ElectricPumpBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(10);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new ElectricPumpTransferBehavior((SmartBlockEntity)this));
        this.registerAwardables(behaviours, FluidPropagator.getSharedTriggers());
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.PUMP});
    }

    protected void distributePressureTo(Direction side) {
        BlockFace start = new BlockFace(this.f_58858_, side);
        boolean pull = this.isPullingOnSide(this.isFront(side));
        HashSet<BlockFace> targets = new HashSet<BlockFace>();
        HashMap<BlockPos, Pair> pipeGraph = new HashMap<BlockPos, Pair>();
        if (!pull) {
            FluidPropagator.resetAffectedFluidNetworks((Level)this.f_58857_, (BlockPos)this.f_58858_, (Direction)side.m_122424_());
        }
        if (!this.hasReachedValidEndpoint((LevelAccessor)this.f_58857_, start, pull)) {
            ((Map)pipeGraph.computeIfAbsent(this.f_58858_, $ -> Pair.of((Object)0, new IdentityHashMap())).getSecond()).put(side, pull);
            ((Map)pipeGraph.computeIfAbsent(start.getConnectedPos(), $ -> Pair.of((Object)1, new IdentityHashMap())).getSecond()).put(side.m_122424_(), !pull);
            ArrayList<Pair> frontier = new ArrayList<Pair>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            int maxDistance = (int)((double)FluidPropagator.getPumpRange() * Math.min((double)6.7f, (double)this.getVoltage() * 0.02));
            frontier.add(Pair.of((Object)1, (Object)start.getConnectedPos()));
            while (!frontier.isEmpty()) {
                Pair entry = (Pair)frontier.remove(0);
                int distance = (Integer)entry.getFirst();
                BlockPos currentPos = (BlockPos)entry.getSecond();
                if (!this.f_58857_.m_46749_(currentPos) || visited.contains(currentPos)) continue;
                visited.add(currentPos);
                BlockState currentState = this.f_58857_.m_8055_(currentPos);
                FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)this.f_58857_, (BlockPos)currentPos);
                if (pipe == null) continue;
                for (Direction face : FluidPropagator.getPipeConnections((BlockState)currentState, (FluidTransportBehaviour)pipe)) {
                    BlockFace blockFace = new BlockFace(currentPos, face);
                    BlockPos connectedPos = blockFace.getConnectedPos();
                    if (!this.f_58857_.m_46749_(connectedPos) || blockFace.isEquivalent(start)) continue;
                    if (this.hasReachedValidEndpoint((LevelAccessor)this.f_58857_, blockFace, pull)) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((BlockGetter)this.f_58857_, (BlockPos)connectedPos);
                    if (pipeBehaviour == null || pipeBehaviour instanceof ElectricPumpTransferBehavior || visited.contains(connectedPos)) continue;
                    if (distance + 1 >= maxDistance) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                    ((Map)pipeGraph.computeIfAbsent(connectedPos, $ -> Pair.of((Object)(distance + 1), new IdentityHashMap())).getSecond()).put(face.m_122424_(), !pull);
                    frontier.add(Pair.of((Object)(distance + 1), (Object)connectedPos));
                }
            }
        }
        HashMap validFaces = new HashMap();
        this.searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(start.getPos(), start.getOppositeFace()), pull);
        float pressure = this.energy.getEnergyStored() == 0 ? 0.0f : (float)Math.min(1500, this.getVoltage() * 2);
        for (Set set : validFaces.values()) {
            int parallelBranches = Math.max(1, set.size() - 1);
            for (BlockFace face : set) {
                BlockPos pipePos = face.getPos();
                Direction pipeSide = face.getFace();
                if (pipePos.equals((Object)this.f_58858_)) continue;
                boolean inbound = (Boolean)((Map)((Pair)pipeGraph.get(pipePos)).getSecond()).get(pipeSide);
                FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((BlockGetter)this.f_58857_, (BlockPos)pipePos);
                if (pipeBehaviour == null) continue;
                pipeBehaviour.addPressure(pipeSide, inbound, pressure / (float)parallelBranches);
            }
        }
    }

    private boolean hasReachedValidEndpoint(LevelAccessor world, BlockFace blockFace, boolean pull) {
        LazyOptional capability;
        BlockPos connectedPos = blockFace.getConnectedPos();
        BlockState connectedState = world.m_8055_(connectedPos);
        BlockEntity blockEntity = world.m_7702_(connectedPos);
        Direction face = blockFace.getFace();
        if (PumpBlock.isPump((BlockState)connectedState) && ((Direction)connectedState.m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_() == face.m_122434_() && blockEntity instanceof ElectricPumpBlockEntity) {
            ElectricPumpBlockEntity pumpBE = (ElectricPumpBlockEntity)blockEntity;
            return pumpBE.isPullingOnSide(pumpBE.isFront(blockFace.getOppositeFace())) != pull;
        }
        FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)world, (BlockPos)connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, blockFace.getOppositeFace())) {
            return false;
        }
        if (blockEntity != null && (capability = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, face.m_122424_())).isPresent()) {
            return true;
        }
        return FluidPropagator.isOpenEnd((BlockGetter)world, (BlockPos)blockFace.getPos(), (Direction)face);
    }

    protected boolean isFront(Direction side) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof PumpBlock)) {
            return false;
        }
        Direction front = (Direction)blockState.m_61143_((Property)DirectionalKineticBlock.FACING);
        boolean isFront = side == front;
        return isFront;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyHandler.invalidate();
    }

    public void useEnergy(int value) {
        this.energy.extractEnergy(value, false);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side == null) {
            return this.lazyEnergyHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY && this.hasElectricitySlot(side)) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void lazyTick() {
        super.lazyTick();
        this.useEnergy(Math.min(750, this.getVoltage()) / 20);
        if (this.energy.getEnergyStored() != 0) {
            this.updatePressureChange();
        }
        this.getOrCreateElectricNetwork().requestEnergy((SmartBlockEntity)this);
        this.getOrCreateElectricNetwork().members.removeIf(member -> !(this.f_58857_.m_7702_(BlockPos.m_122022_((long)member.getId())) instanceof IElectric));
        this.getOrCreateElectricNetwork().members.removeIf(member -> member.getNetwork() != this.getNetwork());
        this.getOrCreateElectricNetwork().add(this);
        for (Direction direction : Direction.values()) {
            if (!this.hasElectricitySlot(direction)) continue;
            BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
            if (be == null) {
                return;
            }
            LazyOptional capability = be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_());
            if (!capability.isPresent() || !((IEnergyStorage)capability.orElseGet(null)).canReceive() || be instanceof IElectric) continue;
            int maxTransfer1 = this.getForgeEnergy().extractEnergy(this.getForgeEnergy().getEnergyStored(), true);
            int maxTransfer2 = ((IEnergyStorage)capability.orElseGet(null)).receiveEnergy(this.getForgeEnergy().getEnergyStored(), true);
            this.getForgeEnergy().extractEnergy(Math.min(maxTransfer1, maxTransfer2), false);
            ((IEnergyStorage)capability.orElseGet(null)).receiveEnergy(Math.min(maxTransfer1, maxTransfer2), false);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyHandler = LazyOptional.of(() -> this.energy);
    }

    public void tick() {
        super.tick();
        if (this.getVoltage() > this.maxVoltage()) {
            this.voltageFailure();
        }
        if (this.FEProduction() > 0) {
            this.energy.receiveEnergy(this.FEProduction(), false);
        }
        if (this.networkUpdate) {
            this.getOrCreateElectricNetwork().updateNetworkVoltage();
            this.networkUpdate = false;
        }
        if (this.needsVoltageUpdate) {
            this.setVoltageFromNetwork();
            this.getOrCreateElectricNetwork().updateNetworkVoltage();
            this.needsVoltageUpdate = false;
        }
        this.sendData();
        this.m_6596_();
        if (Create.RANDOM.nextBoolean()) {
            this.removeInvalidConnections();
        }
    }

    public void remove() {
        this.getOrCreateElectricNetwork().remove(this);
        this.voltage = 0;
        this.onVoltageChanged();
        this.destroyed = true;
        if (this.network == this.getId()) {
            this.getOrCreateElectricNetwork().members.forEach(c -> c.setNetwork(c.getNetwork(), false));
            ElectricNetworkManager.networks.get(this.m_58904_()).remove(this.network);
        }
        for (WireConnection wireConnection : this.wireConnections) {
            BlockPos pos = wireConnection.point1 == this.m_58899_() ? wireConnection.point2 : wireConnection.point1;
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof IElectric)) continue;
            IElectric be = (IElectric)blockEntity;
            be.makeControllerAndSpread();
            be.needsNetworkUpdate();
            be.needsVoltageUpdate();
            be.getOrCreateElectricNetwork().updateVoltageFromNetwork();
        }
        ArrayList<WireConnection> list = new ArrayList<WireConnection>();
        for (WireConnection connection : this.wireConnections) {
            if (connection.neighborConnection) continue;
            list.add(connection);
        }
        ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f), new ItemStack((ItemLike)TFMGItems.COPPER_CABLE.get(), list.size()));
        if (itemEntity.m_32055_().m_41613_() == 0) {
            return;
        }
        this.f_58857_.m_7967_((Entity)itemEntity);
        super.remove();
    }

    @Override
    public boolean outputAllowed() {
        return false;
    }

    public void removeInvalidConnections() {
        this.wireConnections.removeIf(connection -> !(this.f_58857_.m_8055_(connection.point1).m_60734_() instanceof IHaveCables) || !(this.f_58857_.m_8055_(connection.point2).m_60734_() instanceof IHaveCables));
    }

    @Override
    public void makeControllerAndSpread() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.getOrCreateElectricNetwork().members.remove(this);
        CreateTFMG.NETWORK_MANAGER.getOrCreateNetworkFor(this);
        this.setNetwork(this.getId(), false);
        this.network = this.getId();
        this.onConnected();
    }

    @Override
    public TFMGForgeEnergyStorage getForgeEnergy() {
        return this.energy;
    }

    @Override
    public void onConnected() {
        this.needsVoltageUpdate = true;
        if (this.f_58857_.f_46443_) {
            return;
        }
        for (WireConnection connection : this.wireConnections) {
            BlockPos pos = connection.point1 == this.m_58899_() ? connection.point2 : connection.point1;
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof IElectric)) continue;
            IElectric be = (IElectric)blockEntity;
            if (be instanceof CableHubBlockEntity) {
                CableHubBlockEntity be1 = (CableHubBlockEntity)be;
                if (be1.hasSignal) continue;
            }
            if (be.getNetwork() != this.network && !be.destroyed()) {
                be.setNetwork(this.network, true);
                be.onConnected();
                continue;
            }
            if (!be.destroyed()) continue;
            this.getOrCreateElectricNetwork().remove(be);
        }
    }

    @Override
    public int FECapacity() {
        return 10000;
    }

    @Override
    public int FEProduction() {
        return 0;
    }

    @Override
    public int FETransferSpeed() {
        return 2500;
    }

    @Override
    public int getVoltage() {
        return this.voltage;
    }

    @Override
    public int maxVoltage() {
        return MaxBlockVoltage.MAX_VOLTAGES.get(TFMGBlockEntities.COPYCAT_CABLE.get());
    }

    @Override
    public int voltageGeneration() {
        int voltageGeneration = 0;
        for (Direction direction : Direction.values()) {
            VoltageAlteringBlockEntity be;
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(direction) || !((blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction))) instanceof VoltageAlteringBlockEntity) || !(be = (VoltageAlteringBlockEntity)blockEntity).hasElectricitySlot(direction)) continue;
            voltageGeneration = Math.max(voltageGeneration, be.getOutputVoltage());
        }
        return voltageGeneration;
    }

    public void setVoltage(int value) {
        this.setVoltage(value, true);
    }

    @Override
    public void setVoltage(int value, boolean update) {
        this.voltage = value;
        if (update) {
            this.onVoltageChanged();
        }
    }

    @Override
    public void voltageFailure() {
    }

    @Override
    public void setNetwork(long newNetwork, boolean removeNetwork) {
        if (this.network == newNetwork) {
            return;
        }
        if (removeNetwork) {
            ElectricNetworkManager.networks.get(this.m_58904_()).remove(this.network);
        } else {
            this.getOrCreateElectricNetwork().remove(this);
        }
        long oldNetwork = this.network;
        this.network = newNetwork;
        this.m_6596_();
        this.network = newNetwork;
        ElectricalNetwork network1 = this.getOrCreateElectricNetwork();
        if (network1.members.contains(this)) {
            this.network = oldNetwork;
            return;
        }
        TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new EnergyNetworkUpdatePacket(this.m_58899_(), this.network));
        network1.add(this);
    }

    public void onPlaced() {
        this.networkUpdate = true;
        this.connectNeighbors();
        this.setVoltage(this.voltageGeneration());
    }

    @Override
    public void setVoltageFromNetwork() {
        this.setVoltage(Math.max(this.getOrCreateElectricNetwork().voltage, this.voltageGeneration()), false);
    }

    @Override
    public void connectNeighbors() {
        for (Direction direction : Direction.values()) {
            BlockPos pos;
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(direction) || !((blockEntity = this.f_58857_.m_7702_(pos = this.m_58899_().m_121945_(direction))) instanceof IElectric)) continue;
            IElectric be = (IElectric)blockEntity;
            if (be instanceof CableHubBlockEntity) {
                CableHubBlockEntity be1 = (CableHubBlockEntity)be;
                if (be1.hasSignal) continue;
            }
            if (!be.hasElectricitySlot(direction.m_122424_())) continue;
            be.addConnection(WireManager.Conductor.COPPER, this.m_58899_(), false, true);
            be.sendStuff();
            this.addConnection(WireManager.Conductor.COPPER, pos, false, true);
            this.sendData();
            this.m_6596_();
            be.makeControllerAndSpread();
        }
    }

    @Override
    public void needsVoltageUpdate() {
        this.needsVoltageUpdate = true;
    }

    @Override
    public boolean destroyed() {
        return this.destroyed;
    }

    @Override
    public void needsNetworkUpdate() {
        this.networkUpdate = true;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Voltage", this.getVoltage());
        compound.m_128356_("Network", this.network);
        int value = 0;
        for (WireConnection connection : this.wireConnections) {
            connection.saveConnection(compound, ++value - 1);
        }
        compound.m_128405_("WireCount", this.wireConnections.toArray().length);
        compound.m_128405_("ForgeEnergy", this.getForgeEnergy().getEnergyStored());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.voltage = compound.m_128451_("Voltage");
        this.addConnection(WireManager.Conductor.COPPER, this.m_58899_().m_6630_(2).m_122012_(), true, true);
        if (this.wireConnections.isEmpty()) {
            return;
        }
        this.wireConnections = new ArrayList();
        for (int i = 0; i < compound.m_128451_("WireCount"); ++i) {
            BlockPos pos = new BlockPos(compound.m_128451_("X1" + i), compound.m_128451_("Y1" + i), compound.m_128451_("Z1" + i));
            if (pos == this.m_58899_()) {
                pos = new BlockPos(compound.m_128451_("X2" + i), compound.m_128451_("Y2" + i), compound.m_128451_("Z2" + i));
            }
            this.addConnection(WireManager.Conductor.COPPER, pos, compound.m_128471_("ShouldRender" + i), compound.m_128471_("NeighborConnection" + i));
        }
        this.network = compound.m_128454_("Network");
        this.setNetwork(this.network, false);
        this.energy.setEnergy(compound.m_128451_("ForgeEnergy"));
    }

    public void onVoltageChanged() {
        this.updatePressureChange();
        this.getOrCreateElectricNetwork().updateNetworkVoltage();
    }

    @Override
    public boolean addConnection(WireManager.Conductor material, BlockPos pos, boolean shouldRender, boolean neighborConnection) {
        float lenght = TFMGTools.getDistance(this.m_58899_(), pos, false);
        if (lenght < 25.0f) {
            this.wireConnections.add(new WireConnection(material, lenght, pos, this.m_58899_(), shouldRender, neighborConnection));
            this.sendData();
            this.m_6596_();
            return true;
        }
        this.sendData();
        this.m_6596_();
        return false;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction.m_122434_() != ((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_();
    }

    @Override
    public long getNetwork() {
        return this.network;
    }

    @Override
    public long getId() {
        return this.m_58899_().m_121878_();
    }

    @Override
    public ElectricalNetwork getOrCreateElectricNetwork() {
        if ((IElectric)this.f_58857_.m_7702_(BlockPos.m_122022_((long)this.network)) != null) {
            return CreateTFMG.NETWORK_MANAGER.getOrCreateNetworkFor((IElectric)this.f_58857_.m_7702_(BlockPos.m_122022_((long)this.network)));
        }
        return CreateTFMG.NETWORK_MANAGER.getOrCreateNetworkFor(this);
    }

    @Override
    public void setNetworkClient(long value) {
        this.network = value;
    }

    @Override
    public void sendStuff() {
        this.sendData();
        this.m_6596_();
    }

    class ElectricPumpTransferBehavior
    extends FluidTransportBehaviour {
        public ElectricPumpTransferBehavior(SmartBlockEntity be) {
            super(be);
        }

        public void tick() {
            super.tick();
            for (Map.Entry entry : this.interfaces.entrySet()) {
                boolean pull = ElectricPumpBlockEntity.this.isPullingOnSide(ElectricPumpBlockEntity.this.isFront((Direction)entry.getKey()));
                Couple pressure = ((PipeConnection)entry.getValue()).getPressure();
                pressure.set(pull, (Object)Float.valueOf(ElectricPumpBlockEntity.this.energy.getEnergyStored() == 0 ? 0.0f : Math.min(1500.0f, (float)ElectricPumpBlockEntity.this.getVoltage() * 2.0f)));
                pressure.set(!pull, (Object)Float.valueOf(0.0f));
            }
        }

        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return ElectricPumpBlockEntity.this.isSideAccessible(direction);
        }

        public FluidTransportBehaviour.AttachmentTypes getRenderedRimAttachment(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction direction) {
            FluidTransportBehaviour.AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM) {
                return FluidTransportBehaviour.AttachmentTypes.NONE;
            }
            return attachment;
        }
    }
}

