/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EarmuffsRecipe
implements CraftingRecipe {
    private final ResourceLocation id;

    public EarmuffsRecipe(ResourceLocation rl) {
        this.id = rl;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level worldIn) {
        ItemStack earmuffs = ItemStack.f_41583_;
        ItemStack armor = ItemStack.f_41583_;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ArmorItem armorItem;
            Item item;
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            boolean isEarmuffs = stackInSlot.m_150930_(IEItems.Misc.EARMUFFS.m_5456_());
            if (earmuffs.m_41619_() && isEarmuffs) {
                earmuffs = stackInSlot;
                continue;
            }
            if (armor.m_41619_() && (item = stackInSlot.m_41720_()) instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == EquipmentSlot.HEAD && !isEarmuffs) {
                armor = stackInSlot;
                continue;
            }
            if (Utils.isDye(stackInSlot)) {
                list.add(stackInSlot);
                continue;
            }
            return false;
        }
        if (!(earmuffs.m_41619_() || armor.m_41619_() && list.isEmpty())) {
            return true;
        }
        return !armor.m_41619_() && ItemNBTHelper.hasKey(armor, "IE:Earmuffs") && earmuffs.m_41619_() && list.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ItemStack earmuffs = ItemStack.f_41583_;
        ItemStack armor = ItemStack.f_41583_;
        int[] colourArray = new int[3];
        int j = 0;
        int totalColourSets = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            boolean isEarmuffs = stackInSlot.m_150930_(IEItems.Misc.EARMUFFS.m_5456_());
            if (earmuffs.m_41619_() && isEarmuffs) {
                earmuffs = stackInSlot;
                int colour = ((IEItemInterfaces.IColouredItem)earmuffs.m_41720_()).getColourForIEItem(earmuffs, 0);
                float r = (float)(colour >> 16 & 0xFF) / 255.0f;
                float g = (float)(colour >> 8 & 0xFF) / 255.0f;
                float b = (float)(colour & 0xFF) / 255.0f;
                j = (int)((float)j + Math.max(r, Math.max(g, b)) * 255.0f);
                colourArray[0] = (int)((float)colourArray[0] + r * 255.0f);
                colourArray[1] = (int)((float)colourArray[1] + g * 255.0f);
                colourArray[2] = (int)((float)colourArray[2] + b * 255.0f);
                ++totalColourSets;
                continue;
            }
            if (Utils.isDye(stackInSlot)) {
                float[] afloat = Utils.getDye(stackInSlot).m_41068_();
                int r = (int)(afloat[0] * 255.0f);
                int g = (int)(afloat[1] * 255.0f);
                int b = (int)(afloat[2] * 255.0f);
                j += Math.max(r, Math.max(g, b));
                colourArray[0] = colourArray[0] + r;
                colourArray[1] = colourArray[1] + g;
                colourArray[2] = colourArray[2] + b;
                ++totalColourSets;
                continue;
            }
            if (!armor.m_41619_() || !(stackInSlot.m_41720_() instanceof ArmorItem) || ((ArmorItem)stackInSlot.m_41720_()).m_40402_() != EquipmentSlot.HEAD || isEarmuffs) continue;
            armor = stackInSlot;
        }
        if (!earmuffs.m_41619_()) {
            ItemStack output;
            if (totalColourSets > 1) {
                int r = colourArray[0] / totalColourSets;
                int g = colourArray[1] / totalColourSets;
                int b = colourArray[2] / totalColourSets;
                float colourMod = (float)j / (float)totalColourSets;
                float highestColour = Math.max(r, Math.max(g, b));
                r = (int)((float)r * colourMod / highestColour);
                g = (int)((float)g * colourMod / highestColour);
                b = (int)((float)b * colourMod / highestColour);
                int newColour = (r << 8) + g;
                newColour = (newColour << 8) + b;
                ItemNBTHelper.putInt(earmuffs, "IE:EarmuffColour", newColour);
            }
            if (!armor.m_41619_()) {
                output = armor.m_41777_();
                ItemNBTHelper.setItemStack(output, "IE:Earmuffs", earmuffs.m_41777_());
            } else {
                output = earmuffs.m_41777_();
            }
            return output;
        }
        if (!armor.m_41619_() && ItemNBTHelper.hasKey(armor, "IE:Earmuffs")) {
            ItemStack output = armor.m_41777_();
            ItemNBTHelper.remove(output, "IE:Earmuffs");
            return output;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess access) {
        return new ItemStack(IEItems.Misc.EARMUFFS, 1);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = super.m_7457_((Container)inv);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_() || !ItemNBTHelper.hasKey(stackInSlot, "IE:Earmuffs")) continue;
            remaining.set(i, (Object)ItemNBTHelper.getItemStack(stackInSlot, "IE:Earmuffs"));
        }
        return remaining;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.EARMUFF_SERIALIZER.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{IEItems.Misc.EARMUFFS}));
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }
}

