/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_hit_effects;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import rbasamoyai.createbigcannons.block_hit_effects.ProjectileParticleEffectModifiers;
import rbasamoyai.createbigcannons.effects.particles.impacts.GlassBurstParticleData;
import rbasamoyai.createbigcannons.effects.particles.impacts.LeafBurstParticleData;
import rbasamoyai.createbigcannons.effects.particles.impacts.SparkBurstParticleData;
import rbasamoyai.createbigcannons.effects.particles.impacts.SplinterBurstParticleData;
import rbasamoyai.createbigcannons.index.CBCParticleTypes;

public class DefaultParticleModifiers {
    private static ParticleOptions modifySparkBurst(ProjectileParticleEffectModifiers.Modifier.Context context) {
        ParticleOptions options = context.particle();
        if (!(options instanceof SparkBurstParticleData)) {
            return options;
        }
        SparkBurstParticleData data = (SparkBurstParticleData)options;
        return new SparkBurstParticleData(data.color(), data.deflect(), DefaultParticleModifiers.getCount(data.count(), context));
    }

    private static ParticleOptions modifySplinterBurst(ProjectileParticleEffectModifiers.Modifier.Context context) {
        SplinterBurstParticleData data;
        ParticleOptions options = context.particle();
        if (!(options instanceof SplinterBurstParticleData) || !(data = (SplinterBurstParticleData)options).blockState().m_60795_()) {
            return options;
        }
        return new SplinterBurstParticleData(context.blockState(), DefaultParticleModifiers.getCount(data.count(), context));
    }

    private static ParticleOptions modifyGlassBurst(ProjectileParticleEffectModifiers.Modifier.Context context) {
        GlassBurstParticleData data;
        ParticleOptions options = context.particle();
        if (!(options instanceof GlassBurstParticleData) || !(data = (GlassBurstParticleData)options).blockState().m_60795_()) {
            return options;
        }
        return new GlassBurstParticleData(context.blockState(), DefaultParticleModifiers.getCount(data.count(), context));
    }

    private static ParticleOptions modifyLeafBurst(ProjectileParticleEffectModifiers.Modifier.Context context) {
        LeafBurstParticleData data;
        ParticleOptions options = context.particle();
        if (!(options instanceof LeafBurstParticleData) || !(data = (LeafBurstParticleData)options).blockState().m_60795_()) {
            return options;
        }
        return new LeafBurstParticleData(context.blockState(), DefaultParticleModifiers.getCount(data.count(), context));
    }

    private static int getCount(int baseCount, ProjectileParticleEffectModifiers.Modifier.Context context) {
        return Mth.m_14167_((float)((float)baseCount * context.effect().effectMultiplier()));
    }

    public static void register() {
        ProjectileParticleEffectModifiers.register(CBCParticleTypes.SPARK_BURST.get(), DefaultParticleModifiers::modifySparkBurst);
        ProjectileParticleEffectModifiers.register(CBCParticleTypes.SPLINTER_BURST.get(), DefaultParticleModifiers::modifySplinterBurst);
        ProjectileParticleEffectModifiers.register(CBCParticleTypes.GLASS_BURST.get(), DefaultParticleModifiers::modifyGlassBurst);
        ProjectileParticleEffectModifiers.register(CBCParticleTypes.LEAF_BURST.get(), DefaultParticleModifiers::modifyLeafBurst);
    }
}

