/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import rbasamoyai.createbigcannons.base.CBCJsonResourceReloadListener;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.config.BigCannonPropellantCompatibilities;
import rbasamoyai.createbigcannons.network.RootPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;

public class BigCannonPropellantCompatibilityHandler {
    public static final Map<Block, BigCannonPropellantCompatibilities> PROPERTIES_MAP = new Reference2ObjectOpenHashMap();

    public static BigCannonPropellantCompatibilities getCompatibilities(Block block) {
        return PROPERTIES_MAP.getOrDefault(block, BigCannonPropellantCompatibilities.DEFAULT);
    }

    public static void writeBuf(FriendlyByteBuf buf) {
        buf.m_130130_(PROPERTIES_MAP.size());
        for (Map.Entry<Block, BigCannonPropellantCompatibilities> entry : PROPERTIES_MAP.entrySet()) {
            buf.m_130085_(CBCRegistryUtils.getBlockLocation(entry.getKey()));
            entry.getValue().writeBuf(buf);
        }
    }

    public static void readBuf(FriendlyByteBuf buf) {
        PROPERTIES_MAP.clear();
        int sz = buf.m_130242_();
        for (int i = 0; i < sz; ++i) {
            PROPERTIES_MAP.put(CBCRegistryUtils.getBlock(buf.m_130281_()), BigCannonPropellantCompatibilities.readBuf(buf));
        }
    }

    public static void syncTo(ServerPlayer player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundBigCannonPropellantPropertiesPacket(), player);
    }

    public record ClientboundBigCannonPropellantPropertiesPacket(@Nullable FriendlyByteBuf buf) implements RootPacket
    {
        public ClientboundBigCannonPropellantPropertiesPacket() {
            this(null);
        }

        public static ClientboundBigCannonPropellantPropertiesPacket copyOf(FriendlyByteBuf buf) {
            return new ClientboundBigCannonPropellantPropertiesPacket(new FriendlyByteBuf(buf.copy()));
        }

        @Override
        public void rootEncode(FriendlyByteBuf buf) {
            BigCannonPropellantCompatibilityHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, PacketListener listener, @Nullable ServerPlayer sender) {
            if (this.buf != null) {
                BigCannonPropellantCompatibilityHandler.readBuf(this.buf);
            }
        }
    }

    public static class ReloadListener
    extends CBCJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        protected ReloadListener() {
            super(GSON, "big_cannon_propellant_compatibility");
        }

        protected void apply(Multimap<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
            PROPERTIES_MAP.clear();
            for (Map.Entry e : object.entries()) {
                ResourceLocation loc = (ResourceLocation)e.getKey();
                Block block = CBCRegistryUtils.getOptionalBlock(loc).orElseThrow(() -> new JsonSyntaxException("Unknown block '" + loc + "'"));
                JsonElement el = (JsonElement)e.getValue();
                if (!el.isJsonObject()) continue;
                JsonObject obj = el.getAsJsonObject();
                boolean replaceValues = GsonHelper.m_13855_((JsonObject)obj, (String)"replace", (boolean)false);
                BigCannonPropellantCompatibilities oldProperties = PROPERTIES_MAP.get(block);
                BigCannonPropellantCompatibilities newProperties = BigCannonPropellantCompatibilities.fromJson(obj, oldProperties, replaceValues);
                PROPERTIES_MAP.put(block, newProperties);
            }
        }
    }
}

