/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.be;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.quark.addons.oddities.block.MagnetBlock;
import org.violetmoon.quark.addons.oddities.block.be.MagnetizedBlockBlockEntity;
import org.violetmoon.quark.addons.oddities.magnetsystem.MagnetSystem;
import org.violetmoon.quark.addons.oddities.module.MagnetsModule;
import org.violetmoon.quark.api.IMagneticEntity;
import org.violetmoon.quark.content.automation.entity.Gravisand;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorServerGamePacketListener;
import org.violetmoon.zeta.api.ICollateralMover;

public class MagnetBlockEntity
extends BlockEntity {
    public MagnetBlockEntity(BlockPos pos, BlockState state) {
        super(MagnetsModule.magnetType, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MagnetBlockEntity be) {
        boolean powered = (Boolean)state.m_61143_((Property)MagnetBlock.POWERED);
        if (powered) {
            Direction dir = (Direction)state.m_61143_((Property)MagnetBlock.FACING);
            int power = level.m_277086_(pos);
            be.magnetize(state, dir, dir, power);
            be.magnetize(state, dir.m_122424_(), dir, power);
        }
    }

    private void magnetize(BlockState state, Direction dir, Direction moveDir, int power) {
        int blockDist;
        if (this.f_58857_ == null) {
            return;
        }
        double magnitude = dir == moveDir ? 1 : -1;
        for (blockDist = 1; blockDist <= power; ++blockDist) {
            BlockEntity blockEntity;
            BlockPos targetPos = this.f_58858_.m_5484_(dir, blockDist);
            BlockState targetState = this.f_58857_.m_8055_(targetPos);
            if (!this.f_58857_.f_46443_) {
                ICollateralMover.MoveResult reaction = MagnetSystem.getPushAction(this, targetPos, targetState, moveDir);
                if (reaction == ICollateralMover.MoveResult.MOVE || reaction == ICollateralMover.MoveResult.BREAK) {
                    MagnetSystem.applyForce(this.f_58857_, targetPos, power - blockDist + 1, dir == moveDir, moveDir, blockDist, this.f_58858_);
                } else if (reaction == ICollateralMover.MoveResult.PREVENT) break;
            }
            if (targetState.m_60734_() == MagnetsModule.magnetized_block && (blockEntity = this.f_58857_.m_7702_(targetPos)) instanceof MagnetizedBlockBlockEntity) {
                MagnetizedBlockBlockEntity mbe = (MagnetizedBlockBlockEntity)blockEntity;
                targetState = mbe.f_58856_;
            }
            if (!this.canFluxPenetrate(targetPos, targetState)) break;
        }
        if (MagnetsModule.affectEntities && blockDist > 1) {
            List entities = this.f_58857_.m_6249_((Entity)null, new AABB(this.f_58858_).m_82369_(new Vec3(dir.m_253071_().mul((float)blockDist))), this::canPullEntity);
            for (Entity e : entities) {
                this.pushEntity(dir, magnitude, e);
            }
        }
        if (this.f_58857_.f_46443_ && !((Boolean)state.m_61143_((Property)MagnetBlock.WAXED)).booleanValue()) {
            double particleMotion = 0.06 * magnitude;
            double particleChance = 0.2;
            double xOff = (double)dir.m_122429_() * particleMotion;
            double yOff = (double)dir.m_122430_() * particleMotion;
            double zOff = (double)dir.m_122431_() * particleMotion;
            double particleOffset = moveDir.m_122421_() == Direction.AxisDirection.POSITIVE ? 1.0 : -1.0;
            for (int j = 1; j < blockDist; ++j) {
                if (!((double)this.f_58857_.f_46441_.m_188501_() <= particleChance)) continue;
                BlockPos targetPos = this.f_58858_.m_5484_(dir, j);
                double x = (double)targetPos.m_123341_() + this.getParticlePos(xOff, this.f_58857_.f_46441_, particleOffset);
                double y = (double)targetPos.m_123342_() + this.getParticlePos(yOff, this.f_58857_.f_46441_, particleOffset);
                double z = (double)targetPos.m_123343_() + this.getParticlePos(zOff, this.f_58857_.f_46441_, particleOffset);
                SimpleParticleType p = dir == moveDir ? MagnetsModule.repulsorParticle : MagnetsModule.attractorParticle;
                this.f_58857_.m_7106_((ParticleOptions)p, x, y, z, xOff, yOff, zOff);
            }
        }
    }

    private void pushEntity(Direction dir, double magnitude, Entity e) {
        if (e instanceof Gravisand) {
            magnitude = -magnitude;
        }
        double distanceFromMagnetSq = e.m_20238_(this.f_58858_.m_252807_());
        double invSquared = 1.0 / distanceFromMagnetSq;
        Vec3 vec = new Vec3(dir.m_253071_().mul((float)(invSquared * magnitude * MagnetsModule.entitiesPullForce)));
        if (e instanceof IMagneticEntity) {
            IMagneticEntity me = (IMagneticEntity)e;
            me.moveByMagnet(e, vec, this);
        } else {
            e.m_5997_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
            if (e instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)e;
                ((AccessorServerGamePacketListener)player.f_8906_).setAboveGroundTickCount(0);
            } else {
                e.f_19864_ = true;
            }
            if (e instanceof FallingBlockEntity) {
                FallingBlockEntity fb = (FallingBlockEntity)e;
                --fb.f_31942_;
            }
            e.f_19789_ = 0.0f;
        }
    }

    private boolean canPullEntity(Entity e) {
        if (this.f_58857_.f_46443_) {
            if (MagnetsModule.affectsArmor && e instanceof Player) {
                for (ItemStack armor : e.m_6168_()) {
                    if (!MagnetSystem.isItemMagnetic(armor.m_41720_())) continue;
                    return true;
                }
            }
            return false;
        }
        if (e instanceof IMagneticEntity) {
            return true;
        }
        if (e instanceof ItemEntity) {
            ItemEntity ie = (ItemEntity)e;
            return MagnetSystem.isItemMagnetic(ie.m_32055_().m_41720_());
        }
        if (e.m_6095_().m_204039_(MagnetsModule.magneticEntities)) {
            return true;
        }
        if (e instanceof FallingBlockEntity) {
            FallingBlockEntity fb = (FallingBlockEntity)e;
            return MagnetSystem.isBlockMagnetic(fb.m_31980_());
        }
        if (MagnetsModule.affectsArmor) {
            for (ItemStack armor : e.m_6168_()) {
                if (!MagnetSystem.isItemMagnetic(armor.m_41720_())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canFluxPenetrate(BlockPos targetPos, BlockState targetState) {
        return targetState.m_60795_() || targetState.m_60812_((BlockGetter)this.f_58857_, targetPos).m_83281_();
    }

    private double getParticlePos(double offset, RandomSource ran, double magnitude) {
        return offset == 0.0 ? (double)(0.5f + (ran.m_188501_() + ran.m_188501_() - 1.0f) / 2.0f) : 0.5 + magnitude * ((double)ran.m_188501_() - 1.25);
    }
}

