/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.integration.jei;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.block.be.MatrixEnchantingTableBlockEntity;
import org.violetmoon.quark.addons.oddities.client.screen.BackpackInventoryScreen;
import org.violetmoon.quark.addons.oddities.client.screen.CrateScreen;
import org.violetmoon.quark.addons.oddities.module.MatrixEnchantingModule;
import org.violetmoon.quark.addons.oddities.util.CustomInfluence;
import org.violetmoon.quark.addons.oddities.util.Influence;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.content.building.module.VariantFurnacesModule;
import org.violetmoon.quark.content.tools.item.AncientTomeItem;
import org.violetmoon.quark.content.tools.module.AncientTomesModule;
import org.violetmoon.quark.content.tools.module.PickarangModule;
import org.violetmoon.quark.content.tweaks.module.DiamondRepairModule;
import org.violetmoon.quark.content.tweaks.recipe.ElytraDuplicationRecipe;
import org.violetmoon.quark.content.tweaks.recipe.SlabToBlockRecipe;
import org.violetmoon.quark.integration.jei.BackpackRecipeTransferHandler;
import org.violetmoon.quark.integration.jei.ElytraDuplicationExtension;
import org.violetmoon.quark.integration.jei.InfluenceCategory;
import org.violetmoon.quark.integration.jei.InfluenceEntry;
import org.violetmoon.quark.integration.jei.SlabToBlockExtension;
import org.violetmoon.zeta.config.ZetaGeneralConfig;
import org.violetmoon.zeta.event.play.loading.ZGatherHints;
import org.violetmoon.zeta.module.IDisableable;
import org.violetmoon.zeta.util.RegistryUtil;

@JeiPlugin
public class QuarkJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("quark", "quark");
    public static final RecipeType<InfluenceEntry> INFLUENCING = RecipeType.create((String)"quark", (String)"influence", InfluenceEntry.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{AncientTomesModule.ancient_tome});
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        List disabledItems = Quark.ZETA.requiredModTooltipHandler.disabledItems();
        if (!disabledItems.isEmpty()) {
            jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, (Collection)disabledItems);
        }
        Quark.ZETA.configManager.setJeiReloadListener(configInternals -> {
            if (Quark.ZETA.modules.isEnabled(DiamondRepairModule.class)) {
                Minecraft.m_91087_().m_18689_(() -> this.hideAnvilRepairRecipes(jeiRuntime.getRecipeManager()));
            }
            if (!ZetaGeneralConfig.hideDisabledContent) {
                return;
            }
            HashSet hidePotions = Sets.newHashSet();
            for (Potion potion : BuiltInRegistries.f_256980_) {
                ResourceLocation loc = BuiltInRegistries.f_256980_.m_7981_((Object)potion);
                if (loc == null || !loc.m_135827_().equals("quark") || Quark.ZETA.brewingRegistry.isEnabled(potion)) continue;
                hidePotions.add(potion);
            }
            NonNullList stacksToHide = NonNullList.m_122779_();
            for (Item item : BuiltInRegistries.f_257033_) {
                ResourceLocation loc = BuiltInRegistries.f_257033_.m_7981_((Object)item);
                if (!loc.m_135827_().equals("quark") || !IDisableable.isEnabled((Item)item)) {
                    // empty if block
                }
                if (!(item instanceof PotionItem) && !(item instanceof TippedArrowItem)) continue;
                NonNullList potionStacks = NonNullList.m_122779_();
                potionStacks.stream().filter(it -> hidePotions.contains(PotionUtils.m_43579_((ItemStack)it))).forEach(arg_0 -> stacksToHide.add(arg_0));
            }
            if (!stacksToHide.isEmpty()) {
                Minecraft.m_91087_().m_18689_(() -> jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, (Collection)stacksToHide));
            }
        });
    }

    public void registerVanillaCategoryExtensions(@NotNull IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addCategoryExtension(ElytraDuplicationRecipe.class, ElytraDuplicationExtension::new);
        registration.getCraftingCategory().addCategoryExtension(SlabToBlockRecipe.class, SlabToBlockExtension::new);
    }

    private boolean matrix() {
        return Quark.ZETA.modules.isEnabled(MatrixEnchantingModule.class) && MatrixEnchantingModule.allowInfluencing && !MatrixEnchantingModule.candleInfluencingFailed;
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        if (this.matrix()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new InfluenceCategory(registration.getJeiHelpers().getGuiHelper())});
        }
    }

    public void registerRecipes(final @NotNull IRecipeRegistration registration) {
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        if (Quark.ZETA.modules.isEnabled(AncientTomesModule.class)) {
            this.registerAncientTomeAnvilRecipes(registration, factory);
        }
        if (Quark.ZETA.modules.isEnabled(PickarangModule.class)) {
            this.registerPickarangAnvilRepairs(PickarangModule.pickarang, Items.f_42415_, registration, factory);
            this.registerPickarangAnvilRepairs(PickarangModule.flamerang, Items.f_42418_, registration, factory);
        }
        if (this.matrix()) {
            this.registerInfluenceRecipes(registration);
        }
        if (Quark.ZETA.modules.isEnabled(DiamondRepairModule.class)) {
            this.registerCustomAnvilRecipes(registration, factory);
        }
        if (ZetaGeneralConfig.enableJeiItemInfo) {
            final MutableComponent externalPreamble = Component.m_237115_((String)"quark.jei.hint_preamble");
            externalPreamble.m_6270_(externalPreamble.m_7383_().m_178520_(744779));
            final List blacklist = RegistryUtil.massRegistryGet((Collection)ZetaGeneralConfig.suppressedInfo, (Registry)BuiltInRegistries.f_257033_);
            Quark.ZETA.playBus.fire((Object)new ZGatherHints(){

                public void accept(ItemLike itemLike, Component extra) {
                    Item item = itemLike.m_5456_();
                    if (blacklist.contains(item)) {
                        return;
                    }
                    MutableComponent compound = Component.m_237113_((String)"");
                    if (!BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135827_().equals("quark")) {
                        compound = compound.m_7220_((Component)externalPreamble);
                    }
                    compound = compound.m_7220_(extra);
                    registration.addItemStackInfo(new ItemStack((ItemLike)item), new Component[]{compound});
                }

                public RegistryAccess getRegistryAccess() {
                    return QuarkClient.ZETA_CLIENT.hackilyGetCurrentClientLevelRegistryAccess();
                }
            }, ZGatherHints.class);
        }
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        if (Quark.ZETA.modules.isEnabled(VariantFurnacesModule.class)) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)VariantFurnacesModule.deepslateFurnace), new RecipeType[]{RecipeTypes.FUELING, RecipeTypes.SMELTING});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)VariantFurnacesModule.blackstoneFurnace), new RecipeType[]{RecipeTypes.FUELING, RecipeTypes.SMELTING});
        }
        if (this.matrix()) {
            if (MatrixEnchantingModule.automaticallyConvert) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50201_), new RecipeType[]{INFLUENCING});
            } else {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)MatrixEnchantingModule.matrixEnchanter), new RecipeType[]{INFLUENCING});
            }
        }
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CrateScreen.class, (IGuiContainerHandler)new CrateGuiHandler());
        registration.addRecipeClickArea(BackpackInventoryScreen.class, 137, 29, 10, 13, new RecipeType[]{RecipeTypes.CRAFTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BackpackRecipeTransferHandler(registration.getTransferHelper()), RecipeTypes.CRAFTING);
    }

    private void registerAncientTomeAnvilRecipes(@NotNull IRecipeRegistration registration, @NotNull IVanillaRecipeFactory factory) {
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        for (Enchantment enchant : AncientTomesModule.validEnchants) {
            EnchantmentInstance data = new EnchantmentInstance(enchant, enchant.m_6586_());
            recipes.add(factory.createAnvilRecipe(EnchantedBookItem.m_41161_((EnchantmentInstance)data), Collections.singletonList(AncientTomeItem.getEnchantedItemStack(enchant)), Collections.singletonList(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(data.f_44947_, data.f_44948_ + 1)))));
        }
        registration.addRecipes(RecipeTypes.ANVIL, recipes);
    }

    private void registerPickarangAnvilRepairs(Item pickarang, Item repairMaterial, @NotNull IRecipeRegistration registration, @NotNull IVanillaRecipeFactory factory) {
        ItemStack nearlyBroken = new ItemStack((ItemLike)pickarang);
        nearlyBroken.m_41721_(nearlyBroken.m_41776_());
        ItemStack veryDamaged = nearlyBroken.m_41777_();
        veryDamaged.m_41721_(veryDamaged.m_41776_() * 3 / 4);
        ItemStack damaged = nearlyBroken.m_41777_();
        damaged.m_41721_(damaged.m_41776_() * 2 / 4);
        IJeiAnvilRecipe materialRepair = factory.createAnvilRecipe(nearlyBroken, Collections.singletonList(new ItemStack((ItemLike)repairMaterial)), Collections.singletonList(veryDamaged));
        IJeiAnvilRecipe toolRepair = factory.createAnvilRecipe(veryDamaged, Collections.singletonList(veryDamaged), Collections.singletonList(damaged));
        registration.addRecipes(RecipeTypes.ANVIL, Arrays.asList(materialRepair, toolRepair));
    }

    private void registerInfluenceRecipes(@NotNull IRecipeRegistration registration) {
        registration.addRecipes(INFLUENCING, Arrays.stream(DyeColor.values()).map(color -> {
            Block candle = MatrixEnchantingTableBlockEntity.CANDLES.get(color.m_41060_());
            Influence influence = MatrixEnchantingModule.candleInfluences.get(color);
            return new InfluenceEntry(candle, influence);
        }).filter(InfluenceEntry::hasAny).collect(Collectors.toList()));
        registration.addRecipes(INFLUENCING, MatrixEnchantingModule.customInfluences.entrySet().stream().map(entry -> {
            Block block = ((BlockState)entry.getKey()).m_60734_();
            Influence influence = ((CustomInfluence)entry.getValue()).influence();
            return new InfluenceEntry(block, influence);
        }).filter(InfluenceEntry::hasAny).collect(Collectors.toList()));
    }

    private void hideAnvilRepairRecipes(@NotNull IRecipeManager manager) {
        Stream anvilRecipe = manager.createRecipeLookup(RecipeTypes.ANVIL).get();
        List hidden = anvilRecipe.filter(r -> {
            ItemStack left = r.getLeftInputs().stream().filter(st -> {
                Item i = st.m_41720_();
                return DiamondRepairModule.repairChanges.containsKey((Object)i) || DiamondRepairModule.unrepairableItems.contains(i);
            }).findFirst().orElse(null);
            if (left != null) {
                for (ItemStack right : r.getRightInputs()) {
                    Item item = left.m_41720_();
                    if (!item.m_6832_(left, right)) continue;
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        manager.hideRecipes(RecipeTypes.ANVIL, hidden);
    }

    private void registerCustomAnvilRecipes(@NotNull IRecipeRegistration registration, @NotNull IVanillaRecipeFactory factory) {
        for (Item item : DiamondRepairModule.repairChanges.keySet()) {
            ItemStack left = new ItemStack((ItemLike)item);
            ItemStack out = left.m_41777_();
            int max = Quark.ZETA.itemExtensions.get(left).getMaxDamageZeta(left);
            left.m_41721_(max - 1);
            out.m_41721_(max - max / 4);
            for (Item repair : DiamondRepairModule.repairChanges.get((Object)item)) {
                IJeiAnvilRecipe toolRepair = factory.createAnvilRecipe(left, Collections.singletonList(new ItemStack((ItemLike)repair)), Collections.singletonList(out));
                registration.addRecipes(RecipeTypes.ANVIL, List.of(toolRepair));
            }
        }
    }

    private static class CrateGuiHandler
    implements IGuiContainerHandler<CrateScreen> {
        private CrateGuiHandler() {
        }

        @NotNull
        public List<Rect2i> getGuiExtraAreas(@NotNull CrateScreen containerScreen) {
            return containerScreen.getExtraAreas();
        }
    }
}

