/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.ITiledBlock;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Chimney
extends Container
implements ITiledBlock<Container.Tile> {
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final EnumProperty<SideType> NORTH = EnumProperty.m_61587_((String)"north", SideType.class);
    public static final EnumProperty<SideType> EAST = EnumProperty.m_61587_((String)"east", SideType.class);
    public static final EnumProperty<SideType> SOUTH = EnumProperty.m_61587_((String)"south", SideType.class);
    public static final EnumProperty<SideType> WEST = EnumProperty.m_61587_((String)"west", SideType.class);
    public static final Map<Direction, EnumProperty<SideType>> SIDES = ImmutableMap.copyOf((Map)((Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
    })));
    public final boolean isNarrow;
    public final int radius;
    public final int wallThickness;
    protected final Map<BlockState, VoxelShape> shapesCache;

    public Chimney(Properties<?> props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false))).m_61124_(NORTH, (Comparable)((Object)SideType.NORMAL))).m_61124_(EAST, (Comparable)((Object)SideType.NORMAL))).m_61124_(SOUTH, (Comparable)((Object)SideType.NORMAL))).m_61124_(WEST, (Comparable)((Object)SideType.NORMAL)));
        this.isNarrow = props.isNarrow;
        this.radius = props.radius;
        this.wallThickness = props.wallThickness;
        this.shapesCache = this.m_152458_(this::calculateShapeFor);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, TOP, NORTH, EAST, SOUTH, WEST});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = super.m_5573_(context);
        state = this.updateTop((LevelReader)level, state, pos);
        for (Direction direction : GameWorld.Directions.of().horizontals().toList()) {
            state = this.updateSide((LevelReader)level, state, pos, direction);
        }
        return state;
    }

    protected VoxelShape calculateShapeFor(BlockState state) {
        return SIDES.entrySet().stream().filter(entry -> state.m_61138_((Property)entry.getValue())).map(entry -> this.makeSideShape((Direction)entry.getKey(), (SideType)((Object)((Object)state.m_61143_((Property)entry.getValue()))), (Boolean)state.m_61143_((Property)TOP))).reduce(Shapes.m_83040_(), Shapes::m_83110_);
    }

    protected VoxelShape sideWallShape(Direction side, int wallThickness) {
        return switch (side) {
            case Direction.NORTH -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)wallThickness);
            case Direction.SOUTH -> Block.m_49796_((double)0.0, (double)0.0, (double)(16 - wallThickness), (double)16.0, (double)16.0, (double)16.0);
            case Direction.WEST -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)wallThickness, (double)16.0, (double)16.0);
            case Direction.EAST -> Block.m_49796_((double)(16 - wallThickness), (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            default -> Shapes.m_83040_();
        };
    }

    protected VoxelShape makeSideShape(Direction side, SideType type, boolean top) {
        VoxelShape shape;
        int minXZ = this.isNarrow ? 8 - (this.radius - 1) : 8 - this.radius;
        int maxXZ = this.isNarrow ? 8 + (this.radius - 1) : 8 + this.radius;
        switch (side) {
            case NORTH: {
                VoxelShape voxelShape = Block.m_49796_((double)minXZ, (double)0.0, (double)minXZ, (double)maxXZ, (double)16.0, (double)(minXZ + this.wallThickness));
                break;
            }
            case SOUTH: {
                VoxelShape voxelShape = Block.m_49796_((double)minXZ, (double)0.0, (double)(maxXZ - this.wallThickness), (double)maxXZ, (double)16.0, (double)maxXZ);
                break;
            }
            case WEST: {
                VoxelShape voxelShape = Block.m_49796_((double)minXZ, (double)0.0, (double)minXZ, (double)(minXZ + this.wallThickness), (double)16.0, (double)maxXZ);
                break;
            }
            case EAST: {
                VoxelShape voxelShape = Block.m_49796_((double)(maxXZ - this.wallThickness), (double)0.0, (double)minXZ, (double)maxXZ, (double)16.0, (double)maxXZ);
                break;
            }
            default: {
                VoxelShape voxelShape = shape = Shapes.m_83040_();
            }
        }
        if (type != SideType.NORMAL) {
            int thic = minXZ + this.wallThickness;
            VoxelShape bridge = switch (side) {
                case Direction.NORTH -> Block.m_49796_((double)minXZ, (double)0.0, (double)0.0, (double)maxXZ, (double)16.0, (double)thic);
                case Direction.SOUTH -> Block.m_49796_((double)minXZ, (double)0.0, (double)(16 - thic), (double)maxXZ, (double)16.0, (double)16.0);
                case Direction.WEST -> Block.m_49796_((double)0.0, (double)0.0, (double)minXZ, (double)thic, (double)16.0, (double)maxXZ);
                case Direction.EAST -> Block.m_49796_((double)(16 - thic), (double)0.0, (double)minXZ, (double)16.0, (double)16.0, (double)maxXZ);
                default -> Shapes.m_83040_();
            };
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)bridge, (BooleanOp)BooleanOp.f_82695_);
            if (type == SideType.PORTAL) {
                int w = this.wallThickness;
                int h = top ? 0 : w;
                VoxelShape hole = switch (side) {
                    case Direction.NORTH -> Block.m_49796_((double)(minXZ + w), (double)0.0, (double)0.0, (double)(maxXZ - w), (double)(16 - h), (double)thic);
                    case Direction.SOUTH -> Block.m_49796_((double)(minXZ + w), (double)0.0, (double)(16 - thic), (double)(maxXZ - w), (double)(16 - h), (double)16.0);
                    case Direction.WEST -> Block.m_49796_((double)0.0, (double)0.0, (double)(minXZ + w), (double)thic, (double)(16 - h), (double)(maxXZ - w));
                    case Direction.EAST -> Block.m_49796_((double)(16 - thic), (double)0.0, (double)(minXZ + w), (double)16.0, (double)(16 - h), (double)(maxXZ - w));
                    default -> Shapes.m_83040_();
                };
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)hole, (BooleanOp)BooleanOp.f_82685_);
            }
        }
        return shape;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapesCache.get(pState);
    }

    @Override
    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        BlockState state = super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
        state = this.updateTop((LevelReader)pLevel, state, pPos);
        if (pDirection.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL) {
            state = this.updateSide((LevelReader)pLevel, state, pPos, pDirection);
        }
        return state;
    }

    protected BlockState updateTop(LevelReader level, BlockState state, BlockPos pos) {
        boolean chimneyAbove = GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)pos.m_7494_());
        return (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(!chimneyAbove));
    }

    protected boolean canAttachTo(BlockGetter level, Direction direction, BlockPos pos, BlockState state) {
        if (this.isNarrow) {
            return false;
        }
        if (state.m_60734_() instanceof ISmokeContainer) {
            return false;
        }
        VoxelShape blockShape = state.m_60816_(level, pos);
        if (blockShape == Shapes.m_83144_()) {
            return true;
        }
        Direction face = direction.m_122424_();
        VoxelShape faceShape = blockShape.m_83263_(face);
        Block block = state.m_60734_();
        if (block instanceof StairBlock) {
            StairBlock stair = (StairBlock)block;
            VoxelShape slabFace = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0).m_83263_(face);
            return Shapes.m_83157_((VoxelShape)faceShape, (VoxelShape)slabFace, (BooleanOp)BooleanOp.f_82685_);
        }
        return !faceShape.m_83281_();
    }

    protected BlockState updateSide(LevelReader level, BlockState state, BlockPos pos, Direction facing) {
        BlockPos neighborPos = pos.m_121945_(facing);
        SideType sideType = SideType.NORMAL;
        if (GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)neighborPos)) {
            BlockState neighborState = level.m_8055_(neighborPos);
            if (GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)neighborPos)) {
                Block block;
                if (!this.isNarrow && (block = neighborState.m_60734_()) instanceof Chimney) {
                    Chimney chimney = (Chimney)block;
                    if (!chimney.isNarrow) {
                        sideType = SideType.PORTAL;
                    }
                }
            } else if (AdChimneys.getInstance().emitters.get(level, neighborPos).isPresent()) {
                sideType = SideType.PORTAL;
            } else if (this.canAttachTo((BlockGetter)level, facing, neighborPos, neighborState)) {
                sideType = SideType.BRIDGE;
            }
        }
        return (BlockState)state.m_61124_((Property)SIDES.get(facing), (Comparable)((Object)sideType));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return switch (pRot) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_(NORTH, (Comparable)((Object)((SideType)((Object)pState.m_61143_(SOUTH)))))).m_61124_(EAST, (Comparable)((Object)((SideType)((Object)pState.m_61143_(WEST)))))).m_61124_(SOUTH, (Comparable)((Object)((SideType)((Object)pState.m_61143_(NORTH)))))).m_61124_(WEST, (Comparable)((Object)((SideType)((Object)pState.m_61143_(EAST)))));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_(NORTH, (Comparable)((Object)((SideType)((Object)pState.m_61143_(EAST)))))).m_61124_(EAST, (Comparable)((Object)((SideType)((Object)pState.m_61143_(SOUTH)))))).m_61124_(SOUTH, (Comparable)((Object)((SideType)((Object)pState.m_61143_(WEST)))))).m_61124_(WEST, (Comparable)((Object)((SideType)((Object)pState.m_61143_(NORTH)))));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_(NORTH, (Comparable)((Object)((SideType)((Object)pState.m_61143_(WEST)))))).m_61124_(EAST, (Comparable)((Object)((SideType)((Object)pState.m_61143_(NORTH)))))).m_61124_(SOUTH, (Comparable)((Object)((SideType)((Object)pState.m_61143_(EAST)))))).m_61124_(WEST, (Comparable)((Object)((SideType)((Object)pState.m_61143_(SOUTH)))));
            default -> pState;
        };
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return switch (pMirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)pState.m_61124_(NORTH, (Comparable)((Object)((SideType)((Object)pState.m_61143_(SOUTH)))))).m_61124_(SOUTH, (Comparable)((Object)((SideType)((Object)pState.m_61143_(NORTH)))));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)pState.m_61124_(EAST, (Comparable)((Object)((SideType)((Object)pState.m_61143_(WEST)))))).m_61124_(WEST, (Comparable)((Object)((SideType)((Object)pState.m_61143_(EAST)))));
            default -> super.m_6943_(pState, pMirror);
        };
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    @Override
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(true) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        int opacity;
        int n = opacity = state.m_280296_() && state.m_60827_() != SoundType.f_56744_ ? 1 : 0;
        if (!this.m_7420_(state, worldIn, pos)) {
            ++opacity;
        }
        return opacity;
    }

    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.CHIMNEY;
    }

    public boolean isActive(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_61138_((Property)WATERLOGGED) && (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public Container.Tile createTile(BlockPos pos, BlockState state) {
        return new Container.Tile(pos, state);
    }

    public Class<Container.Tile> getTileClass() {
        return Container.Tile.class;
    }

    public static enum SideType implements IForgeEnum
    {
        NORMAL,
        BRIDGE,
        PORTAL;


        public String toString() {
            return this.m_7912_();
        }
    }

    public static class Properties<T extends Properties<T>>
    extends Container.Properties<T> {
        boolean isNarrow = false;
        int radius = 8;
        int wallThickness = 2;

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
            this.vanillaProps.m_60955_();
        }

        public static Properties<?> of(String name) {
            return new Properties<Properties>(Properties.class, name);
        }

        public T narrow(int radius) {
            this.isNarrow = true;
            this.radius = radius;
            return (T)((Object)((Properties)this.self));
        }

        public T wallThickness(int thickness) {
            this.wallThickness = thickness;
            return (T)((Object)((Properties)this.self));
        }
    }
}

