/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.smoke;

import com.endertech.common.Args;
import com.endertech.common.IntBounds;
import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.units.ForgeEmitter;
import com.endertech.minecraft.mods.adchimneys.compat.Minecraft;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.LevelReader;

public class Emitter
extends ForgeEmitter
implements INBTSerializable<Emitter> {
    private final ColorARGB color;
    private final Smoke smoke;
    private final boolean canEmitAside;
    private final boolean emitWithoutChimney;
    private final int maxGapLength;

    public Emitter() {
        this(Properties.with());
    }

    public Emitter(Properties<?> props) {
        this(null, props);
    }

    public Emitter(@Nullable UnitConfig config, Properties<?> props) {
        super(config, props);
        String category = this.getClassCategory();
        this.color = UnitConfig.getColorARGB((UnitConfig)config, (String)category, (String)"color", (ColorARGB)props.color, (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb) which will be applied to the smoke.\nThe alpha channel of this color (aa) determines probability of applying (ff - always, 7f - 1/2, 00 - never).\n");
        this.smoke = new Smoke(config, props.smoke.getAmount(), props.smoke.getIntensity(), props.smoke.getScale(), this.color);
        this.canEmitAside = UnitConfig.getBool((UnitConfig)config, (String)category, (String)"canEmitAside", (boolean)props.canEmitAside, (String)"If true, the smoke will be transferred to the chimneys directly connected from aside.");
        this.emitWithoutChimney = UnitConfig.getBool((UnitConfig)config, (String)category, (String)"emitWithoutChimney", (boolean)props.emitWithoutChimney, (String)"If true, the smoke particles will be generated even without connected chimney.");
        this.maxGapLength = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"maxGapLength", (int)props.maxGapLength, (IntBounds)IntBounds.between((Integer)0, (Integer)16), (String)"Defines the maximum allowable air gap between the emitter and the chimney located above.");
        this.saveConfig();
    }

    public ColorARGB getColor() {
        return this.color;
    }

    public Emitter readFrom(CompoundTag compound) {
        CompoundTag tag = compound.m_128469_("Emitter");
        String id = tag.m_128461_("related_block_id");
        Properties props = (Properties)Properties.with().id(id);
        ((Properties)((Object)props.smoke(this.getSmoke().readFrom(tag)))).color(tag.m_128451_("color"));
        props.maxGapLength = tag.m_128451_("max_gap_length");
        props.canEmitAside = tag.m_128471_("can_emit_aside");
        props.emitWithoutChimney = tag.m_128471_("emit_without_chimney");
        props.activeTag(tag.m_128461_("active_tag"));
        props.identityTag(KeyValuePair.parse((String)tag.m_128461_("identity_tag")));
        return new Emitter(props);
    }

    public CompoundTag writeTo(CompoundTag compound) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("related_block_id", this.getRelatedId().toString());
        this.getSmoke().writeTo(tag);
        tag.m_128405_("color", this.getColor().getARGB());
        tag.m_128379_("can_emit_aside", this.canEmitAside());
        tag.m_128379_("emit_without_chimney", this.emitWithoutChimney());
        tag.m_128405_("max_gap_length", this.getMaxGapLength());
        tag.m_128359_("active_tag", this.getActiveTag());
        tag.m_128359_("identity_tag", this.getIdentityTag().toString());
        compound.m_128365_("Emitter", (Tag)tag);
        return compound;
    }

    public Smoke getSmoke(LevelReader world, BlockPos pos, boolean useTopEmitter, boolean useSideEmitter) {
        if ((useTopEmitter || useSideEmitter && this.canEmitAside()) && this.isActive(world, pos)) {
            return new Smoke().combine(this.getSmoke());
        }
        return new Smoke();
    }

    public String toString() {
        return Emitter.class.getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"id", (Object)this.getRelatedId()), Args.get((String)"canEmitAside", (Object)this.canEmitAside()), Args.get((String)"emitWithoutChimney", (Object)this.emitWithoutChimney()), Args.get((String)"maxGapLength", (Object)this.getMaxGapLength()), Args.get((String)"activeTag", (Object)this.getActiveTag()), Args.get((String)"identityTag", (Object)this.getIdentityTag()), this.getSmoke()});
    }

    public int getMaxGapLength() {
        return this.maxGapLength;
    }

    public boolean canEmitAside() {
        return this.canEmitAside;
    }

    public Smoke getSmoke() {
        return this.smoke;
    }

    public boolean emitWithoutChimney() {
        return this.emitWithoutChimney;
    }

    public String getClassCategory() {
        return IHaveConfig.getClassCategory(Emitter.class);
    }

    public static class Properties<T extends Properties<T>>
    extends ForgeEmitter.Properties<T> {
        public Optional<BiFunction<UnitConfig, Properties<?>, Emitter>> factory = Optional.empty();
        public ColorARGB color = Smoke.getDefaultColor();
        public Smoke smoke = Smoke.getNone();
        public boolean canEmitAside = true;
        public boolean emitWithoutChimney = true;
        public int maxGapLength = 0;

        protected Properties(Class<T> selfClazz) {
            super(selfClazz, IEmitter.Type.TILE);
        }

        public static Properties<?> campfire(String id) {
            return ((Properties)((Object)((Properties)((Object)((Properties)((Properties)Properties.with().id(id)).metadata("[lit=true, signal_fire=false]")).customFactory(Minecraft.Campfire::new))).smoke(1, 0.1f))).maxGapLength(2);
        }

        public static Properties<?> signal_campfire(String id, int color) {
            return ((Properties)((Object)((Properties)Properties.campfire(id).metadata("[lit=true, signal_fire=true]")).smoke(2, 0.5f))).color(color);
        }

        public static Properties<?> block() {
            return (Properties)Properties.with().type(IEmitter.Type.BLOCK);
        }

        public static Properties<?> furnace() {
            return Properties.tile("BurnTime").smoke(2, 1.0f);
        }

        public static Properties<?> tile(String activeTag) {
            return (Properties)Properties.with().activeTag(activeTag);
        }

        public static Properties<?> with() {
            return new Properties<Properties>(Properties.class);
        }

        public T activeProperty(String property) {
            return (T)((Object)((Properties)this.metadata("[" + property + "=true]")));
        }

        public T color(int argb) {
            return this.color(ColorARGB.from((int)argb));
        }

        public T color(ColorARGB color) {
            this.color = color;
            return (T)((Object)((Properties)this.self));
        }

        public T customFactory(BiFunction<UnitConfig, Properties<?>, Emitter> factory) {
            this.factory = Optional.ofNullable(factory);
            return (T)((Object)((Properties)this.self));
        }

        public T smoke(int amount, float intensity) {
            return this.smoke(amount, intensity, 2.0f);
        }

        public T smoke(int amount, float intensity, float scale) {
            return this.smoke(new Smoke(amount, intensity, scale));
        }

        public T smoke(Smoke smoke) {
            this.smoke = smoke;
            return (T)((Object)((Properties)this.self));
        }

        public T notEmitAside() {
            this.canEmitAside = false;
            return (T)((Object)((Properties)this.self));
        }

        public T notEmitWithoutChimney() {
            this.emitWithoutChimney = false;
            return (T)((Object)((Properties)this.self));
        }

        public T maxGapLength(int length) {
            this.maxGapLength = length;
            return (T)((Object)((Properties)this.self));
        }
    }
}

