/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.networking;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringFormattedMessage;
import org.valkyrienskies.core.impl.networking.NetworkChannel;
import org.valkyrienskies.core.impl.util.ClassLogger;
import org.valkyrienskies.core.impl.util.LoggingKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0001)B5\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010&\u001a\u00020%\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0007\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016R\u0017\u0010\u0019\u001a\u00020\u00188\u0007\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001e\u001a\u00020\u001d8\u0007\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$"}, d2={"Lorg/valkyrienskies/core/impl/networking/UdpClientImpl;", "", "", "run", "()V", "Lio/netty/buffer/ByteBuf;", "buf", "sendToServer", "(Lio/netty/buffer/ByteBuf;)V", "Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "channel", "Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "getChannel", "()Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "Lkotlin/Function0;", "onConfirm", "Lkotlin/jvm/functions/Function0;", "", "recvBuffer", "[B", "Ljava/net/DatagramPacket;", "recvPacket", "Ljava/net/DatagramPacket;", "sendPacket", "Ljava/net/SocketAddress;", "server", "Ljava/net/SocketAddress;", "getServer", "()Ljava/net/SocketAddress;", "Ljava/net/DatagramSocket;", "socket", "Ljava/net/DatagramSocket;", "getSocket", "()Ljava/net/DatagramSocket;", "Ljava/lang/Thread;", "thread", "Ljava/lang/Thread;", "", "id", "<init>", "(Ljava/net/DatagramSocket;Lorg/valkyrienskies/core/impl/networking/NetworkChannel;Ljava/net/SocketAddress;JLkotlin/jvm/functions/Function0;)V", "Companion"})
public final class UdpClientImpl {
    public static final Companion Companion = new Companion(null);
    private final DatagramSocket socket;
    private final NetworkChannel channel;
    private final SocketAddress server;
    private final Function0<Unit> onConfirm;
    private final Thread thread;
    private final byte[] recvBuffer;
    private final DatagramPacket recvPacket;
    private final DatagramPacket sendPacket;
    private static final Logger logger$delegate = LoggingKt.logger().provideDelegate-4Hzib3M(Companion, org.valkyrienskies.core.impl.networking.UdpClientImpl$Companion.$$delegatedProperties[0]);

    public UdpClientImpl(DatagramSocket socket, NetworkChannel channel, SocketAddress server, long id2, Function0<Unit> onConfirm) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"");
        Intrinsics.checkNotNullParameter((Object)server, (String)"");
        Intrinsics.checkNotNullParameter(onConfirm, (String)"");
        this.socket = socket;
        this.channel = channel;
        this.server = server;
        this.onConfirm = onConfirm;
        this.thread = new Thread(this::run);
        this.recvBuffer = new byte[508];
        this.recvPacket = new DatagramPacket(this.recvBuffer, 508);
        this.sendPacket = new DatagramPacket(new byte[508], 508);
        this.channel.setRawSendToServer((Function1<? super ByteBuf, Unit>)((Function1)new Function1<ByteBuf, Unit>((Object)this){

            public final void invoke(ByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"");
                ((UdpClientImpl)this.receiver).sendToServer(p0);
            }
        }));
        this.sendPacket.setSocketAddress(this.server);
        ByteBuf byteBuf = Unpooled.buffer((int)8).writeLong(id2);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"");
        this.sendToServer(byteBuf);
        this.socket.setSendBufferSize(30480);
        this.socket.setReceiveBufferSize(30480);
        this.thread.start();
    }

    @JvmName(name="getSocket")
    public final DatagramSocket getSocket() {
        return this.socket;
    }

    @JvmName(name="getChannel")
    public final NetworkChannel getChannel() {
        return this.channel;
    }

    @JvmName(name="getServer")
    public final SocketAddress getServer() {
        return this.server;
    }

    private final void sendToServer(ByteBuf buf) {
        this.sendPacket.setData(buf.array());
        this.sendPacket.setLength(buf.writerIndex());
        this.socket.send(this.sendPacket);
    }

    private final void run() {
        this.socket.setSoTimeout(1000);
        this.socket.receive(this.recvPacket);
        if (this.recvPacket.getLength() != 16) {
            throw new IllegalStateException("Invalid confirmation packet");
        }
        this.socket.setSoTimeout(0);
        this.onConfirm.invoke();
        int n2 = 0;
        long l2 = System.currentTimeMillis();
        while (!this.socket.isClosed()) {
            try {
                this.socket.receive(this.recvPacket);
                ++n2;
                if (!this.recvPacket.getSocketAddress().equals(this.server)) {
                    UdpClientImpl.Companion.getLogger().warn("Received packet from non server address: " + this.recvPacket.getSocketAddress());
                    UdpClientImpl.Companion.getLogger().warn("This is VERY SUSPICIOUS!");
                    continue;
                }
                if (l2 + (long)1000 < System.currentTimeMillis()) {
                    UdpClientImpl.Companion.getLogger().trace("Received " + n2 + " UDP packets");
                    n2 = 0;
                    l2 = System.currentTimeMillis();
                }
                UdpClientImpl.Companion.getLogger().trace(() -> UdpClientImpl.run$lambda$0(this));
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.recvBuffer, (int)0, (int)this.recvPacket.getLength());
                Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"");
                this.channel.onReceiveClient(byteBuf);
            }
            catch (Exception exception) {
                UdpClientImpl.Companion.getLogger().error("Error in client network thread", (Throwable)exception);
            }
        }
    }

    private static final Message run$lambda$0(UdpClientImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"");
        return (Message)new StringFormattedMessage("Client received packet of size " + this$0.recvPacket.getLength(), new Object[0]);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u001b\u0010\u0007\u001a\u00020\u00028CX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/valkyrienskies/core/impl/networking/UdpClientImpl$Companion;", "", "Lorg/apache/logging/log4j/Logger;", "logger$delegate", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "logger", "<init>", "()V"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @JvmName(name="getLogger")
        private final Logger getLogger() {
            return ClassLogger.getValue-impl(logger$delegate, this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "logger", "getLogger()Lorg/apache/logging/log4j/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

