/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.render_pathfinding;

import io.netty.buffer.Unpooled;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.Target;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.mod.common.config.VSGameConfig;
import org.valkyrienskies.mod.mixin.accessors.world.level.pathfinder.PathAccessor;

@Mixin(value={DebugPackets.class})
public class MixinDebugPackets {
    @Inject(method={"sendPathFindingPacket"}, at={@At(value="HEAD")})
    private static void sendPathFindingPacket(Level level, Mob mob, Path path, float maxDistanceToWaypoint, CallbackInfo ci2) {
        if (path == null || level.f_46443_ || !VSGameConfig.COMMON.ADVANCED.getRenderPathfinding()) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(mob.m_19879_());
        buf.writeFloat(maxDistanceToWaypoint);
        MixinDebugPackets.writePath(buf, path);
        ClientboundCustomPayloadPacket lv2 = new ClientboundCustomPayloadPacket(ClientboundCustomPayloadPacket.f_132013_, buf);
        for (Player player : level.m_6907_()) {
            ((ServerPlayer)player).f_8906_.m_9829_((Packet)lv2);
        }
    }

    private static void writePath(FriendlyByteBuf buffer, Path path) {
        buffer.writeBoolean(path.m_77403_());
        buffer.writeInt(path.m_77399_());
        Set<Target> targetSet = ((PathAccessor)path).getTargetNodes();
        if (targetSet != null) {
            buffer.writeInt(targetSet.size());
            targetSet.forEach(node -> MixinDebugPackets.writeNode(buffer, (Node)node));
        } else {
            buffer.writeInt(0);
        }
        buffer.writeInt(path.m_77406_().m_123341_());
        buffer.writeInt(path.m_77406_().m_123342_());
        buffer.writeInt(path.m_77406_().m_123343_());
        buffer.writeInt(path.m_77398_());
        for (int i2 = 0; i2 < path.m_77398_(); ++i2) {
            Node node2 = path.m_77375_(i2);
            MixinDebugPackets.writeNode(buffer, node2);
        }
        buffer.writeInt(0);
        buffer.writeInt(0);
    }

    private static void writeNode(FriendlyByteBuf buffer, Node node) {
        buffer.writeInt(node.f_77271_);
        buffer.writeInt(node.f_77272_);
        buffer.writeInt(node.f_77273_);
        buffer.writeFloat(node.f_77280_);
        buffer.writeFloat(node.f_77281_);
        buffer.writeBoolean(node.f_77279_);
        buffer.writeInt(node.f_77282_.ordinal());
        buffer.writeFloat(node.f_77277_);
    }
}

