/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.create.cannons;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;

@Mixin(value={CannonMountBlockEntity.class})
public abstract class MixinCannonMount
extends KineticBlockEntity
implements ControlPitchContraption.Block {
    private Integer cannonID = null;
    private boolean alreadyAdded = false;
    Vector3d recoilVec = null;
    double recoilForce = 0.0;

    public MixinCannonMount(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Unique
    private void handleAssembly() {
        LoadedServerShip ship = null;
        if (!this.f_58857_.f_46443_ && VSGameUtilsKt.getShipObjectManagingPos(this.f_58857_, (Vec3i)this.m_58899_()) != null) {
            ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)this.f_58857_, (Vec3i)this.m_58899_());
        }
        if (ship != null && !this.alreadyAdded && this.cannonID == null) {
            Vector3d pos = VectorConversionsMCKt.toJOMLD((Vec3i)this.f_58858_);
            this.alreadyAdded = true;
        }
    }

    @Unique
    private void handleDisassembly() {
        LoadedServerShip ship = null;
        if (!this.f_58857_.f_46443_ && VSGameUtilsKt.getShipObjectManagingPos(this.f_58857_, (Vec3i)this.m_58899_()) != null) {
            ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)this.f_58857_, (Vec3i)this.m_58899_());
        }
        if (this.cannonID != null) {
            this.cannonID = null;
            this.alreadyAdded = false;
            this.recoilVec = null;
        }
    }

    @Unique
    private void handleController() {
        LoadedServerShip ship = null;
        if (!this.f_58857_.f_46443_ && VSGameUtilsKt.getShipObjectManagingPos(this.f_58857_, (Vec3i)this.m_58899_()) != null) {
            ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)this.f_58857_, (Vec3i)this.m_58899_());
        }
        if (ship != null) {
            if (!this.alreadyAdded || this.cannonID == null || this.recoilVec != null) {
                // empty if block
            }
            if (this.m_58901_() && this.cannonID != null) {
                this.cannonID = null;
                this.alreadyAdded = false;
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, remap=false)
    private void injectTick(CallbackInfo ci2) {
        this.handleController();
    }

    @Inject(method={"assemble"}, at={@At(value="RETURN")}, remap=false)
    private void injectAssemble(CallbackInfo ci2) {
        this.handleAssembly();
    }

    @Inject(method={"disassemble"}, at={@At(value="HEAD")}, remap=false)
    private void injectDisassemble(CallbackInfo ci2) {
        this.handleDisassembly();
    }

    @Unique
    private CompoundTag writeToCompound(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("alreadyAdded", this.alreadyAdded);
        if (this.cannonID != null) {
            compound.m_128405_("cannonID", this.cannonID.intValue());
        }
        return compound;
    }

    @Inject(method={"write"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectWrite(CompoundTag compound, boolean clientPacket, CallbackInfo ci2) {
        compound = this.writeToCompound(compound, clientPacket);
        super.write(compound, clientPacket);
        ci2.cancel();
    }

    @Unique
    private CompoundTag readFromCompound(CompoundTag compound, boolean clientPacket) {
        this.alreadyAdded = compound.m_128471_("alreadyAdded");
        if (compound.m_128441_("cannonID")) {
            this.cannonID = compound.m_128451_("cannonID");
        }
        return compound;
    }

    @Inject(method={"read"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectRead(CompoundTag compound, boolean clientPacket, CallbackInfo ci2) {
        compound = this.readFromCompound(compound, clientPacket);
        super.read(compound, clientPacket);
        ci2.cancel();
    }
}

