/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.properties.synched;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.properties.synched.AbstractSynchedProperty;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;

public class SynchedListProperty
extends AbstractSynchedProperty<List<? extends String>> {
    public final Predicate<String> validator;

    public SynchedListProperty(String name, List<? extends String> defaultValue, Predicate<String> validator, String comment) {
        super(name, defaultValue, comment);
        this.validator = validator;
    }

    public static boolean isValidTagOrId(String string) {
        return UnitId.from(string).isTag() || UnitId.from(string).getFirstMatchedState() != null;
    }

    @Override
    public void define(AbstractForgeMod.ConfigValueBuilder builder) {
        this.configValue = builder.comment(this.comment).defineList(this.name, ((List)this.defaultValue).toArray(new String[0]), this.validator);
    }

    @Override
    public List<? extends String> readFrom(CompoundTag compound) {
        this.currentValue = Arrays.asList(TagHelper.getStringArray(compound, this.name));
        return this.currentValue;
    }

    @Override
    public CompoundTag writeTo(CompoundTag compound) {
        TagHelper.putStringArray(compound, this.name, ((List)this.getValue()).toArray(new String[0]));
        return compound;
    }
}

