/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.forge;

import dev.latvian.mods.rhino.mod.util.MojangMappings;
import dev.latvian.mods.rhino.mod.util.RemappingHelper;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod(value="rhino")
public class RhinoModForge {
    public RhinoModForge() {
        FMLJavaModLoadingContext.get().getModEventBus().register(RhinoModForge.class);
    }

    @SubscribeEvent
    public static void loaded(FMLCommonSetupEvent event) {
        if (RemappingHelper.GENERATE) {
            RemappingHelper.run(FMLLoader.versionInfo().mcVersion(), RhinoModForge::generateMappings);
        }
    }

    private static void generateMappings(RemappingHelper.MappingContext context) throws Exception {
        MojangMappings.ClassDef current = null;
        ArrayList<String> srg = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(RemappingHelper.createReader("https://raw.githubusercontent.com/MinecraftForge/MCPConfig/master/versions/release/" + context.mcVersion() + "/joined.tsrg"));){
            String line;
            while ((line = reader.readLine()) != null) {
                srg.add(line);
            }
        }
        Pattern pattern = Pattern.compile("[\t ]");
        for (int i = 1; i < srg.size(); ++i) {
            String[] s = pattern.split((CharSequence)srg.get(i));
            if (s.length < 3 || s[1].isEmpty()) continue;
            if (!s[0].isEmpty()) {
                s[0] = s[0].replace('/', '.');
                current = context.mappings().getClass(s[0]);
                if (current != null) {
                    RemappingHelper.LOGGER.info("- Checking class " + s[0] + " ; " + current.displayName);
                    continue;
                }
                RemappingHelper.LOGGER.info("- Skipping class " + s[0]);
                continue;
            }
            if (current == null) continue;
            if (s.length == 5) {
                if (s[1].equals("<init>") || s[1].equals("<clinit>")) continue;
                String sigs = s[2].substring(0, s[2].lastIndexOf(41) + 1).replace('/', '.');
                MojangMappings.NamedSignature sig = new MojangMappings.NamedSignature(s[1], context.mappings().readSignatureFromDescriptor(sigs));
                MojangMappings.MemberDef m = current.members.get(sig);
                if (m != null && !m.mmName().equals(s[3])) {
                    m.unmappedName().setValue((Object)s[3]);
                    RemappingHelper.LOGGER.info("Remapped method " + s[3] + sigs + " to " + m.mmName());
                    continue;
                }
                if (m != null || current.ignoredMembers.contains(sig)) continue;
                RemappingHelper.LOGGER.info("Method " + s[3] + " [" + sig + "] not found!");
                continue;
            }
            if (s.length != 4) continue;
            MojangMappings.NamedSignature sig = new MojangMappings.NamedSignature(s[1], null);
            MojangMappings.MemberDef m = current.members.get(sig);
            if (m != null) {
                if (m.mmName().equals(s[2])) continue;
                m.unmappedName().setValue((Object)s[2]);
                RemappingHelper.LOGGER.info("Remapped field " + s[2] + " [" + m.rawName() + "] to " + m.mmName());
                continue;
            }
            if (current.ignoredMembers.contains(sig)) continue;
            RemappingHelper.LOGGER.info("Field " + s[2] + " [" + s[1] + "] not found!");
        }
    }
}

