/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane;

import de.maxhenkel.plane.ClientConfig;
import de.maxhenkel.plane.ServerConfig;
import de.maxhenkel.plane.corelib.CommonRegistry;
import de.maxhenkel.plane.entity.EntityBushPlane;
import de.maxhenkel.plane.entity.EntityCargoPlane;
import de.maxhenkel.plane.entity.EntityPlane;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.entity.render.BushPlaneModel;
import de.maxhenkel.plane.entity.render.CargoPlaneModel;
import de.maxhenkel.plane.entity.render.PlaneModel;
import de.maxhenkel.plane.events.CapabilityEvents;
import de.maxhenkel.plane.events.CreativeTabEvents;
import de.maxhenkel.plane.events.InteractEvents;
import de.maxhenkel.plane.events.KeyEvents;
import de.maxhenkel.plane.events.RenderEvents;
import de.maxhenkel.plane.gui.ContainerPlane;
import de.maxhenkel.plane.gui.PlaneScreen;
import de.maxhenkel.plane.item.ModItems;
import de.maxhenkel.plane.loottable.CopyPlaneData;
import de.maxhenkel.plane.net.MessageControlPlane;
import de.maxhenkel.plane.net.MessagePlaneGui;
import de.maxhenkel.plane.sound.ModSounds;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="plane")
public class Main {
    public static final String MODID = "plane";
    public static SimpleChannel SIMPLE_CHANNEL;
    public static LootItemFunctionType COPY_PLANE_DATA;
    public static ServerConfig SERVER_CONFIG;
    public static ClientConfig CLIENT_CONFIG;
    public static KeyMapping PLANE_KEY;
    public static KeyMapping FORWARD_KEY;
    public static KeyMapping BACK_KEY;
    public static KeyMapping LEFT_KEY;
    public static KeyMapping RIGHT_KEY;
    public static KeyMapping UP_KEY;
    public static KeyMapping DOWN_KEY;
    public static KeyMapping START_KEY;
    public static KeyMapping BRAKE_KEY;
    private static final DeferredRegister<EntityType<?>> ENTITY_REGISTER;
    public static final RegistryObject<EntityType<EntityPlane>> PLANE_ENTITY_TYPE;
    public static final RegistryObject<EntityType<EntityCargoPlane>> CARGO_PLANE_ENTITY_TYPE;
    public static final RegistryObject<EntityType<EntityBushPlane>> BUSH_PLANE_ENTITY_TYPE;
    private static final DeferredRegister<MenuType<?>> MENU_TYPE_REGISTER;
    public static RegistryObject<MenuType<ContainerPlane>> PLANE_CONTAINER_TYPE;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CreativeTabEvents::onCreativeModeTabBuildContents);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class, true);
        CLIENT_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.CLIENT, ClientConfig.class);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.clientStart());
        ModItems.init();
        ModSounds.init();
        ENTITY_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        MENU_TYPE_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStart() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegisterKeyBinds);
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new InteractEvents());
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityEvents());
        COPY_PLANE_DATA = (LootItemFunctionType)Registry.m_122965_((Registry)BuiltInRegistries.f_256753_, (ResourceLocation)new ResourceLocation(MODID, "copy_plane_data"), (Object)new LootItemFunctionType((Serializer)new CopyPlaneData.Serializer()));
        SIMPLE_CHANNEL = CommonRegistry.registerChannel(MODID, "default");
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 0, MessageControlPlane.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 1, MessagePlaneGui.class);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        MenuScreens.ScreenConstructor factory = (container, playerInventory, name) -> new PlaneScreen((ContainerPlane)container, playerInventory, name);
        MenuScreens.m_96206_((MenuType)((MenuType)PLANE_CONTAINER_TYPE.get()), (MenuScreens.ScreenConstructor)factory);
        MinecraftForge.EVENT_BUS.register((Object)new KeyEvents());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        EntityRenderers.m_174036_((EntityType)((EntityType)PLANE_ENTITY_TYPE.get()), manager -> new PlaneModel(manager));
        EntityRenderers.m_174036_((EntityType)((EntityType)CARGO_PLANE_ENTITY_TYPE.get()), manager -> new CargoPlaneModel(manager));
        EntityRenderers.m_174036_((EntityType)((EntityType)BUSH_PLANE_ENTITY_TYPE.get()), manager -> new BushPlaneModel(manager));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRegisterKeyBinds(RegisterKeyMappingsEvent event) {
        PLANE_KEY = new KeyMapping("key.plane", 80, "category.plane");
        FORWARD_KEY = new KeyMapping("key.plane_add_thrust", 73, "category.plane");
        BACK_KEY = new KeyMapping("key.plane_remove_thrust", 75, "category.plane");
        LEFT_KEY = new KeyMapping("key.plane_left", 65, "category.plane");
        RIGHT_KEY = new KeyMapping("key.plane_right", 68, "category.plane");
        UP_KEY = new KeyMapping("key.plane_up", 83, "category.plane");
        DOWN_KEY = new KeyMapping("key.plane_down", 87, "category.plane");
        START_KEY = new KeyMapping("key.plane_start", 82, "category.plane");
        BRAKE_KEY = new KeyMapping("key.plane_brake", 66, "category.plane");
        event.register(PLANE_KEY);
        event.register(FORWARD_KEY);
        event.register(BACK_KEY);
        event.register(LEFT_KEY);
        event.register(RIGHT_KEY);
        event.register(UP_KEY);
        event.register(DOWN_KEY);
        event.register(START_KEY);
        event.register(BRAKE_KEY);
    }

    @Nullable
    public static EntityPlaneSoundBase getPlaneByUUID(Player player, UUID uuid) {
        double distance = 10.0;
        return player.m_9236_().m_6443_(EntityPlaneSoundBase.class, new AABB(player.m_20185_() - distance, player.m_20186_() - distance, player.m_20189_() - distance, player.m_20185_() + distance, player.m_20186_() + distance, player.m_20189_() + distance), entity -> entity.m_20148_().equals(uuid)).stream().findAny().orElse(null);
    }

    static {
        ENTITY_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)MODID);
        PLANE_ENTITY_TYPE = ENTITY_REGISTER.register(MODID, () -> CommonRegistry.registerEntity(MODID, MODID, MobCategory.MISC, EntityPlane.class, builder -> builder.setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).m_20699_(3.5f, 2.0f).setCustomClientFactory((spawnEntity, world) -> new EntityPlane((Level)world))));
        CARGO_PLANE_ENTITY_TYPE = ENTITY_REGISTER.register("cargo_plane", () -> CommonRegistry.registerEntity(MODID, "cargo_plane", MobCategory.MISC, EntityCargoPlane.class, builder -> builder.setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).m_20699_(3.5f, 2.0f).setCustomClientFactory((spawnEntity, world) -> new EntityCargoPlane((Level)world))));
        BUSH_PLANE_ENTITY_TYPE = ENTITY_REGISTER.register("bush_plane", () -> CommonRegistry.registerEntity(MODID, "bush_plane", MobCategory.MISC, EntityBushPlane.class, builder -> builder.setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).m_20699_(3.5f, 2.0f).setCustomClientFactory((spawnEntity, world) -> new EntityBushPlane((Level)world))));
        MENU_TYPE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)MODID);
        PLANE_CONTAINER_TYPE = MENU_TYPE_REGISTER.register(MODID, () -> new MenuType((MenuType.MenuSupplier)((IContainerFactory)(windowId, inv, data) -> {
            EntityPlaneSoundBase plane = Main.getPlaneByUUID(inv.f_35978_, data.m_130259_());
            if (plane == null) {
                return null;
            }
            return new ContainerPlane(windowId, plane, inv);
        }), FeatureFlags.f_244377_));
    }
}

