/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.items;

import com.github.talrey.createdeco.BlockRegistry;
import com.github.talrey.createdeco.blocks.CatwalkRailingBlock;
import com.github.talrey.createdeco.blocks.CatwalkStairBlock;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class RailingBlockItem
extends BlockItem {
    private final int placementHelperID = PlacementHelpers.register((IPlacementHelper)new RailingHelper());

    public RailingBlockItem(CatwalkRailingBlock block, Item.Properties props) {
        super((Block)block, props);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos pos = ctx.m_8083_();
        Direction face = ctx.m_43719_();
        Level level = ctx.m_43725_();
        Player player = ctx.m_43723_();
        ItemStack stack = ctx.m_43722_();
        BlockState state = level.m_8055_(pos);
        IPlacementHelper helper = PlacementHelpers.get((int)this.placementHelperID);
        BlockHitResult ray = new BlockHitResult(ctx.m_43720_(), face, pos, true);
        if (player == null) {
            return InteractionResult.PASS;
        }
        Block block = state.m_60734_();
        if (block instanceof CatwalkStairBlock) {
            CatwalkStairBlock catstair = (CatwalkStairBlock)block;
            if (this.m_40614_().equals(BlockRegistry.CATWALK_RAILINGS.get(catstair.metal).get())) {
                Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                double xPos = ctx.m_43720_().f_82479_ - (double)pos.m_123341_() - 0.5;
                double zPos = ctx.m_43720_().f_82481_ - (double)pos.m_123343_() - 0.5;
                boolean left = false;
                if (dir == Direction.NORTH) {
                    boolean bl = left = xPos > 0.0;
                }
                if (dir == Direction.SOUTH) {
                    boolean bl = left = xPos < 0.0;
                }
                if (dir == Direction.EAST) {
                    boolean bl = left = zPos > 0.0;
                }
                if (dir == Direction.WEST) {
                    left = zPos < 0.0;
                }
                if (((Boolean)state.m_61143_((Property)(left ? CatwalkStairBlock.RAILING_LEFT : CatwalkStairBlock.RAILING_RIGHT))).booleanValue()) {
                    return InteractionResult.PASS;
                }
                SoundType soundType = state.m_60827_();
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)(left ? CatwalkStairBlock.RAILING_LEFT : CatwalkStairBlock.RAILING_RIGHT), (Comparable)Boolean.valueOf(true)), 3);
                level.m_5594_(player, pos, this.m_40587_(state), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
                level.m_220407_(GameEvent.f_157797_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        PlacementOffset offset = null;
        if (helper.matchesState(state)) {
            offset = helper.getOffset(player, level, state, pos, ray);
        }
        if (offset != null && offset.isSuccessful() && !player.m_6144_()) {
            state = offset.getGhostState();
            BlockPos offsetPos = offset.getBlockPos();
            SoundType soundType = state.m_60827_();
            level.m_7731_(offsetPos, (BlockState)offset.getTransform().apply(state), 3);
            level.m_5594_(player, offsetPos, this.m_40587_(state), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
            level.m_220407_(GameEvent.f_157797_, offsetPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(ctx);
    }

    @MethodsReturnNonnullByDefault
    public static class RailingHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return CatwalkRailingBlock::isRailing;
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> true;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction face = ray.m_82434_();
            BlockState adjacent = world.m_8055_(pos.m_121945_(face));
            if (CatwalkRailingBlock.isRailing(adjacent.m_60734_())) {
                pos = pos.m_121945_(face);
                state = adjacent;
            }
            boolean railMatchTest = player.m_21055_(state.m_60734_().m_5456_());
            if (!CatwalkRailingBlock.isRailing(state.m_60734_()) || ((Boolean)state.m_61143_((Property)CatwalkRailingBlock.NORTH_FENCE)).booleanValue() && ((Boolean)state.m_61143_((Property)CatwalkRailingBlock.SOUTH_FENCE)).booleanValue() && ((Boolean)state.m_61143_((Property)CatwalkRailingBlock.EAST_FENCE)).booleanValue() && ((Boolean)state.m_61143_((Property)CatwalkRailingBlock.WEST_FENCE)).booleanValue() || !railMatchTest) {
                return PlacementOffset.fail();
            }
            List dirs = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)Direction.Axis.Y);
            for (Direction offset : dirs) {
                if (((Boolean)state.m_61143_((Property)CatwalkRailingBlock.fromDirection(offset))).booleanValue()) continue;
                state = (BlockState)state.m_61124_((Property)CatwalkRailingBlock.fromDirection(offset), (Comparable)Boolean.valueOf(true));
                break;
            }
            BlockState finalState = state;
            return PlacementOffset.success((Vec3i)pos, newState -> finalState).withGhostState(finalState);
        }
    }
}

