/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.module;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.base.item.QuarkMusicDiscItem;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.living.ZLivingDeath;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tools")
public class AmbientDiscsModule
extends ZetaModule {
    @Config
    public static boolean dropOnSpiderKill = true;
    @Config
    public static double volume = 3.0;
    @Hint(key="ambience_discs")
    private final List<Item> discs = new ArrayList<Item>();

    @LoadEvent
    public void register(ZRegister event) {
        this.disc(QuarkSounds.AMBIENT_DRIPS);
        this.disc(QuarkSounds.AMBIENT_OCEAN);
        this.disc(QuarkSounds.AMBIENT_RAIN);
        this.disc(QuarkSounds.AMBIENT_WIND);
        this.disc(QuarkSounds.AMBIENT_FIRE);
        this.disc(QuarkSounds.AMBIENT_CLOCK);
        this.disc(QuarkSounds.AMBIENT_CRICKETS);
        this.disc(QuarkSounds.AMBIENT_CHATTER);
    }

    private void disc(SoundEvent sound) {
        String name = sound.m_11660_().m_135815_().replaceAll(".+\\.", "");
        this.discs.add((Item)new QuarkMusicDiscItem(15, () -> sound, name, this, Integer.MAX_VALUE));
    }

    @PlayEvent
    public void onMobDeath(ZLivingDeath event) {
        if (dropOnSpiderKill && event.getEntity() instanceof Spider && event.getSource().m_7639_() instanceof Skeleton) {
            Item item = this.discs.get(event.getEntity().m_9236_().f_46441_.m_188503_(this.discs.size()));
            event.getEntity().m_20000_((ItemLike)item, 0);
        }
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends AmbientDiscsModule {
        public static void onJukeboxLoad(JukeboxBlockEntity tile) {
            Minecraft mc = Minecraft.m_91087_();
            LevelRenderer render = mc.f_91060_;
            BlockPos pos = tile.m_58899_();
            SoundInstance sound = (SoundInstance)render.f_109410_.get(pos);
            SoundManager soundEngine = mc.m_91106_();
            if (sound == null || !soundEngine.m_120403_(sound)) {
                if (sound != null) {
                    soundEngine.m_120367_(sound);
                } else {
                    ItemStack stack = tile.m_272036_();
                    Item item = stack.m_41720_();
                    if (item instanceof QuarkMusicDiscItem) {
                        QuarkMusicDiscItem disc = (QuarkMusicDiscItem)item;
                        Client.playAmbientSound(disc, pos);
                    }
                }
            }
        }

        public static boolean playAmbientSound(QuarkMusicDiscItem disc, BlockPos pos) {
            if (disc.isAmbient) {
                Minecraft mc = Minecraft.m_91087_();
                SoundManager soundEngine = mc.m_91106_();
                LevelRenderer render = mc.f_91060_;
                SimpleSoundInstance simplesound = new SimpleSoundInstance(disc.soundSupplier.get().m_11660_(), SoundSource.RECORDS, (float)volume, 1.0f, SoundInstance.m_235150_(), true, 0, SoundInstance.Attenuation.LINEAR, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), false);
                render.f_109410_.put(pos, simplesound);
                soundEngine.m_120367_((SoundInstance)simplesound);
                if (mc.f_91073_ != null) {
                    mc.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + Math.random(), Math.random(), 0.0, 0.0);
                }
                return true;
            }
            return false;
        }
    }
}

